/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bsc.langgraph4j.agentexecutor.AgentAction;
import org.bsc.langgraph4j.agentexecutor.IntermediateStep;

public class Agent {
    private final ChatLanguageModel chatLanguageModel;
    private final StreamingChatLanguageModel streamingChatLanguageModel;
    private final List<ToolSpecification> tools;

    public boolean isStreaming() {
        return this.streamingChatLanguageModel != null;
    }

    private List<ChatMessage> prepareMessages(String input, List<IntermediateStep> intermediateSteps) {
        Prompt userMessageTemplate = PromptTemplate.from((String)"{{input}}").apply(Map.of("input", input));
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add((ChatMessage)new SystemMessage("You are a helpful assistant"));
        messages.add((ChatMessage)new UserMessage(userMessageTemplate.text()));
        if (!intermediateSteps.isEmpty()) {
            List toolRequests = intermediateSteps.stream().map(IntermediateStep::action).map(AgentAction::toolExecutionRequest).collect(Collectors.toList());
            messages.add((ChatMessage)new AiMessage(toolRequests));
            for (IntermediateStep step : intermediateSteps) {
                ToolExecutionRequest toolRequest = step.action().toolExecutionRequest();
                messages.add((ChatMessage)new ToolExecutionResultMessage(toolRequest.id(), toolRequest.name(), step.observation()));
            }
        }
        return messages;
    }

    public void execute(String input, List<IntermediateStep> intermediateSteps, StreamingResponseHandler<AiMessage> handler) {
        Objects.requireNonNull(this.streamingChatLanguageModel, "streamingChatLanguageModel is required!");
        this.streamingChatLanguageModel.generate(this.prepareMessages(input, intermediateSteps), this.tools, handler);
    }

    public Response<AiMessage> execute(String input, List<IntermediateStep> intermediateSteps) {
        Objects.requireNonNull(this.chatLanguageModel, "chatLanguageModel is required!");
        return this.chatLanguageModel.generate(this.prepareMessages(input, intermediateSteps), this.tools);
    }

    Agent(ChatLanguageModel chatLanguageModel, StreamingChatLanguageModel streamingChatLanguageModel, List<ToolSpecification> tools) {
        this.chatLanguageModel = chatLanguageModel;
        this.streamingChatLanguageModel = streamingChatLanguageModel;
        this.tools = tools;
    }

    public static AgentBuilder builder() {
        return new AgentBuilder();
    }

    public static class AgentBuilder {
        private ChatLanguageModel chatLanguageModel;
        private StreamingChatLanguageModel streamingChatLanguageModel;
        private ArrayList<ToolSpecification> tools;

        AgentBuilder() {
        }

        public AgentBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public AgentBuilder streamingChatLanguageModel(StreamingChatLanguageModel streamingChatLanguageModel) {
            this.streamingChatLanguageModel = streamingChatLanguageModel;
            return this;
        }

        public AgentBuilder tool(ToolSpecification tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public AgentBuilder tools(Collection<? extends ToolSpecification> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public AgentBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public Agent build() {
            return new Agent(this.chatLanguageModel, this.streamingChatLanguageModel, switch (this.tools == null ? 0 : this.tools.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.tools.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ToolSpecification>(this.tools));
            });
        }

        public String toString() {
            return "Agent.AgentBuilder(chatLanguageModel=" + this.chatLanguageModel + ", streamingChatLanguageModel=" + this.streamingChatLanguageModel + ", tools=" + this.tools + ")";
        }
    }
}

