/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.btrplace.model.ElementBuilder;
import org.btrplace.model.Instance;
import org.btrplace.model.Mapping;
import org.btrplace.model.Model;
import org.btrplace.model.Node;
import org.btrplace.model.SynchronizedElementBuilder;
import org.btrplace.model.VM;
import org.btrplace.model.constraint.Constraint;
import org.btrplace.model.constraint.Running;
import org.btrplace.model.constraint.SatConstraint;
import org.btrplace.scheduler.SchedulerException;
import org.btrplace.scheduler.choco.Parameters;
import org.btrplace.scheduler.runner.disjoint.StaticPartitioning;
import org.btrplace.scheduler.runner.disjoint.model.SubModel;
import org.btrplace.scheduler.runner.disjoint.splitter.ConstraintSplitterMapper;

public class FixedNodeSetsPartitioning
extends StaticPartitioning {
    private Collection<Collection<Node>> partitions;
    private ConstraintSplitterMapper cstrMapper;

    public FixedNodeSetsPartitioning(Collection<Collection<Node>> parts) {
        if (!FixedNodeSetsPartitioning.isDisjoint(parts)) {
            throw new IllegalArgumentException("The constraint expects disjoint sets of nodes");
        }
        this.partitions = parts;
        this.cstrMapper = ConstraintSplitterMapper.newBundle();
    }

    public ConstraintSplitterMapper getSplitterMapper() {
        return this.cstrMapper;
    }

    public void setSplitterMapper(ConstraintSplitterMapper m) {
        this.cstrMapper = m;
    }

    public Collection<Collection<Node>> getPartitions() {
        return this.partitions;
    }

    public boolean setPartitions(Collection<Collection<Node>> parts) {
        if (!FixedNodeSetsPartitioning.isDisjoint(parts)) {
            return false;
        }
        this.partitions = parts;
        return true;
    }

    @Override
    public List<Instance> split(Parameters ps, Instance i) throws SchedulerException {
        Model mo = i.getModel();
        SynchronizedElementBuilder eb = new SynchronizedElementBuilder((ElementBuilder)mo);
        ArrayList<Instance> parts = new ArrayList<Instance>(this.partitions.size());
        int nbVMs = i.getModel().getMapping().getNbVMs();
        int nbNodes = i.getModel().getMapping().getNbNodes();
        TIntIntHashMap vmPosition = new TIntIntHashMap(nbVMs);
        TIntIntHashMap nodePosition = new TIntIntHashMap(nbNodes);
        int partNumber = 0;
        Set<VM> toLaunch = this.getVMsToLaunch(i);
        for (Collection<Node> s : this.partitions) {
            SubModel partModel = new SubModel(mo, (ElementBuilder)eb, s, new HashSet<VM>(toLaunch.size() / this.partitions.size()));
            parts.add(new Instance((Model)partModel, (Collection)new THashSet(), i.getOptConstraint()));
            partModel.getMapping().fillVMIndex(vmPosition, partNumber);
            for (Node n : s) {
                nodePosition.put(n.id(), partNumber);
            }
            ++partNumber;
        }
        int p = 0;
        for (VM v : toLaunch) {
            if (!((Instance)parts.get(p)).getModel().getMapping().addReadyVM(v)) {
                throw new SchedulerException(((Instance)parts.get(p)).getModel(), "Unable to dispatch the VM to launch '" + v + "'");
            }
            vmPosition.put(v.id(), p);
            p = (p + 1) % parts.size();
        }
        for (SatConstraint cstr : i.getSatConstraints()) {
            if (this.cstrMapper.split((Constraint)cstr, i, parts, vmPosition, nodePosition)) continue;
            throw new SchedulerException(i.getModel(), "Unable to split " + cstr);
        }
        return parts;
    }

    private Set<VM> getVMsToLaunch(Instance i) {
        Mapping m = i.getModel().getMapping();
        THashSet toLaunch = new THashSet();
        for (SatConstraint cstr : i.getSatConstraints()) {
            if (!(cstr instanceof Running)) continue;
            for (VM v : cstr.getInvolvedVMs()) {
                if (!m.isReady(v)) continue;
                m.remove(v);
                toLaunch.add(v);
            }
        }
        return toLaunch;
    }

    private static boolean isDisjoint(Collection<Collection<Node>> p) {
        TIntHashSet all = new TIntHashSet();
        for (Collection<Node> s : p) {
            for (Node n : s) {
                if (all.add(n.id())) continue;
                return false;
            }
        }
        return true;
    }
}

