/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.btrplace.model.Instance;
import org.btrplace.model.Mapping;
import org.btrplace.model.Node;
import org.btrplace.scheduler.SchedulerException;
import org.btrplace.scheduler.choco.Parameters;
import org.btrplace.scheduler.runner.disjoint.FixedNodeSetsPartitioning;

public class FixedSizePartitioning
extends FixedNodeSetsPartitioning {
    private int partSize;
    private boolean random;

    public FixedSizePartitioning(int s) {
        super(Collections.singleton(new HashSet()));
        this.partSize = s;
        this.random = false;
    }

    public int getSize() {
        return this.partSize;
    }

    public void setSize(int s) {
        this.partSize = s;
    }

    @Override
    public List<Instance> split(Parameters ps, Instance i) throws SchedulerException {
        Mapping map = i.getModel().getMapping();
        this.setPartitions(this.random ? this.randomPartitions(ps.getRandomSeed(), map) : this.linearPartitions(map));
        return super.split(ps, i);
    }

    private List<Collection<Node>> linearPartitions(Mapping map) {
        ArrayList<Collection<Node>> partOfNodes = new ArrayList<Collection<Node>>();
        HashSet<Node> curPartition = new HashSet<Node>(this.partSize);
        partOfNodes.add(curPartition);
        for (Node node : map.getAllNodes()) {
            if (curPartition.size() == this.partSize) {
                curPartition = new HashSet(this.partSize);
                partOfNodes.add(curPartition);
            }
            curPartition.add(node);
        }
        return partOfNodes;
    }

    private List<Collection<Node>> randomPartitions(long seed, Mapping map) {
        Random rnd = new Random(seed);
        ArrayList unselectedNodes = new ArrayList(map.getNbNodes());
        unselectedNodes.addAll(map.getOnlineNodes());
        unselectedNodes.addAll(map.getOfflineNodes());
        ArrayList<Collection<Node>> partOfNodes = new ArrayList<Collection<Node>>();
        HashSet<Node> curPartition = new HashSet<Node>(this.partSize);
        partOfNodes.add(curPartition);
        while (!unselectedNodes.isEmpty()) {
            Node n = (Node)unselectedNodes.remove(rnd.nextInt(unselectedNodes.size()));
            if (curPartition.size() == this.partSize) {
                curPartition = new HashSet(this.partSize);
                partOfNodes.add(curPartition);
            }
            curPartition.add(n);
        }
        return partOfNodes;
    }

    public void randomPickUp(boolean b) {
        this.random = b;
    }

    public boolean randomPickUp() {
        return this.random;
    }
}

