/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.btrplace.model.Instance;
import org.btrplace.plan.DefaultReconfigurationPlan;
import org.btrplace.plan.ReconfigurationPlan;
import org.btrplace.plan.event.Action;
import org.btrplace.scheduler.SchedulerException;
import org.btrplace.scheduler.choco.Parameters;
import org.btrplace.scheduler.choco.runner.InstanceSolver;
import org.btrplace.scheduler.choco.runner.SolvingStatistics;
import org.btrplace.scheduler.choco.runner.single.InstanceSolverRunner;
import org.btrplace.scheduler.runner.disjoint.StaticPartitioningStatistics;

public abstract class StaticPartitioning
implements InstanceSolver {
    private int workersCount = Runtime.getRuntime().availableProcessors();
    private StaticPartitioningStatistics stats;

    public int getWorkersCount() {
        return this.workersCount;
    }

    public void setWorkersCount(int s) {
        this.workersCount = s;
    }

    public ReconfigurationPlan solve(Parameters cra, Instance orig) throws SchedulerException {
        this.stats = new StaticPartitioningStatistics(cra, orig, System.currentTimeMillis(), this.workersCount);
        long d = -System.currentTimeMillis();
        List<Instance> partitions = this.split(cra, orig);
        this.stats.setSplittingStatistics(partitions.size(), d += System.currentTimeMillis());
        ExecutorService exe = Executors.newFixedThreadPool(this.workersCount);
        ExecutorCompletionService completionService = new ExecutorCompletionService(exe);
        ArrayList<SolvingStatistics> results = new ArrayList<SolvingStatistics>(partitions.size());
        long duration = -System.currentTimeMillis();
        for (Instance partition : partitions) {
            completionService.submit(new InstanceSolverRunner(cra, partition));
        }
        for (int i = 0; i < partitions.size(); ++i) {
            try {
                results.add((SolvingStatistics)completionService.take().get());
                continue;
            }
            catch (ExecutionException ignore) {
                Throwable cause = ignore.getCause();
                if (cause == null) continue;
                throw new SchedulerException(null, cause.getMessage(), (Throwable)ignore);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SchedulerException(orig.getModel(), e.getMessage(), (Throwable)e);
            }
        }
        this.stats.setSolvingDuration(duration += System.currentTimeMillis());
        exe.shutdown();
        return this.merge(orig, results);
    }

    private ReconfigurationPlan merge(Instance i, Collection<SolvingStatistics> results) throws SchedulerException {
        DefaultReconfigurationPlan plan = new DefaultReconfigurationPlan(i.getModel());
        for (SolvingStatistics result : results) {
            this.getStatistics().addPartitionStatistics(result);
            ReconfigurationPlan p = result.lastSolution();
            if (p == null) {
                return null;
            }
            for (Action a : p) {
                if (plan.add(a)) continue;
                throw new SchedulerException(plan.getOrigin(), "Unable to add action '" + a + "' while merging the sub-plans");
            }
        }
        return plan;
    }

    public StaticPartitioningStatistics getStatistics() {
        return this.stats;
    }

    public abstract List<Instance> split(Parameters var1, Instance var2) throws SchedulerException;
}

