/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.btrplace.model.Element;
import org.btrplace.scheduler.runner.disjoint.model.SplittableElementSet;

public class ElementSubSet<E extends Element>
implements Set<E> {
    private int from;
    private int to;
    private int curIdx;
    private SplittableElementSet<E> index;

    public ElementSubSet(SplittableElementSet<E> parent, int key, int lb, int ub) {
        this.index = parent;
        this.curIdx = key;
        this.from = lb;
        this.to = ub;
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public boolean isEmpty() {
        return this.to == this.from;
    }

    @Override
    public boolean contains(Object o) {
        try {
            Element x = (Element)o;
            return this.index.getRespectiveIndex().get(x.id()) == this.curIdx;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new IndexEntryIterator<E>(this.index.getValues(), this.from, this.to);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{").append(this.index.getValues().get(this.from));
        for (int i = this.from + 1; i < this.to; ++i) {
            b.append(", ").append(this.index.getValues().get(i));
        }
        return b.append('}').toString();
    }

    public static class IndexEntryIterator<E>
    implements Iterator<E> {
        private List<E> values;
        private int to;
        private int cursor;

        public IndexEntryIterator(List<E> v, int lb, int ub) {
            this.values = v;
            this.to = ub;
            this.cursor = lb;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.to;
        }

        @Override
        public E next() {
            if (this.cursor == this.to) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

