/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.model;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.btrplace.model.Element;
import org.btrplace.model.Node;
import org.btrplace.model.VM;
import org.btrplace.scheduler.runner.disjoint.model.ElementSubSet;
import org.btrplace.scheduler.runner.disjoint.model.IterateProcedure;

public class SplittableElementSet<E extends Element>
implements Comparator<E> {
    private TIntIntHashMap index;
    private List<E> values = new ArrayList();

    public SplittableElementSet(Collection<E> c, TIntIntHashMap idx) {
        for (Element e : c) {
            this.values.add(e);
        }
        this.index = idx;
        this.values.parallelStream().sorted(this);
        Collections.sort(this.values, this);
    }

    public static SplittableElementSet<VM> newVMIndex(Collection<VM> c, TIntIntHashMap idx) {
        return new SplittableElementSet<VM>(c, idx);
    }

    public static SplittableElementSet<Node> newNodeIndex(Collection<Node> c, TIntIntHashMap idx) {
        return new SplittableElementSet<Node>(c, idx);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{");
        this.forEachPartition((idx, k, from, to) -> {
            b.append('{');
            b.append(this.values.get(from));
            for (int i = from + 1; i < to; ++i) {
                b.append(", ").append(this.values.get(i));
            }
            b.append('}');
            return true;
        });
        return b.append('}').toString();
    }

    public boolean forEachPartition(IterateProcedure<E> p) {
        int to;
        int curIdx = this.index.get(((Element)this.values.get(0)).id());
        int from = 0;
        for (to = 0; to < this.values.size(); ++to) {
            int cIdx = this.index.get(((Element)this.values.get(to)).id());
            if (curIdx == cIdx) continue;
            if (!p.extract(this, curIdx, from, to)) {
                return false;
            }
            from = to;
            curIdx = cIdx;
        }
        return p.extract(this, curIdx, from, to);
    }

    public Set<E> getSubSet(int k) {
        int from = -1;
        for (int x = 0; x < this.values.size(); ++x) {
            int cIdx = this.index.get(((Element)this.values.get(x)).id());
            if (cIdx == k && from == -1) {
                from = x;
            }
            if (from < 0 || cIdx <= k) continue;
            return new ElementSubSet(this, k, from, x);
        }
        if (from >= 0) {
            return new ElementSubSet(this, k, from, this.values.size());
        }
        return Collections.emptySet();
    }

    @Override
    public int compare(E o1, E o2) {
        return this.index.get(o1.id()) - this.index.get(o2.id());
    }

    public TIntIntHashMap getRespectiveIndex() {
        return this.index;
    }

    public List<E> getValues() {
        return this.values;
    }

    public List<ElementSubSet<E>> getPartitions() {
        ArrayList<ElementSubSet<E>> partitions = new ArrayList<ElementSubSet<E>>();
        this.forEachPartition((idx, key, from, to) -> {
            partitions.add(new ElementSubSet(this, key, from, to));
            return true;
        });
        return partitions;
    }

    public int size() {
        return this.values.size();
    }
}

