/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.model;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.btrplace.model.AbstractMapping;
import org.btrplace.model.DefaultMapping;
import org.btrplace.model.Mapping;
import org.btrplace.model.Node;
import org.btrplace.model.VM;

public class SubMapping
extends AbstractMapping {
    private Mapping parent;
    private Set<Node> scope;
    private Set<VM> ready;
    private Set<VM> all = null;

    public SubMapping(Mapping p, Collection<Node> sc, Set<VM> subReady) {
        this.parent = p;
        this.scope = new THashSet(sc);
        this.ready = subReady;
    }

    public SubMapping(Mapping p, Collection<Node> sc) {
        this(p, sc, Collections.emptySet());
    }

    public boolean addRunningVM(VM vm, Node n) {
        return !this.containsElsewhere(vm) && this.scope.contains(n) && this.parent.addRunningVM(vm, n);
    }

    public boolean addSleepingVM(VM vm, Node n) {
        return !this.containsElsewhere(vm) && this.scope.contains(n) && this.parent.addSleepingVM(vm, n);
    }

    public boolean addReadyVM(VM vm) {
        if (!this.containsElsewhere(vm)) {
            this.ready.add(vm);
            this.parent.addReadyVM(vm);
            return true;
        }
        return false;
    }

    public boolean remove(VM vm) {
        if (this.contains(vm)) {
            this.ready.remove(vm);
            return this.parent.remove(vm);
        }
        return false;
    }

    public boolean remove(Node n) {
        throw new UnsupportedOperationException();
    }

    public Set<Node> getOnlineNodes() {
        return this.onlyMyNodes(this.parent.getOnlineNodes());
    }

    public boolean addOnlineNode(Node n) {
        return !this.containsElsewhere(n) && this.parent.addOnlineNode(n);
    }

    public boolean addOfflineNode(Node n) {
        return !this.containsElsewhere(n) && this.parent.addOfflineNode(n);
    }

    public Set<Node> getOfflineNodes() {
        return this.onlyMyNodes(this.parent.getOfflineNodes());
    }

    private Set<Node> onlyMyNodes(Set<Node> ns) {
        THashSet my = new THashSet();
        for (Node n : ns) {
            if (!this.scope.contains(n)) continue;
            my.add(n);
        }
        return my;
    }

    public Set<VM> getRunningVMs() {
        return this.parent.getRunningVMs(this.scope);
    }

    public Set<VM> getSleepingVMs() {
        return this.parent.getSleepingVMs(this.scope);
    }

    public Set<VM> getSleepingVMs(Node n) {
        if (this.scope.contains(n)) {
            return this.parent.getSleepingVMs(n);
        }
        return Collections.emptySet();
    }

    public Set<VM> getRunningVMs(Node n) {
        if (this.scope.contains(n)) {
            return this.parent.getRunningVMs(n);
        }
        return Collections.emptySet();
    }

    public Set<VM> getReadyVMs() {
        return this.ready;
    }

    public Set<VM> getAllVMs() {
        if (this.all == null) {
            this.all = new THashSet();
            for (Node n : this.scope) {
                this.all.addAll(this.parent.getRunningVMs(n));
                this.all.addAll(this.parent.getSleepingVMs(n));
            }
            this.all.addAll(this.ready);
        }
        return this.all;
    }

    public Set<Node> getAllNodes() {
        return this.scope;
    }

    public Node getVMLocation(VM vm) {
        Node n = this.parent.getVMLocation(vm);
        if (this.scope.contains(n)) {
            return n;
        }
        return null;
    }

    public Set<VM> getRunningVMs(Collection<Node> ns) {
        THashSet res = new THashSet();
        for (Node n : ns) {
            if (!this.scope.contains(n)) continue;
            res.addAll(this.parent.getRunningVMs(n));
        }
        return res;
    }

    public DefaultMapping copy() {
        DefaultMapping c = new DefaultMapping();
        for (Node n : this.scope) {
            if (this.parent.getOnlineNodes().contains(n)) {
                c.addOnlineNode(n);
                for (VM v : this.parent.getRunningVMs(n)) {
                    c.addRunningVM(v, n);
                }
                for (VM v : this.parent.getSleepingVMs(n)) {
                    c.addSleepingVM(v, n);
                }
                continue;
            }
            if (!this.parent.getOfflineNodes().contains(n)) continue;
            c.addOfflineNode(n);
        }
        for (VM v : this.ready) {
            c.addReadyVM(v);
        }
        return c;
    }

    public boolean contains(VM vm) {
        return this.ready.contains(vm) || this.scope.contains(this.parent.getVMLocation(vm));
    }

    private boolean containsElsewhere(VM vm) {
        return this.parent.contains(vm) && !this.ready.contains(vm) && !this.scope.contains(this.parent.getVMLocation(vm));
    }

    private boolean containsElsewhere(Node n) {
        return this.parent.contains(n) && !this.contains(n);
    }

    public boolean contains(Node n) {
        return this.scope.contains(n) && (this.parent.isOnline(n) || this.parent.isOffline(n));
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void clearNode(Node u) {
        throw new UnsupportedOperationException();
    }

    public void clearAllVMs() {
        throw new UnsupportedOperationException();
    }

    public void fillVMIndex(TIntIntHashMap index, int p) {
        for (Node n : this.scope) {
            for (VM v : this.parent.getRunningVMs(n)) {
                index.put(v.id(), p);
            }
            for (VM v : this.parent.getSleepingVMs(n)) {
                index.put(v.id(), p);
            }
        }
        for (VM v : this.ready) {
            index.put(v.id(), p);
        }
    }

    public boolean isRunning(VM v) {
        return this.scope.contains(this.parent.getVMLocation(v)) && this.parent.isRunning(v);
    }

    public boolean isSleeping(VM v) {
        return this.scope.contains(this.parent.getVMLocation(v)) && this.parent.isSleeping(v);
    }

    public boolean isReady(VM v) {
        return this.ready.contains(v);
    }

    public boolean isOnline(Node n) {
        return this.scope.contains(n) && this.parent.isOnline(n);
    }

    public boolean isOffline(Node n) {
        return this.scope.contains(n) && this.parent.isOffline(n);
    }

    public Set<VM> getSleepingVMs(Collection<Node> ns) {
        THashSet res = new THashSet();
        for (Node n : ns) {
            if (!this.scope.contains(n)) continue;
            res.addAll(this.parent.getSleepingVMs(n));
        }
        return res;
    }

    public Mapping getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Node n : this.scope) {
            if (this.parent.isOnline(n)) {
                buf.append(n);
                buf.append(':');
                if (this.getRunningVMs(n).isEmpty() && this.getSleepingVMs(n).isEmpty()) {
                    buf.append(" - ");
                }
                for (VM vm : this.getRunningVMs(n)) {
                    buf.append(' ').append(vm);
                }
                for (VM vm : this.getSleepingVMs(n)) {
                    buf.append(" (").append(vm).append(')');
                }
                buf.append('\n');
                continue;
            }
            if (!this.parent.isOffline(n)) continue;
            buf.append('(').append(n).append(")\n");
        }
        buf.append("READY");
        for (VM vm : this.ready) {
            buf.append(' ').append(vm);
        }
        return buf.append('\n').toString();
    }

    public int getNbNodes() {
        return this.scope.size();
    }

    public int getNbVMs() {
        int nb = this.ready.size();
        for (Node n : this.scope) {
            nb += this.getRunningVMs(n).size();
            nb += this.getSleepingVMs(n).size();
        }
        return nb;
    }
}

