/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.btrplace.model.Attributes;
import org.btrplace.model.DefaultModel;
import org.btrplace.model.ElementBuilder;
import org.btrplace.model.Mapping;
import org.btrplace.model.MappingUtils;
import org.btrplace.model.Model;
import org.btrplace.model.Node;
import org.btrplace.model.VM;
import org.btrplace.model.view.ModelView;
import org.btrplace.scheduler.runner.disjoint.model.SubMapping;

public class SubModel
implements Model {
    private Model parent;
    private Collection<Node> scope;
    private SubMapping sm;
    private ElementBuilder eb;

    public SubModel(Model p, ElementBuilder b, Collection<Node> ns) {
        this(p, b, ns, Collections.emptySet());
    }

    public SubModel(Model p, ElementBuilder b, Collection<Node> nodeScope, Set<VM> vmReady) {
        this.scope = nodeScope;
        this.parent = p;
        this.eb = b;
        this.sm = new SubMapping(p.getMapping(), this.scope, vmReady);
    }

    public Collection<Node> getScope() {
        return this.scope;
    }

    public ModelView getView(String id) {
        return this.parent.getView(id);
    }

    public Collection<ModelView> getViews() {
        return this.parent.getViews();
    }

    public boolean attach(ModelView v) {
        throw new UnsupportedOperationException();
    }

    public boolean detach(ModelView v) {
        throw new UnsupportedOperationException();
    }

    public void clearViews() {
        throw new UnsupportedOperationException();
    }

    public SubMapping getMapping() {
        return this.sm;
    }

    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    public void setAttributes(Attributes attrs) {
        throw new UnsupportedOperationException();
    }

    public Model copy() {
        DefaultModel m = new DefaultModel((ElementBuilder)this.eb.copy());
        MappingUtils.fill((Mapping)this.sm, (Mapping)m.getMapping());
        for (ModelView rc : this.parent.getViews()) {
            m.attach((ModelView)rc.copy());
        }
        m.setAttributes((Attributes)this.getAttributes().copy());
        return m;
    }

    public VM newVM() {
        VM v = this.eb.newVM();
        if (v != null) {
            this.parent.newVM(v.id());
        }
        return v;
    }

    public VM newVM(int id) {
        VM v = this.eb.newVM(id);
        if (v != null) {
            this.parent.newVM(id);
        }
        return v;
    }

    public Node newNode() {
        Node n = this.eb.newNode();
        if (n != null) {
            this.parent.newNode(n.id());
        }
        return n;
    }

    public Node newNode(int id) {
        Node n = this.eb.newNode(id);
        if (n != null) {
            this.parent.newNode(id);
        }
        return n;
    }

    public boolean contains(VM v) {
        return this.parent.contains(v);
    }

    public boolean contains(Node n) {
        return this.parent.contains(n);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mapping:\n");
        b.append((Object)this.getMapping());
        b.append("\nAttributes:\n");
        b.append(this.getAttributes());
        b.append("\nViews:\n");
        for (ModelView entry : this.parent.getViews()) {
            b.append(entry.getIdentifier()).append(": ");
            b.append(entry.toString()).append("\n");
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model that = (Model)o;
        if (!this.sm.equals(that.getMapping())) {
            return false;
        }
        if (!this.parent.getAttributes().equals(that.getAttributes())) {
            return false;
        }
        Collection thatViews = that.getViews();
        return this.getViews().equals(thatViews);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sm, this.parent.getViews(), this.parent.getAttributes()});
    }
}

