/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.splitter;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.btrplace.model.Instance;
import org.btrplace.model.constraint.Constraint;
import org.btrplace.scheduler.runner.disjoint.splitter.AmongSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.BanSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.ConstraintSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.FenceSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.GatherSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.KilledSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.LonelySplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.OfflineSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.OnlineSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.OverbookSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.PreserveSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.QuarantineSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.ReadySplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.RootSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.RunningSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.SeqSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.SleepingSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.SplitSplitter;
import org.btrplace.scheduler.runner.disjoint.splitter.SpreadSplitter;

public class ConstraintSplitterMapper {
    private Map<Class<? extends Constraint>, ConstraintSplitter<? extends Constraint>> builders = new HashMap<Class<? extends Constraint>, ConstraintSplitter<? extends Constraint>>();

    public static ConstraintSplitterMapper newBundle() {
        ConstraintSplitterMapper mapper = new ConstraintSplitterMapper();
        mapper.register(new AmongSplitter());
        mapper.register(new BanSplitter());
        mapper.register(new FenceSplitter());
        mapper.register(new GatherSplitter());
        mapper.register(new KilledSplitter());
        mapper.register(new LonelySplitter());
        mapper.register(new OfflineSplitter());
        mapper.register(new OnlineSplitter());
        mapper.register(new OverbookSplitter());
        mapper.register(new PreserveSplitter());
        mapper.register(new QuarantineSplitter());
        mapper.register(new ReadySplitter());
        mapper.register(new RootSplitter());
        mapper.register(new RunningSplitter());
        mapper.register(new SeqSplitter());
        mapper.register(new SleepingSplitter());
        mapper.register(new SplitSplitter());
        mapper.register(new SpreadSplitter());
        return mapper;
    }

    public boolean register(ConstraintSplitter<? extends Constraint> ccb) {
        return this.builders.put(ccb.getKey(), ccb) == null;
    }

    public boolean unRegister(Class<? extends Constraint> c) {
        return this.builders.remove(c) != null;
    }

    public boolean isRegistered(Class<? extends Constraint> c) {
        return this.builders.containsKey(c);
    }

    public ConstraintSplitter<? extends Constraint> getSplitter(Class<? extends Constraint> c) {
        return this.builders.get(c);
    }

    public boolean split(Constraint c, Instance i, List<Instance> partitions, TIntIntHashMap vmPartition, TIntIntHashMap nodePosition) {
        ConstraintSplitter<? extends Constraint> splitter = this.builders.get(c.getClass());
        return splitter != null && splitter.split((Constraint)c, i, partitions, vmPartition, nodePosition);
    }
}

