/*
 * Decompiled with CFR 0.152.
 */
package org.btrplace.scheduler.runner.disjoint.splitter;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.btrplace.model.Instance;
import org.btrplace.model.VM;
import org.btrplace.model.constraint.Split;
import org.btrplace.scheduler.runner.disjoint.model.SplittableElementSet;
import org.btrplace.scheduler.runner.disjoint.splitter.ConstraintSplitter;

public class SplitSplitter
implements ConstraintSplitter<Split> {
    @Override
    public Class<Split> getKey() {
        return Split.class;
    }

    @Override
    public boolean split(Split cstr, Instance origin, List<Instance> partitions, TIntIntHashMap vmsPosition, TIntIntHashMap nodePosition) {
        boolean c = cstr.isContinuous();
        return SplittableElementSet.newVMIndex(cstr.getInvolvedVMs(), vmsPosition).forEachPartition((index, idx, from, to) -> {
            if (to - from >= 2) {
                ArrayList<Set<VM>> sets = new ArrayList<Set<VM>>();
                for (Collection vms : cstr.getSets()) {
                    SplittableElementSet<VM> subSplit = SplittableElementSet.newVMIndex(vms, vmsPosition);
                    Set<VM> s = subSplit.getSubSet(idx);
                    if (s.isEmpty()) continue;
                    sets.add(s);
                }
                if (sets.size() > 1) {
                    ((Instance)partitions.get(idx)).getSatConstraints().add(new Split(sets, c));
                }
            }
            return true;
        });
    }
}

