/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.Context;
import org.burningwave.Throwables;
import org.burningwave.function.TriPredicate;
import org.burningwave.reflection.Constructors;

public class Criteria<E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> {
    protected Function<BiPredicate<T, E>, BiPredicate<T, E>> logicalOperator;
    protected BiPredicate<T, E> predicate;

    public static final <E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> Criteria<E, C, T> of(BiPredicate<T, E> predicate) {
        return new Criteria<E, C, T>().allThoseThatMatch(predicate);
    }

    public static final <E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> Criteria<E, C, T> of(Predicate<E> predicate) {
        return new Criteria<E, C, T>().allThoseThatMatch(predicate);
    }

    public C allThoseThatMatch(BiPredicate<T, E> predicate) {
        this.predicate = this.concat(this.predicate, (context, entity) -> predicate.test(context, entity));
        return (C)this;
    }

    public C allThoseThatMatch(Predicate<E> predicate) {
        return this.allThoseThatMatch((T context, E entity) -> predicate.test(entity));
    }

    public C and() {
        this.logicalOperator = predicate -> this.predicate.and((BiPredicate<T, E>)predicate);
        return (C)this;
    }

    public C and(C criteria) {
        return this.logicOperation(this.createCopy(), ((Criteria)criteria).createCopy(), predicate -> predicate::and, this.newInstance());
    }

    public C createCopy() {
        C copy = this.newInstance();
        ((Criteria)copy).predicate = this.predicate;
        ((Criteria)copy).logicalOperator = this.logicalOperator;
        return copy;
    }

    public Predicate<E> getPredicateOrFalsePredicateIfPredicateIsNull() {
        return this.getPredicate(this.createTestContext(), false);
    }

    public Predicate<E> getPredicateOrTruePredicateIfPredicateIsNull() {
        return this.getPredicate(this.createTestContext(), true);
    }

    public boolean hasNoPredicate() {
        return this.predicate == null;
    }

    public C or() {
        this.logicalOperator = predicate -> this.predicate.or((BiPredicate<T, E>)predicate);
        return (C)this;
    }

    public C or(C criteria) {
        return this.logicOperation(this.createCopy(), ((Criteria)criteria).createCopy(), predicate -> predicate::or, this.newInstance());
    }

    public T testWithFalseResultForNullEntityOrFalseResultForNullPredicate(E entity) {
        T context = this.createTestContext();
        this.testWithFalseResultForNullEntityOrFalseResultForNullPredicate(context, entity);
        return context;
    }

    public T testWithFalseResultForNullEntityOrTrueResultForNullPredicate(E entity) {
        T context = this.createTestContext();
        this.testWithFalseResultForNullEntityOrTrueResultForNullPredicate(context, entity);
        return context;
    }

    public T testWithTrueResultForNullEntityOrFalseResultForNullPredicate(E entity) {
        T context = this.createTestContext();
        this.testWithTrueResultForNullEntityOrFalseResultForNullPredicate(context, entity);
        return context;
    }

    public T testWithTrueResultForNullEntityOrTrueResultForNullPredicate(E entity) {
        T context = this.createTestContext();
        this.testWithTrueResultForNullEntityOrTrueResultForNullPredicate(context, entity);
        return context;
    }

    protected BiPredicate<T, E> concat(BiPredicate<T, E> mainPredicate, BiPredicate<T, E> otherPredicate) {
        BiPredicate<T, E> predicate = this.concat(mainPredicate, this.logicalOperator, otherPredicate);
        this.logicalOperator = null;
        return predicate;
    }

    protected <E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> BiPredicate<T, E> concat(BiPredicate<T, E> mainPredicate, Function<BiPredicate<T, E>, BiPredicate<T, E>> logicalOperator, BiPredicate<T, E> otherPredicate) {
        return Optional.ofNullable(otherPredicate).map(othPred -> Optional.ofNullable(mainPredicate).map(mainPred -> this.consumeLogicalOperator((BiPredicate<T, E>)othPred, logicalOperator)).orElse((BiPredicate)othPred)).orElse(mainPredicate);
    }

    protected T createTestContext() {
        return (T)TestContext.create(this);
    }

    protected T getContextWithFalsePredicateForNullPredicate() {
        T context = this.createTestContext();
        this.getPredicate(context, false);
        return context;
    }

    protected T getContextWithTruePredicateForNullPredicate() {
        T context = this.createTestContext();
        this.getPredicate(context, true);
        return context;
    }

    protected <V> BiPredicate<T, E> getPredicateWrapper(BiFunction<T, E, V[]> valueSupplier, TriPredicate<T, V[], Integer> predicate) {
        return this.getPredicateWrapper((criteria, entity) -> {
            Object[] array = (Object[])valueSupplier.apply(criteria, entity);
            boolean result = false;
            for (int i = 0; i < array.length && !(result = predicate.test(criteria, array, i)); ++i) {
            }
            return result;
        });
    }

    protected C logicOperation(C leftCriteria, C rightCriteria, Function<BiPredicate<T, E>, Function<BiPredicate<? super T, ? super E>, BiPredicate<T, E>>> binaryOperator, C targetCriteria) {
        ((Criteria)targetCriteria).predicate = ((Criteria)leftCriteria).predicate != null ? (((Criteria)rightCriteria).predicate != null ? binaryOperator.apply(((Criteria)leftCriteria).predicate).apply(((Criteria)rightCriteria).predicate) : ((Criteria)leftCriteria).predicate) : ((Criteria)rightCriteria).predicate;
        return targetCriteria;
    }

    protected C newInstance() {
        return (C)((Criteria)Constructors.INSTANCE.newInstanceOf(this.getClass(), new Object[0]));
    }

    <E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> BiPredicate<T, E> consumeLogicalOperator(BiPredicate<T, E> input, Function<BiPredicate<T, E>, BiPredicate<T, E>> logicalOperator) {
        return Optional.ofNullable(logicalOperator).map(logOp -> (BiPredicate)logicalOperator.apply(input)).orElseGet(() -> (BiPredicate)Throwables.INSTANCE.throwException("A call to and/or method is necessary before calling {} at {}", Thread.currentThread().getStackTrace()[10].getMethodName(), Thread.currentThread().getStackTrace()[11]));
    }

    BiPredicate<T, E> getPredicateWrapper(BiPredicate<T, E> function) {
        return Optional.ofNullable(function).map(innPredWrap -> (criteria, entity) -> innPredWrap.test(criteria, entity)).orElse(null);
    }

    private Predicate<E> getPredicate(T context, boolean defaultResult) {
        return ((TestContext)((TestContext)context).setPredicate(this.predicate != null ? entity -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(this.predicate.test((TestContext)context, (E)entity))).getResult() : entity -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(defaultResult)).getResult())).getPredicate();
    }

    private boolean testWithFalseResultForNullEntityOrFalseResultForNullPredicate(T context, E entity) {
        return Optional.ofNullable(entity).map(ent -> this.getPredicate(context, false).test(ent)).orElseGet(() -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(false)).getResult());
    }

    private boolean testWithFalseResultForNullEntityOrTrueResultForNullPredicate(T context, E entity) {
        return Optional.ofNullable(entity).map(ent -> this.getPredicate(context, true).test(ent)).orElseGet(() -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(false)).getResult());
    }

    private boolean testWithTrueResultForNullEntityOrFalseResultForNullPredicate(T context, E entity) {
        return Optional.ofNullable(entity).map(ent -> this.getPredicate(context, false).test(ent)).orElseGet(() -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(true)).getResult());
    }

    private boolean testWithTrueResultForNullEntityOrTrueResultForNullPredicate(T context, E entity) {
        return Optional.ofNullable(entity).map(ent -> this.getPredicate(context, true).test(ent)).orElseGet(() -> ((TestContext)((TestContext)context.setEntity(entity)).setResult(true)).getResult());
    }

    public static class TestContext<E, C extends Criteria<E, C, ?>>
    extends Context {
        protected TestContext(C criteria) {
            this.put(Elements.THIS_CRITERIA, criteria);
        }

        public static <E, C extends Criteria<E, C, T>, T extends TestContext<E, C>> TestContext<E, C> create(C criteria) {
            return new TestContext<E, C>(criteria);
        }

        public C getCriteria() {
            return (C)((Criteria)this.get(Elements.THIS_CRITERIA));
        }

        public E getEntity() {
            return (E)this.get(Elements.ENTITY);
        }

        public Predicate<E> getPredicate() {
            return (Predicate)this.get(Elements.PREDICATE);
        }

        public Boolean getResult() {
            return (Boolean)super.get(Elements.TEST_RESULT);
        }

        <T extends TestContext<E, C>> T setEntity(E entity) {
            this.put(Elements.ENTITY, entity);
            return (T)this;
        }

        <T extends TestContext<E, C>> T setPredicate(Predicate<E> predicate) {
            this.put(Elements.PREDICATE, predicate);
            return (T)this;
        }

        <T extends TestContext<E, C>> T setResult(Boolean result) {
            this.put(Elements.TEST_RESULT, result);
            return (T)this;
        }

        private static enum Elements {
            ENTITY,
            PREDICATE,
            TEST_RESULT,
            THIS_CRITERIA;

        }
    }

    public static class Simple<E, C extends Simple<E, C>> {
        protected Function<Predicate<E>, Predicate<E>> logicalOperator;
        protected Predicate<E> predicate;

        public C allThoseThatMatch(Predicate<E> predicate) {
            this.predicate = this.concat(this.predicate, entity -> predicate.test(entity));
            return (C)this;
        }

        public C and() {
            this.logicalOperator = predicate -> this.predicate.and((Predicate<E>)predicate);
            return (C)this;
        }

        public C and(C criteria) {
            return this.logicOperation(this.createCopy(), ((Simple)criteria).createCopy(), predicate -> predicate::and, this.newInstance());
        }

        public C createCopy() {
            C copy = this.newInstance();
            ((Simple)copy).predicate = this.predicate;
            ((Simple)copy).logicalOperator = this.logicalOperator;
            return copy;
        }

        public Predicate<E> getPredicateOrFalsePredicateIfPredicateIsNull() {
            return this.getPredicate(false);
        }

        public Predicate<E> getPredicateOrTruePredicateIfPredicateIsNull() {
            return this.getPredicate(true);
        }

        public boolean hasNoPredicate() {
            return this.predicate == null;
        }

        public C or() {
            this.logicalOperator = predicate -> this.predicate.or((Predicate<E>)predicate);
            return (C)this;
        }

        public C or(C criteria) {
            return this.logicOperation(this.createCopy(), ((Simple)criteria).createCopy(), predicate -> predicate::or, this.newInstance());
        }

        public boolean testWithFalseResultForNullEntityOrFalseResultForNullPredicate(E entity) {
            return Optional.ofNullable(entity).map(ent -> this.getPredicateOrFalsePredicateIfPredicateIsNull().test(ent)).orElseGet(() -> false);
        }

        public boolean testWithFalseResultForNullEntityOrTrueResultForNullPredicate(E entity) {
            return Optional.ofNullable(entity).map(ent -> this.getPredicateOrTruePredicateIfPredicateIsNull().test(ent)).orElseGet(() -> false);
        }

        public boolean testWithFalseResultForNullPredicate(E entity) {
            return this.getPredicateOrFalsePredicateIfPredicateIsNull().test(entity);
        }

        public boolean testWithTrueResultForNullEntityOrFalseResultForNullPredicate(E entity) {
            return Optional.ofNullable(entity).map(ent -> this.getPredicateOrFalsePredicateIfPredicateIsNull().test(ent)).orElseGet(() -> true);
        }

        public boolean testWithTrueResultForNullEntityOrTrueResultForNullPredicate(E entity) {
            return Optional.ofNullable(entity).map(ent -> this.getPredicateOrTruePredicateIfPredicateIsNull().test(ent)).orElseGet(() -> true);
        }

        public boolean testWithTrueResultForNullPredicate(E entity) {
            return this.getPredicateOrTruePredicateIfPredicateIsNull().test(entity);
        }

        protected <E, C extends Simple<E, C>> Predicate<E> concat(Predicate<E> mainPredicate, Function<Predicate<E>, Predicate<E>> logicalOperator, Predicate<E> otherPredicate) {
            return Optional.ofNullable(otherPredicate).map(othPred -> Optional.ofNullable(mainPredicate).map(mainPred -> this.consumeLogicalOperator((Predicate<E>)othPred, logicalOperator)).orElse((Predicate)othPred)).orElse(mainPredicate);
        }

        protected Predicate<E> concat(Predicate<E> mainPredicate, Predicate<E> otherPredicate) {
            Predicate<E> predicate = this.concat(mainPredicate, this.logicalOperator, otherPredicate);
            this.logicalOperator = null;
            return predicate;
        }

        protected <V> Predicate<E> getPredicateWrapper(Function<E, V[]> valueSupplier, BiPredicate<V[], Integer> predicate) {
            return this.getPredicateWrapper(entity -> {
                Object[] array = (Object[])valueSupplier.apply(entity);
                boolean result = false;
                for (int i = 0; i < array.length && !(result = predicate.test(array, i)); ++i) {
                }
                return result;
            });
        }

        protected C logicOperation(C leftCriteria, C rightCriteria, Function<Predicate<E>, Function<Predicate<? super E>, Predicate<E>>> binaryOperator, C targetCriteria) {
            ((Simple)targetCriteria).predicate = ((Simple)leftCriteria).predicate != null ? (((Simple)rightCriteria).predicate != null ? binaryOperator.apply(((Simple)leftCriteria).predicate).apply(((Simple)rightCriteria).predicate) : ((Simple)leftCriteria).predicate) : ((Simple)rightCriteria).predicate;
            return targetCriteria;
        }

        protected C newInstance() {
            return (C)((Simple)Constructors.INSTANCE.newInstanceOf(this.getClass(), new Object[0]));
        }

        <E, C extends Simple<E, C>> Predicate<E> consumeLogicalOperator(Predicate<E> input, Function<Predicate<E>, Predicate<E>> logicalOperator) {
            return Optional.ofNullable(logicalOperator).map(logOp -> (Predicate)logicalOperator.apply(input)).orElseGet(() -> (Predicate)Throwables.INSTANCE.throwException("A call to and/or method is necessary before calling {} at {}", Thread.currentThread().getStackTrace()[10].getMethodName(), Thread.currentThread().getStackTrace()[11]));
        }

        Predicate<E> getPredicateWrapper(Predicate<E> function) {
            return Optional.ofNullable(function).map(innPredWrap -> entity -> innPredWrap.test(entity)).orElse(null);
        }

        private Predicate<E> getPredicate(boolean defaultResult) {
            return this.predicate != null ? entity -> this.predicate.test(entity) : entity -> defaultResult;
        }
    }
}

