/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class Synchronizer {
    public static final Synchronizer INSTANCE = new Synchronizer();
    Map<String, Mutex> mutexes = new ConcurrentHashMap<String, Mutex>();

    private Synchronizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String id, Runnable executable) {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                executable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String id, Supplier<T> executable) {
        try (Mutex mutex = this.getMutex(id);){
            Mutex mutex2 = mutex;
            synchronized (mutex2) {
                T t = executable.get();
                return t;
            }
        }
    }

    public Mutex getMutex(String id) {
        Mutex oldMutex;
        Mutex newMutex = new Mutex(id);
        do {
            if ((oldMutex = this.mutexes.putIfAbsent(id, newMutex)) != null) continue;
            return newMutex;
        } while (++oldMutex.clientsCount <= 1 || this.mutexes.get(id) != oldMutex);
        return oldMutex;
    }

    public class Mutex
    implements Closeable {
        int clientsCount = 1;
        String id;

        Mutex(String id) {
            this.id = id;
        }

        @Override
        public void close() {
            if (--this.clientsCount < 1) {
                Synchronizer.this.mutexes.remove(this.id);
            }
        }
    }
}

