/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import io.github.toolfactory.jvm.function.template.ThrowingBiConsumer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.Objects;
import org.burningwave.Synchronizer;
import org.burningwave.Throwables;
import org.burningwave.reflection.Members;

public class Cache {
    public static final Cache INSTANCE = new Cache();
    public final PathForResources<Constructor<?>[]> uniqueKeyForConstructorsArray = new PathForResources();
    public final PathForResources<Field[]> uniqueKeyForFieldsArray = new PathForResources();
    public final PathForResources<Method[]> uniqueKeyForMethodsArray = new PathForResources();
    public final PathForResources<Collection<Constructor<?>>> uniqueKeyForConstructors = new PathForResources();
    public final PathForResources<Members.Handler.OfExecutable.Box<?>> uniqueKeyForExecutableAndMethodHandle = new PathForResources();
    public final PathForResources<Collection<Field>> uniqueKeyForAllFields = new PathForResources();
    public final PathForResources<Collection<Method>> uniqueKeyForAllMethods = new PathForResources();

    private Cache() {
    }

    public void clear(boolean destroyItems, Object ... excluded) {
        HashSet<Object> toBeExcluded = excluded != null && excluded.length > 0 ? new HashSet<Object>(Arrays.asList(excluded)) : null;
        HashSet<Thread> tasks = new HashSet<Thread>();
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForConstructorsArray, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForFieldsArray, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForMethodsArray, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForConstructors, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForExecutableAndMethodHandle, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForAllFields, toBeExcluded, destroyItems));
        this.addCleaningTask(tasks, this.clear(this.uniqueKeyForAllMethods, toBeExcluded, destroyItems));
        for (Thread task : tasks) {
            try {
                task.join();
            }
            catch (InterruptedException exc) {
                Throwables.INSTANCE.throwException(exc);
            }
        }
    }

    private boolean addCleaningTask(Set<Thread> tasks, Thread task) {
        if (task != null) {
            return tasks.add(task);
        }
        return false;
    }

    private Thread clear(Object cache, Set<Object> excluded, boolean destroyItems) {
        if (excluded == null || !excluded.contains(cache)) {
            if (cache instanceof ObjectAndPathForResources) {
                return ((ObjectAndPathForResources)cache).clearInBackground(destroyItems);
            }
            if (cache instanceof PathForResources) {
                return ((PathForResources)cache).clearInBackground(destroyItems);
            }
        }
        return null;
    }

    static class PathForResources<R> {
        String instanceId;
        BiConsumer<String, R> itemDestroyer;
        Long partitionStartLevel;
        Map<Long, Map<String, Map<String, R>>> resources;
        Function<R, R> sharer;

        private PathForResources() {
            this(1L, item -> item, null);
        }

        private PathForResources(BiConsumer<String, R> itemDestroyer) {
            this(1L, item -> item, itemDestroyer);
        }

        private PathForResources(Function<R, R> sharer) {
            this(1L, sharer, null);
        }

        private PathForResources(Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
            this(1L, item -> item, itemDestroyer);
        }

        private PathForResources(Long partitionStartLevel) {
            this(partitionStartLevel, item -> item, null);
        }

        private PathForResources(Long partitionStartLevel, BiConsumer<String, R> itemDestroyer) {
            this(partitionStartLevel, item -> item, itemDestroyer);
        }

        private PathForResources(Long partitionStartLevel, Function<R, R> sharer) {
            this(partitionStartLevel, sharer, null);
        }

        private PathForResources(Long partitionStartLevel, Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
            this.partitionStartLevel = partitionStartLevel;
            this.sharer = sharer;
            this.resources = new ConcurrentHashMap<Long, Map<String, Map<String, R>>>();
            this.itemDestroyer = itemDestroyer;
            this.instanceId = this.toString();
        }

        <K, V, E extends Throwable> void deepClear(Map<K, V> map, ThrowingBiConsumer<K, V, E> itemDestroyer) throws E {
            Iterator<Map.Entry<K, V>> itr = map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<K, V> entry = itr.next();
                try {
                    itr.remove();
                    itemDestroyer.accept(entry.getKey(), entry.getValue());
                }
                catch (Throwable throwable) {}
            }
        }

        R get(String path) {
            return this.getOrUploadIfAbsent(path, null);
        }

        int getLoadedResourcesCount() {
            return this.getLoadedResourcesCount(this.resources);
        }

        R getOrUploadIfAbsent(String path, Supplier<R> resourceSupplier) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map<String, R> nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            return this.getOrUploadIfAbsent(nestedPartition, path, resourceSupplier);
        }

        R remove(String path, boolean destroy) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            Object item = Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> nestedPartition.remove(path));
            if (this.itemDestroyer != null && destroy && item != null) {
                String finalPath = path;
                this.itemDestroyer.accept(finalPath, item);
            }
            return (R)item;
        }

        R upload(Map<String, R> loadedResources, String path, Supplier<R> resourceSupplier, boolean destroy) {
            R oldResource = this.remove(path, destroy);
            Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> {
                Object resourceTemp = resourceSupplier.get();
                if (resourceTemp != null) {
                    resourceTemp = this.sharer.apply(resourceTemp);
                    loadedResources.put(path, resourceTemp);
                }
            });
            return oldResource;
        }

        R upload(String path, Supplier<R> resourceSupplier, boolean destroy) {
            Long occurences = path.chars().filter(ch -> ch == 47).count();
            Long partitionIndex = occurences > this.partitionStartLevel ? occurences : this.partitionStartLevel;
            Map<String, Map<String, R>> partion = this.retrievePartition(this.resources, partitionIndex);
            Map<String, R> nestedPartition = this.retrievePartition(partion, partitionIndex, path);
            return this.upload(nestedPartition, path, resourceSupplier, destroy);
        }

        void clearResources(Map<Long, Map<String, Map<String, R>>> partitions, boolean destroyItems) {
            for (Map.Entry<Long, Map<String, Map<String, R>>> partition : partitions.entrySet()) {
                for (Map.Entry<String, Map<String, R>> nestedPartition : partition.getValue().entrySet()) {
                    if (this.itemDestroyer != null && destroyItems) {
                        this.deepClear(nestedPartition.getValue(), (path, resource) -> this.itemDestroyer.accept((String)path, (R)resource));
                        continue;
                    }
                    nestedPartition.getValue().clear();
                }
                partition.getValue().clear();
            }
            partitions.clear();
        }

        R getOrUploadIfAbsent(Map<String, R> loadedResources, String path, Supplier<R> resourceSupplier) {
            Object resource = loadedResources.get(path);
            if (resource == null) {
                resource = Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForLoadedResources_" + path, () -> {
                    Object resourceTemp = loadedResources.get(path);
                    if (resourceTemp == null && resourceSupplier != null && (resourceTemp = resourceSupplier.get()) != null) {
                        resourceTemp = this.sharer.apply(resourceTemp);
                        loadedResources.put(path, resourceTemp);
                    }
                    return resourceTemp;
                });
            }
            return resource != null ? this.sharer.apply(resource) : resource;
        }

        Map<String, Map<String, R>> retrievePartition(Map<Long, Map<String, Map<String, R>>> partitionedResources, Long partitionIndex) {
            Map resources = partitionedResources.get(partitionIndex);
            if (resources == null) {
                resources = Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForPartitionedResources_" + partitionIndex.toString(), () -> {
                    ConcurrentHashMap resourcesTemp = (ConcurrentHashMap)partitionedResources.get(partitionIndex);
                    if (resourcesTemp == null) {
                        resourcesTemp = new ConcurrentHashMap();
                        partitionedResources.put(partitionIndex, resourcesTemp);
                    }
                    return resourcesTemp;
                });
            }
            return resources;
        }

        Map<String, R> retrievePartition(Map<String, Map<String, R>> partion, Long partitionIndex, String path) {
            Map innerPartion;
            String partitionKey = "/";
            if (partitionIndex > 1L) {
                partitionKey = path.substring(0, path.lastIndexOf("/"));
                partitionKey = partitionKey.substring(partitionKey.lastIndexOf("/") + 1);
            }
            if ((innerPartion = partion.get(partitionKey)) == null) {
                String finalPartitionKey = partitionKey;
                innerPartion = Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForPartitions_" + finalPartitionKey, () -> {
                    ConcurrentHashMap innerPartionTemp = (ConcurrentHashMap)partion.get(finalPartitionKey);
                    if (innerPartionTemp == null) {
                        innerPartionTemp = new ConcurrentHashMap();
                        partion.put(finalPartitionKey, innerPartionTemp);
                    }
                    return innerPartionTemp;
                });
            }
            return innerPartion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Thread clearInBackground(boolean destroyItems) {
            Map<Long, Map<String, Map<String, R>>> partitions;
            Map<Long, Map<String, Map<String, R>>> map = this.resources;
            synchronized (map) {
                partitions = this.resources;
                this.resources = new ConcurrentHashMap<Long, Map<String, Map<String, R>>>();
            }
            Thread thread = new Thread(() -> this.clearResources(partitions, destroyItems));
            thread.start();
            return thread;
        }

        private int getLoadedResourcesCount(Map<Long, Map<String, Map<String, R>>> resources) {
            int count = 0;
            for (Map.Entry<Long, Map<String, Map<String, R>>> partition : resources.entrySet()) {
                for (Map.Entry<String, Map<String, R>> innerPartition : partition.getValue().entrySet()) {
                    count += innerPartition.getValue().size();
                }
            }
            return count;
        }
    }

    static class ObjectAndPathForResources<T, R> {
        String instanceId;
        Supplier<PathForResources<R>> pathForResourcesSupplier;
        Map<T, PathForResources<R>> resources = new ConcurrentHashMap<T, PathForResources<R>>();

        ObjectAndPathForResources() {
            this(1L, item -> item, null);
        }

        ObjectAndPathForResources(Long partitionStartLevel) {
            this(partitionStartLevel, item -> item, null);
        }

        ObjectAndPathForResources(Long partitionStartLevel, Function<R, R> sharer) {
            this(partitionStartLevel, sharer, null);
        }

        ObjectAndPathForResources(Long partitionStartLevel, Function<R, R> sharer, BiConsumer<String, R> itemDestroyer) {
            this.pathForResourcesSupplier = () -> new PathForResources(partitionStartLevel, sharer, itemDestroyer);
            this.instanceId = Objects.INSTANCE.getId(this);
        }

        R get(T object, String path) {
            PathForResources pathForResources = this.resources.get(object);
            if (pathForResources == null) {
                pathForResources = Synchronizer.INSTANCE.execute(this.instanceId + "_mutexManagerForResources_" + Objects.INSTANCE.getId(object), () -> {
                    PathForResources<R> pathForResourcesTemp = this.resources.get(object);
                    if (pathForResourcesTemp == null) {
                        pathForResourcesTemp = this.pathForResourcesSupplier.get();
                        this.resources.put(object, pathForResourcesTemp);
                    }
                    return pathForResourcesTemp;
                });
            }
            return pathForResources.get(path);
        }

        R getOrUploadIfAbsent(T object, String path, Supplier<R> resourceSupplier) {
            PathForResources pathForResources = this.resources.get(object);
            if (pathForResources == null) {
                pathForResources = Synchronizer.INSTANCE.execute(this.instanceId + "_" + Objects.INSTANCE.getId(object), () -> {
                    PathForResources<R> pathForResourcesTemp = this.resources.get(object);
                    if (pathForResourcesTemp == null) {
                        pathForResourcesTemp = this.pathForResourcesSupplier.get();
                        this.resources.put(object, pathForResourcesTemp);
                    }
                    return pathForResourcesTemp;
                });
            }
            return pathForResources.getOrUploadIfAbsent(path, resourceSupplier);
        }

        PathForResources<R> remove(T object, boolean destroyItems) {
            PathForResources<R> pathForResources = this.resources.remove(object);
            if (pathForResources != null && destroyItems) {
                ((PathForResources)pathForResources).clearInBackground(destroyItems);
            }
            return pathForResources;
        }

        R removePath(T object, String path) {
            return this.removePath(object, path, false);
        }

        R removePath(T object, String path, boolean destroyItem) {
            PathForResources<R> pathForResources = this.resources.get(object);
            if (pathForResources != null) {
                return pathForResources.remove(path, destroyItem);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Thread clearInBackground(boolean destroyItems) {
            Map resources;
            Map<T, PathForResources<R>> map = this.resources;
            synchronized (map) {
                resources = this.resources;
                this.resources = new ConcurrentHashMap<T, PathForResources<R>>();
            }
            Thread thread = new Thread(() -> {
                for (Map.Entry item : resources.entrySet()) {
                    try {
                        ((PathForResources)item.getValue()).clearInBackground(destroyItems).join();
                    }
                    catch (InterruptedException exc) {
                        Throwables.INSTANCE.throwException(exc);
                    }
                }
                resources.clear();
            });
            thread.start();
            return thread;
        }
    }
}

