/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Classes {
    public static final Classes INSTANCE = new Classes();
    Constructor<?>[] emptyConstructorsArray;
    Method[] emptyMethodsArray;
    Field[] emtpyFieldsArray = new Field[0];

    private Classes() {
        this.emptyMethodsArray = new Method[0];
        this.emptyConstructorsArray = new Constructor[0];
    }

    public Class<?> getClassOrWrapper(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls == Short.TYPE) {
                return Short.class;
            }
            if (cls == Integer.TYPE) {
                return Integer.class;
            }
            if (cls == Long.TYPE) {
                return Long.class;
            }
            if (cls == Float.TYPE) {
                return Float.class;
            }
            if (cls == Double.TYPE) {
                return Double.class;
            }
            if (cls == Boolean.TYPE) {
                return Boolean.class;
            }
            if (cls == Byte.TYPE) {
                return Byte.class;
            }
            if (cls == Character.TYPE) {
                return Character.class;
            }
        }
        return cls;
    }

    public boolean isAssignableFrom(Class<?> cls_01, Class<?> cls_02) {
        return this.getClassOrWrapper(cls_01).isAssignableFrom(this.getClassOrWrapper(cls_02));
    }

    public <T> Class<T> retrieveFrom(Object object) {
        return object != null ? object.getClass() : null;
    }

    public Class<?>[] retrieveFrom(Object ... objects) {
        Class[] classes = null;
        if (objects != null) {
            classes = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                classes[i] = this.retrieveFrom(objects[i]);
            }
        } else {
            classes = new Class[]{null};
        }
        return classes;
    }

    public String retrievePackageName(String className) {
        String packageName = null;
        if (className.contains(".")) {
            packageName = className.substring(0, className.lastIndexOf("."));
        }
        return packageName;
    }

    public String retrieveSimpleName(String className) {
        String classSimpleName = null;
        classSimpleName = className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
        if (classSimpleName.contains("$")) {
            classSimpleName = classSimpleName.substring(classSimpleName.lastIndexOf("$") + 1);
        }
        return classSimpleName;
    }
}

