/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.burningwave.Throwables;
import org.burningwave.function.Executor;
import org.burningwave.reflection.Cache;
import org.burningwave.reflection.Classes;
import org.burningwave.reflection.ConstructorCriteria;
import org.burningwave.reflection.Facade;
import org.burningwave.reflection.Members;

public class Constructors
extends Members.Handler.OfExecutable<Constructor<?>, ConstructorCriteria> {
    public static final Constructors INSTANCE = new Constructors();

    private Constructors() {
    }

    public Collection<Constructor<?>> findAllAndMakeThemAccessible(Class<?> targetClass) {
        Collection members = Cache.INSTANCE.uniqueKeyForConstructors.getOrUploadIfAbsent(this.getCacheKey(targetClass, "all for class", new Class[0]), () -> this.findAllAndApply(ConstructorCriteria.withoutConsideringParentClasses(), targetClass, member -> this.setAccessible(member, true)));
        return members;
    }

    public Collection<Constructor<?>> findAllAndMakeThemAccessible(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, "all for class by input parameters assignable from", inputParameterTypesOrSubTypes);
        return Cache.INSTANCE.uniqueKeyForConstructors.getOrUploadIfAbsent(cacheKey, () -> {
            ConstructorCriteria criteria = (ConstructorCriteria)ConstructorCriteria.withoutConsideringParentClasses().parameterTypesAreAssignableFrom(inputParameterTypesOrSubTypes);
            if (inputParameterTypesOrSubTypes != null && inputParameterTypesOrSubTypes.length == 0) {
                ((ConstructorCriteria)criteria.or()).parameter((parameters, idx) -> ((Parameter[])parameters).length == 1 && parameters[0].isVarArgs());
            }
            return this.findAllAndApply(criteria, targetClass, member -> this.setAccessible(member, true));
        });
    }

    public MethodHandle findDirectHandle(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findDirectHandleBox(targetClass, inputParameterTypesOrSubTypes).getHandler();
    }

    public Constructor<?> findFirstAndMakeItAccessible(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Constructor<?>> members = this.findAllAndMakeThemAccessible(targetClass, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Constructor<?>> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (!membersThatMatch.isEmpty()) {
                return membersThatMatch.stream().findFirst().get();
            }
            return members.stream().findFirst().get();
        }
        return null;
    }

    public Constructor<?> findOneAndMakeItAccessible(Class<?> targetClass, Class<?> ... argumentTypes) {
        Collection<Constructor<?>> members = this.findAllAndMakeThemAccessible(targetClass, argumentTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Constructor<?>> membersThatMatch = this.searchForExactMatch(members, argumentTypes);
            if (membersThatMatch.size() == 1) {
                return membersThatMatch.stream().findFirst().get();
            }
            Throwables.INSTANCE.throwException("Found more than one of constructor with argument types {} in {} class", String.join((CharSequence)", ", Arrays.asList(argumentTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName());
        }
        return null;
    }

    public <T> T newInstanceOf(Class<?> targetClass, Object ... arguments) {
        return Executor.getFirst(() -> {
            Class<?>[] argsType = Classes.INSTANCE.retrieveFrom(arguments);
            Members.Handler.OfExecutable.Box<Constructor<?>> methodHandleBox = this.findDirectHandleBox(targetClass, argsType);
            return Executor.get(() -> {
                Constructor ctor = (Constructor)methodHandleBox.getExecutable();
                return methodHandleBox.getHandler().invokeWithArguments(this.getFlatArgumentList(ctor, ArrayList::new, arguments));
            });
        }, () -> {
            Constructor<?> ctor = this.findFirstAndMakeItAccessible(targetClass, Classes.INSTANCE.retrieveFrom(arguments));
            if (ctor == null) {
                Throwables.INSTANCE.throwException("Constructor not found in {}", targetClass.getName());
            }
            return Facade.INSTANCE.newInstance(ctor, this.getArgumentArray(ctor, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments));
        });
    }

    @Override
    MethodHandle retrieveMethodHandle(MethodHandles.Lookup consulter, Constructor<?> constructor) throws NoSuchMethodException, IllegalAccessException {
        return consulter.findConstructor(constructor.getDeclaringClass(), MethodType.methodType(Void.TYPE, constructor.getParameterTypes()));
    }

    @Override
    String retrieveNameForCaching(Class<?> cls) {
        return Classes.INSTANCE.retrieveSimpleName(cls.getName());
    }

    @Override
    String retrieveNameForCaching(Constructor<?> constructor) {
        return this.retrieveNameForCaching(constructor.getDeclaringClass());
    }

    private Members.Handler.OfExecutable.Box<Constructor<?>> findDirectHandleBox(Class<?> targetClass, Class<?> ... inputParameterTypesOrSubTypes) {
        String nameForCaching = this.retrieveNameForCaching(targetClass);
        String cacheKey = this.getCacheKey(targetClass, "equals " + nameForCaching, inputParameterTypesOrSubTypes);
        Members.Handler.OfExecutable.Box<Constructor<?>> entry = Cache.INSTANCE.uniqueKeyForExecutableAndMethodHandle.get(cacheKey);
        if (entry == null) {
            Constructor<?> ctor = this.findFirstAndMakeItAccessible(targetClass, inputParameterTypesOrSubTypes);
            entry = this.findDirectHandleBox(ctor, cacheKey);
        }
        return entry;
    }
}

