/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.burningwave.Criteria;
import org.burningwave.function.TriPredicate;
import org.burningwave.reflection.Classes;
import org.burningwave.reflection.MemberCriteria;
import org.burningwave.reflection.Members;

public abstract class ExecutableMemberCriteria<E extends Executable, C extends ExecutableMemberCriteria<E, C, T>, T extends Criteria.TestContext<E, C>>
extends MemberCriteria<E, C, T> {
    public C parameter(BiPredicate<Parameter[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((testContext, member) -> member.getParameters(), (testContext, array, index) -> predicate.test((Parameter[])array, (Integer)index)));
        return (C)this;
    }

    public C parameterType(BiPredicate<Class<?>[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((testContext, member) -> member.getParameterTypes(), (testContext, array, index) -> predicate.test((Class<?>[])array, (Integer)index)));
        return (C)this;
    }

    public C parameterTypes(Predicate<Class<?>[]> predicate) {
        this.predicate = this.concat(this.predicate, (context, member) -> predicate.test(member.getParameterTypes()));
        return (C)this;
    }

    public C parameterTypesAreAssignableFrom(Class<?> ... argumentsClasses) {
        return this.parameterTypesMatch((argClasses, paramTypes, innerIdx) -> argClasses.get((int)innerIdx) == null || Classes.INSTANCE.isAssignableFrom(paramTypes[innerIdx], (Class)argClasses.get((int)innerIdx)), argumentsClasses);
    }

    public C parameterTypesAreAssignableFromTypesOf(Object ... arguments) {
        return this.parameterTypesAreAssignableFrom(Classes.INSTANCE.retrieveFrom(arguments));
    }

    public C parameterTypesExactlyMatch(Class<?> ... argumentsClasses) {
        return this.parameterTypesMatch((argClasses, paramTypes, innerIdx) -> argClasses.get((int)innerIdx) == null || Classes.INSTANCE.getClassOrWrapper(paramTypes[innerIdx]).equals(Classes.INSTANCE.getClassOrWrapper((Class)argClasses.get((int)innerIdx))), argumentsClasses);
    }

    public C parameterTypesExactlyMatchTypesOf(Object ... arguments) {
        return this.parameterTypesAreAssignableFrom(Classes.INSTANCE.retrieveFrom(arguments));
    }

    private C parameterTypesMatch(TriPredicate<List<Class<?>>, Class<?>[], Integer> predicate, Class<?> ... arguments) {
        Class<?>[] argumentsClasses;
        if (arguments == null) {
            arguments = new Class[]{null};
        }
        if ((argumentsClasses = arguments) != null && argumentsClasses.length > 0) {
            List<Class<?>> argumentsClassesAsList = Arrays.asList(argumentsClasses);
            for (int i = 0; i < argumentsClasses.length; ++i) {
                int index = i;
                this.predicate = this.concat(this.predicate, (context, member) -> {
                    Parameter[] memberParameter = member.getParameters();
                    if (memberParameter.length > 1 && memberParameter[memberParameter.length - 1].isVarArgs() && memberParameter.length - 1 > argumentsClassesAsList.size()) {
                        return false;
                    }
                    Class<?>[] memberParameterTypes = Members.Handler.OfExecutable.retrieveParameterTypes(member, argumentsClassesAsList);
                    if (argumentsClassesAsList.size() == memberParameterTypes.length) {
                        return predicate.test(argumentsClassesAsList, memberParameterTypes, index);
                    }
                    return false;
                });
                if (index >= arguments.length - 1) continue;
                this.and();
            }
        } else {
            this.parameterTypes(parameters -> ((Class[])parameters).length == 0);
        }
        return (C)this;
    }
}

