/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import io.github.toolfactory.jvm.Driver;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.burningwave.Strings;
import org.burningwave.Throwables;
import org.burningwave.function.Executor;
import org.burningwave.function.ThrowingBiConsumer;
import org.burningwave.function.ThrowingBiFunction;
import org.burningwave.function.ThrowingFunction;
import org.burningwave.function.ThrowingTriConsumer;
import org.burningwave.function.ThrowingTriFunction;

public class Facade {
    public static final Facade INSTANCE;
    private static Object driver;
    private static ThrowingBiFunction<MethodHandles.Lookup, Class<?>, MethodHandles.Lookup, Throwable> privateLookupIn;
    private Collection<ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>> accessibleSetters;
    private Collection<ThrowingBiFunction<Constructor<?>, Object[], Object, Throwable>> constructorInvokers;
    private Collection<ThrowingFunction<Class<?>, Constructor<?>[], Throwable>> constructorRetrievers;
    private Collection<ThrowingBiFunction<MethodHandles.Lookup, Class<?>, MethodHandles.Lookup, Throwable>> consulterRetrievers;
    private Collection<ThrowingFunction<Class<?>, Field[], Throwable>> fieldRetrievers = new ArrayList();
    private Collection<ThrowingBiFunction<Object, Field, Object, Throwable>> fieldValueRetrievers;
    private Collection<ThrowingTriConsumer<Object, Field, Object, Throwable>> fieldValueSetters;
    private Collection<ThrowingTriFunction<Object, Method, Object[], Object, Throwable>> methodInvokers;
    private Collection<ThrowingFunction<Class<?>, Method[], Throwable>> methodRetrievers = new ArrayList();

    private Facade() {
        this.constructorRetrievers = new ArrayList();
        this.accessibleSetters = new ArrayList<ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>>();
        this.fieldValueRetrievers = new ArrayList<ThrowingBiFunction<Object, Field, Object, Throwable>>();
        this.fieldValueSetters = new ArrayList<ThrowingTriConsumer<Object, Field, Object, Throwable>>();
        this.methodInvokers = new ArrayList<ThrowingTriFunction<Object, Method, Object[], Object, Throwable>>();
        this.constructorInvokers = new ArrayList();
        this.consulterRetrievers = new ArrayList();
        if (driver != null) {
            this.fieldRetrievers.add(clazz -> ((Driver)driver).getDeclaredFields(clazz));
            this.methodRetrievers.add(clazz -> ((Driver)driver).getDeclaredMethods(clazz));
            this.constructorRetrievers.add(clazz -> ((Driver)driver).getDeclaredConstructors(clazz));
            this.accessibleSetters.add((accessibleObject, flag) -> ((Driver)driver).setAccessible(accessibleObject, flag.booleanValue()));
            this.fieldValueRetrievers.add((target, field) -> ((Driver)driver).getFieldValue(target, field));
            this.fieldValueSetters.add((target, field, value) -> ((Driver)driver).setFieldValue(target, field, value));
            this.methodInvokers.add((target, method, parameters) -> ((Driver)driver).invoke(target, method, parameters));
            this.constructorInvokers.add((constructor, parameters) -> ((Driver)driver).newInstance(constructor, parameters));
            this.consulterRetrievers.add((lookup, clazz) -> ((Driver)driver).getConsulter(clazz));
        }
        this.fieldRetrievers.add(clazz -> clazz.getDeclaredFields());
        this.methodRetrievers.add(clazz -> clazz.getDeclaredMethods());
        this.constructorRetrievers.add(clazz -> clazz.getDeclaredConstructors());
        this.accessibleSetters.add((accessibleObject, flag) -> accessibleObject.setAccessible((boolean)flag));
        this.fieldValueRetrievers.add((target, field) -> field.get(target));
        this.fieldValueRetrievers.add((target, field) -> this.setAccessible(field, true).get(target));
        this.fieldValueSetters.add((target, field, value) -> field.set(target, value));
        this.fieldValueSetters.add((target, field, value) -> this.setAccessible(field, true).set(target, value));
        this.methodInvokers.add((target, method, parameters) -> method.invoke(target, parameters));
        this.methodInvokers.add((target, method, parameters) -> this.setAccessible(method, true).invoke(target, parameters));
        this.constructorInvokers.add((constructor, parameters) -> constructor.newInstance(parameters));
        this.constructorInvokers.add((constructor, parameters) -> this.setAccessible(constructor, true).newInstance(parameters));
        this.consulterRetrievers.add((consulter, clazz) -> MethodHandles.lookup());
        this.consulterRetrievers.add((consulter, clazz) -> privateLookupIn.apply((MethodHandles.Lookup)consulter, (Class<?>)clazz));
    }

    public <D> D getDriver() {
        return (D)driver;
    }

    public <R> Map.Entry<MethodHandles.Lookup, R> executeWithConsulter(Class<?> cls, ThrowingFunction<MethodHandles.Lookup, R, ? extends Throwable> executor) {
        Throwable exception = null;
        MethodHandles.Lookup consulter = null;
        for (ThrowingBiFunction<MethodHandles.Lookup, Class<?>, MethodHandles.Lookup, Throwable> consulterRetriever : this.consulterRetrievers) {
            try {
                consulter = consulterRetriever.apply(consulter, cls);
                return new AbstractMap.SimpleEntry<MethodHandles.Lookup, R>(consulter, executor.apply(consulter));
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return (Map.Entry)Throwables.INSTANCE.throwException(exception);
    }

    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> clazz) {
        Throwable exception = null;
        for (ThrowingFunction<Class<?>, Constructor<?>[], Throwable> constructorRetriever : this.constructorRetrievers) {
            try {
                return constructorRetriever.apply(clazz);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return (Constructor[])Throwables.INSTANCE.throwException(exception);
    }

    public Field[] getDeclaredFields(Class<?> clazz) {
        Throwable exception = null;
        for (ThrowingFunction<Class<?>, Field[], Throwable> fieldRetriever : this.fieldRetrievers) {
            try {
                return fieldRetriever.apply(clazz);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return (Field[])Throwables.INSTANCE.throwException(exception);
    }

    public Method[] getDeclaredMethods(Class<?> clazz) {
        Throwable exception = null;
        for (ThrowingFunction<Class<?>, Method[], Throwable> methodRetriever : this.methodRetrievers) {
            try {
                return methodRetriever.apply(clazz);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return (Method[])Throwables.INSTANCE.throwException(exception);
    }

    public <T> T getFieldValue(Object target, Field field) {
        Throwable exception = null;
        for (ThrowingBiFunction<Object, Field, Object, Throwable> fieldValueRetriever : this.fieldValueRetrievers) {
            try {
                return (T)fieldValueRetriever.apply(target, field);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return Throwables.INSTANCE.throwException(exception);
    }

    public <T> T invoke(Object target, Method method, Object[] params) {
        if (params == null) {
            params = new Object[]{null};
        }
        Throwable exception = null;
        for (ThrowingTriFunction<Object, Method, Object[], Object, Throwable> methodInvoker : this.methodInvokers) {
            try {
                return (T)methodInvoker.apply(target, method, params);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return Throwables.INSTANCE.throwException(exception);
    }

    public <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        if (parameters == null) {
            parameters = new Object[]{null};
        }
        Throwable exception = null;
        for (ThrowingBiFunction<Constructor<?>, Object[], Object, Throwable> constructorInvoker : this.constructorInvokers) {
            try {
                return (T)constructorInvoker.apply(constructor, parameters);
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return Throwables.INSTANCE.throwException(exception);
    }

    public <A extends AccessibleObject> A setAccessible(A accessibleObject, boolean flag) {
        Throwable exception = null;
        for (ThrowingBiConsumer<AccessibleObject, Boolean, Throwable> accessibleSetter : this.accessibleSetters) {
            try {
                accessibleSetter.accept(accessibleObject, flag);
                return accessibleObject;
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        return (A)((AccessibleObject)Throwables.INSTANCE.throwException(exception));
    }

    public void setFieldValue(Object target, Field field, Object value) {
        Throwable exception = null;
        for (ThrowingTriConsumer<Object, Field, Object, Throwable> fieldValueSetter : this.fieldValueSetters) {
            try {
                fieldValueSetter.accept(target, field, value);
                return;
            }
            catch (Throwable exc) {
                exception = exc;
            }
        }
        Throwables.INSTANCE.throwException(exception);
    }

    static {
        if (((Boolean)Configuration.freezeAndGet().get("jvm-driver.enabled")).booleanValue()) {
            try {
                driver = Driver.Factory.getNewDynamic();
            }
            catch (Throwable exc) {
                System.err.println(Strings.INSTANCE.compile("JVM driver not instantiated: {}", exc.getMessage()));
            }
        }
        MethodHandles.Lookup consulter = MethodHandles.lookup();
        MethodHandle privateLookupIn = (MethodHandle)Executor.getFirst(() -> consulter.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class)), () -> consulter.findStatic(Class.forName(Facade.class.getPackage().getName() + ".ConsulterHandlerForJava7"), "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class)));
        Facade.privateLookupIn = (clazz, cons) -> (MethodHandles.Lookup)privateLookupIn.invokeWithArguments(cons, clazz);
        INSTANCE = new Facade();
    }

    public static final class Configuration {
        private static boolean freezed;
        private static Map<String, Object> values;

        private Configuration() {
        }

        public static void disableDriver() {
            Configuration.putConfigurationValue("jvm-driver.enabled", false);
        }

        private static Map<String, Object> freezeAndGet() {
            if (!freezed) {
                values = Collections.unmodifiableMap(values);
            }
            return values;
        }

        private static void putConfigurationValue(String key, Object value) {
            try {
                values.put(key, value);
            }
            catch (UnsupportedOperationException exc) {
                throw new UnsupportedOperationException("Cannot add configuration value after that the " + Facade.class.getSimpleName() + " has been initialized");
            }
        }

        static {
            values = new LinkedHashMap<String, Object>();
            Configuration.putConfigurationValue("jvm-driver.enabled", true);
        }

        public static final class Key {
            private static final String JVM_DRIVER_ENABLED = "jvm-driver.enabled";

            private Key() {
            }
        }
    }
}

