/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.burningwave.Throwables;
import org.burningwave.reflection.Cache;
import org.burningwave.reflection.Classes;
import org.burningwave.reflection.Facade;
import org.burningwave.reflection.FieldCriteria;
import org.burningwave.reflection.Members;

public class Fields
extends Members.Handler<Field, FieldCriteria> {
    public static final Fields INSTANCE = new Fields();

    private Fields() {
    }

    public Collection<Field> findAllAndMakeThemAccessible(Class<?> targetClass) {
        String cacheKey = this.getCacheKey(targetClass, "all for class", null);
        return Cache.INSTANCE.uniqueKeyForAllFields.getOrUploadIfAbsent(cacheKey, () -> this.findAllAndMakeThemAccessible(FieldCriteria.forEntireClassHierarchy(), targetClass));
    }

    public Collection<Field> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String fieldName) {
        return this.findAllByExactNameAndMakeThemAccessible(targetClass, fieldName, null);
    }

    public Collection<Field> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String fieldName, Class<?> valueType) {
        String cacheKey = this.getCacheKey(targetClass, "equals " + fieldName, valueType);
        return Cache.INSTANCE.uniqueKeyForAllFields.getOrUploadIfAbsent(cacheKey, () -> this.findAllAndMakeThemAccessible((FieldCriteria)FieldCriteria.forEntireClassHierarchy().allThoseThatMatch(field -> {
            if (valueType == null) {
                return field.getName().equals(fieldName);
            }
            return field.getName().equals(fieldName) && Classes.INSTANCE.isAssignableFrom(field.getType(), valueType);
        }), targetClass));
    }

    public Field findFirstAndMakeItAccessible(Class<?> targetClass, String fieldName) {
        return this.findFirstAndMakeItAccessible(targetClass, fieldName, null);
    }

    public Field findFirstAndMakeItAccessible(Class<?> targetClass, String fieldName, Class<?> fieldTypeOrSubType) {
        Collection<Field> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, fieldName, fieldTypeOrSubType);
        if (members.size() < 1) {
            Throwables.INSTANCE.throwException(new NoSuchFieldException(Strings.compile((String)"Field {} not found in {} hierarchy", (Object[])new Object[]{fieldName, targetClass.getName()})));
        }
        return members.stream().findFirst().get();
    }

    public Field findOneAndMakeItAccessible(Class<?> targetClass, String memberName) {
        Collection<Field> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, null);
        if (members.size() != 1) {
            Throwables.INSTANCE.throwException(new NoSuchFieldException(Strings.compile((String)"Field {} not found or found more than one field in {} hierarchy", (Object[])new Object[]{memberName, targetClass.getName()})));
        }
        return members.stream().findFirst().get();
    }

    public <T> T get(Object target, Field field) {
        return Facade.INSTANCE.getFieldValue(target, field);
    }

    public <T> T get(Object target, String fieldName) {
        return this.get(target, this.findFirstAndMakeItAccessible(Classes.INSTANCE.retrieveFrom(target), fieldName, null));
    }

    public Map<Field, ?> getAll(FieldCriteria criteria, Object target) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(criteria, Classes.INSTANCE.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAll(Object target) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(Classes.INSTANCE.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAllDirect(FieldCriteria criteria, Object target) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(criteria, Classes.INSTANCE.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAllDirect(Object target) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(Classes.INSTANCE.retrieveFrom(target)), target);
    }

    public Map<Field, ?> getAllStatic(Class<?> targetClass) {
        return this.getAll(() -> this.findAllAndMakeThemAccessible(targetClass), null);
    }

    public Map<Field, ?> getAllStaticDirect(Class<?> targetClass) {
        return this.getAllDirect(() -> this.findAllAndMakeThemAccessible(targetClass), null);
    }

    public <T> T getStatic(Class<?> targetClass, String fieldName) {
        return this.getStatic(this.findFirstAndMakeItAccessible(targetClass, fieldName, null));
    }

    public <T> T getStatic(Field field) {
        return this.get(null, field);
    }

    public void set(Object target, Field field, Object value) {
        Facade.INSTANCE.setFieldValue(target, field, value);
    }

    public void set(Object target, String fieldName, Object value) {
        this.set(Classes.INSTANCE.retrieveFrom(target), target, fieldName, value);
    }

    public void setStatic(Class<?> targetClass, String fieldName, Object value) {
        this.set(targetClass, null, fieldName, value);
    }

    public void setStatic(Field field, Object value) {
        this.set(null, field, value);
    }

    private Map<Field, Object> getAll(Supplier<Collection<Field>> fieldsSupplier, Object target) {
        HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
        for (Field field : fieldsSupplier.get()) {
            if (target != null) {
                fieldValues.put(field, this.get(Modifier.isStatic(field.getModifiers()) ? null : target, field));
                continue;
            }
            if (!Modifier.isStatic(field.getModifiers())) continue;
            fieldValues.put(field, this.get(null, field));
        }
        return fieldValues;
    }

    private Map<Field, ?> getAllDirect(Supplier<Collection<Field>> fieldsSupplier, Object target) {
        HashMap fieldValues = new HashMap();
        for (Field field : fieldsSupplier.get()) {
            fieldValues.put(field, Facade.INSTANCE.getFieldValue(target, field));
        }
        return fieldValues;
    }

    private void set(Class<?> targetClass, Object target, String fieldName, Object value) {
        this.set(target, this.findFirstAndMakeItAccessible(targetClass, fieldName, Classes.INSTANCE.retrieveFrom(value)), value);
    }

    public static class NoSuchFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 3656790511956737635L;

        public NoSuchFieldException(String message) {
            super(message);
        }
    }
}

