/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.Throwables;
import org.burningwave.function.TriFunction;
import org.burningwave.reflection.Cache;
import org.burningwave.reflection.Classes;
import org.burningwave.reflection.ExecutableMemberCriteria;
import org.burningwave.reflection.Facade;
import org.burningwave.reflection.MemberCriteria;

public class Members {
    public static final Members INSTANCE = new Members();
    static final String ALL_FOR_CLASS = "all for class";

    private Members() {
    }

    public <M extends Member> Collection<M> findAll(MemberCriteria<M, ?, ?> criteria, Class<?> classFrom) {
        LinkedHashSet result = this.findAll(classFrom, classFrom, criteria.getScanUpToPredicate(), criteria.getMembersSupplier(), criteria.getPredicateOrTruePredicateIfPredicateIsNull(), new HashSet(), new LinkedHashSet());
        Predicate<Collection<M>> resultPredicate = criteria.getResultPredicate();
        return resultPredicate == null ? result : (resultPredicate.test(result) ? result : new LinkedHashSet());
    }

    public <M extends Member> M findFirst(MemberCriteria<M, ?, ?> criteria, Class<?> classFrom) {
        Predicate<Collection<M>> resultPredicate = criteria.getResultPredicate();
        if (resultPredicate == null) {
            return (M)this.findFirst(classFrom, classFrom, criteria.getScanUpToPredicate(), criteria.getMembersSupplier(), criteria.getPredicateOrTruePredicateIfPredicateIsNull(), new HashSet());
        }
        Collection result = this.findAll(classFrom, classFrom, criteria.getScanUpToPredicate(), criteria.getMembersSupplier(), criteria.getPredicateOrTruePredicateIfPredicateIsNull(), new HashSet(), new LinkedHashSet());
        return (M)(resultPredicate.test(result) ? result.stream().findFirst().orElseGet(() -> null) : null);
    }

    public <M extends Member> M findOne(MemberCriteria<M, ?, ?> criteria, Class<?> classFrom) {
        Collection<M> members = this.findAll(criteria, classFrom);
        if (members.size() > 1) {
            Throwables.INSTANCE.throwException("More than one member found for class {}", classFrom.getName());
        }
        return (M)((Member)members.stream().findFirst().orElse(null));
    }

    public <M extends Member> boolean match(MemberCriteria<M, ?, ?> criteria, Class<?> classFrom) {
        return this.findFirst(criteria, classFrom) != null;
    }

    private <M extends Member> Collection<M> findAll(Class<?> initialClsFrom, Class<?> currentScannedClass, BiPredicate<Class<?>, Class<?>> clsPredicate, BiFunction<Class<?>, Class<?>, M[]> memberSupplier, Predicate<M> predicate, Set<Class<?>> visitedInterfaces, Collection<M> collection) {
        for (Member member : (Member[])memberSupplier.apply(initialClsFrom, currentScannedClass)) {
            if (!predicate.test(member)) continue;
            collection.add(member);
        }
        for (Class<?> interf : currentScannedClass.getInterfaces()) {
            if (!visitedInterfaces.add(interf)) continue;
            if (!((collection = this.findAll(initialClsFrom, interf, clsPredicate, memberSupplier, predicate, visitedInterfaces, collection)) instanceof Set)) {
                return collection;
            }
            if (!clsPredicate.test(initialClsFrom, currentScannedClass)) continue;
            return Collections.unmodifiableCollection(collection);
        }
        Class<?> superClass = currentScannedClass.getSuperclass();
        if (!(collection instanceof Set) || (superClass = currentScannedClass.getSuperclass()) == null && currentScannedClass.isInterface()) {
            return collection;
        }
        if (superClass == null || clsPredicate.test(initialClsFrom, currentScannedClass)) {
            return Collections.unmodifiableCollection(collection);
        }
        return this.findAll(initialClsFrom, superClass, clsPredicate, memberSupplier, predicate, visitedInterfaces, collection);
    }

    private <M extends Member> M findFirst(Class<?> initialClsFrom, Class<?> currentScannedClass, BiPredicate<Class<?>, Class<?>> clsPredicate, BiFunction<Class<?>, Class<?>, M[]> memberSupplier, Predicate<M> predicate, Set<Class<?>> visitedInterfaces) {
        for (Member member : (Member[])memberSupplier.apply(initialClsFrom, currentScannedClass)) {
            if (!predicate.test(member)) continue;
            return (M)member;
        }
        for (Class<?> interf : currentScannedClass.getInterfaces()) {
            M member;
            if (!visitedInterfaces.add(interf) || (member = this.findFirst(initialClsFrom, interf, clsPredicate, memberSupplier, predicate, visitedInterfaces)) == null && !clsPredicate.test(initialClsFrom, currentScannedClass)) continue;
            return member;
        }
        return clsPredicate.test(initialClsFrom, currentScannedClass) || currentScannedClass.getSuperclass() == null ? null : (M)this.findFirst(initialClsFrom, currentScannedClass.getSuperclass(), clsPredicate, memberSupplier, predicate, visitedInterfaces);
    }

    public static abstract class Handler<M extends Member, C extends MemberCriteria<M, C, ?>> {
        public Collection<M> findAll(C criteria, Class<?> classFrom) {
            return INSTANCE.findAll(criteria, classFrom);
        }

        public Collection<M> findAllAndMakeThemAccessible(C criteria, Class<?> targetClass) {
            return this.findAllAndApply(criteria, targetClass, member -> this.setAccessible(member, true));
        }

        public M findFirst(C criteria, Class<?> classFrom) {
            return INSTANCE.findFirst(criteria, classFrom);
        }

        public M findOne(C criteria, Class<?> classFrom) {
            return INSTANCE.findOne(criteria, classFrom);
        }

        public boolean match(C criteria, Class<?> classFrom) {
            return INSTANCE.match(criteria, classFrom);
        }

        public void setAccessible(M member, boolean flag) {
            Facade.INSTANCE.setAccessible((AccessibleObject)member, flag);
        }

        Collection<M> findAllAndApply(C criteria, Class<?> targetClass, Consumer<M> ... consumers) {
            Collection members = this.findAll(criteria, targetClass);
            Optional.ofNullable(consumers).ifPresent(cnsms -> members.stream().forEach(member -> Stream.of(cnsms).filter(consumer -> consumer != null).forEach(consumer -> consumer.accept(member))));
            return members;
        }

        M findOneAndApply(C criteria, Class<?> targetClass, Consumer<M> ... consumers) {
            Object member = this.findOne(criteria, targetClass);
            Optional.ofNullable(consumers).ifPresent(cnsms -> Optional.ofNullable(member).ifPresent(mmb -> Stream.of(cnsms).filter(consumer -> consumer != null).forEach(consumer -> consumer.accept(mmb))));
            return member;
        }

        String getCacheKey(Class<?> targetClass, String groupName, Class<?> ... arguments) {
            if (arguments == null) {
                arguments = new Class[]{null};
            }
            String argumentsKey = "";
            if (arguments != null && arguments.length > 0) {
                StringBuffer argumentsKeyStringBuffer = new StringBuffer();
                Stream.of(arguments).forEach(cls -> argumentsKeyStringBuffer.append("/" + Optional.ofNullable(cls).map(Class::getName).orElseGet(() -> "null")));
                argumentsKey = argumentsKeyStringBuffer.toString();
            }
            String cacheKey = "/" + targetClass.getName() + "@" + targetClass.hashCode() + "/" + groupName + argumentsKey;
            return cacheKey;
        }

        public static abstract class OfExecutable<E extends Executable, C extends ExecutableMemberCriteria<E, C, ?>>
        extends Handler<E, C> {
            OfExecutable() {
            }

            public Collection<MethodHandle> findAllDirectHandle(C criteria, Class<?> clsFrom) {
                return this.findAll(criteria, clsFrom).stream().map(this::findDirectHandle).collect(Collectors.toSet());
            }

            public MethodHandle findDirectHandle(E executable) {
                return this.findDirectHandleBox(executable).getHandler();
            }

            public MethodHandle findFirstDirectHandle(C criteria, Class<?> clsFrom) {
                return Optional.ofNullable((Executable)this.findFirst(criteria, clsFrom)).map(this::findDirectHandle).orElseGet(() -> null);
            }

            public MethodHandle findOneDirectHandle(C criteria, Class<?> clsFrom) {
                return Optional.ofNullable((Executable)this.findOne(criteria, clsFrom)).map(this::findDirectHandle).orElseGet(() -> null);
            }

            Box<E> findDirectHandleBox(E executable) {
                Class<?> targetClass = ((Executable)executable).getDeclaringClass();
                String cacheKey = this.getCacheKey(targetClass, "equals " + this.retrieveNameForCaching(executable), ((Executable)executable).getParameterTypes());
                return this.findDirectHandleBox(executable, cacheKey);
            }

            Box<E> checkAndGetExecutableBox(Box<E> executableBox) {
                if (executableBox.getHandler() != null) {
                    return executableBox;
                }
                return (Box)Throwables.INSTANCE.throwException(executableBox.getException());
            }

            Box<E> findDirectHandleBox(E executable, String cacheKey) {
                return this.checkAndGetExecutableBox(Cache.INSTANCE.uniqueKeyForExecutableAndMethodHandle.getOrUploadIfAbsent(cacheKey, () -> {
                    Class<?> methodDeclaringClass = executable.getDeclaringClass();
                    ArrayList executableBoxes = new ArrayList();
                    try {
                        return Facade.INSTANCE.executeWithConsulter(methodDeclaringClass, consulter -> {
                            Throwable exception = null;
                            MethodHandle methodHandle = null;
                            try {
                                methodHandle = this.retrieveMethodHandle((MethodHandles.Lookup)consulter, executable);
                            }
                            catch (Throwable exc) {
                                exception = exc;
                            }
                            Box<Executable> executableBox = new Box<Executable>((MethodHandles.Lookup)consulter, (Executable)executable, methodHandle, exception);
                            executableBoxes.add(executableBox);
                            if (exception != null) {
                                throw exception;
                            }
                            return executableBox;
                        }).getValue();
                    }
                    catch (Throwable exc) {
                        return (Box)executableBoxes.iterator().next();
                    }
                }));
            }

            Object[] getArgumentArray(E member, TriFunction<E, Supplier<List<Object>>, Object[], List<Object>> argumentListSupplier, Supplier<List<Object>> listSupplier, Object ... arguments) {
                List<Object> argumentList = argumentListSupplier.apply(member, listSupplier, arguments);
                return argumentList.toArray(new Object[argumentList.size()]);
            }

            List<Object> getArgumentListWithArrayForVarArgs(E member, Supplier<List<Object>> argumentListSupplier, Object ... arguments) {
                Parameter[] parameters = ((Executable)member).getParameters();
                List<Object> argumentList = argumentListSupplier.get();
                if (arguments != null) {
                    if (parameters.length > 0 && parameters[parameters.length - 1].isVarArgs()) {
                        for (int i = 0; i < arguments.length && i < parameters.length - 1; ++i) {
                            argumentList.add(arguments[i]);
                        }
                        Parameter lastParameter = parameters[parameters.length - 1];
                        if (arguments.length == parameters.length) {
                            Object lastArgument = arguments[arguments.length - 1];
                            if (lastArgument != null && lastArgument.getClass().isArray() && lastArgument.getClass().equals(lastParameter.getType())) {
                                argumentList.add(lastArgument);
                            } else {
                                Object array = Array.newInstance(lastParameter.getType().getComponentType(), 1);
                                Array.set(array, 0, lastArgument);
                                argumentList.add(array);
                            }
                        } else if (arguments.length > parameters.length) {
                            Object array = Array.newInstance(lastParameter.getType().getComponentType(), arguments.length - (parameters.length - 1));
                            int i = parameters.length - 1;
                            int j = 0;
                            while (i < arguments.length) {
                                Array.set(array, j, arguments[i]);
                                ++i;
                                ++j;
                            }
                            argumentList.add(array);
                        } else if (arguments.length < parameters.length) {
                            argumentList.add(Array.newInstance(lastParameter.getType().getComponentType(), 0));
                        }
                    } else if (arguments.length > 0) {
                        for (Object argument : arguments) {
                            argumentList.add(argument);
                        }
                    }
                } else {
                    argumentList.add(null);
                }
                return argumentList;
            }

            List<Object> getFlatArgumentList(E member, Supplier<List<Object>> argumentListSupplier, Object ... arguments) {
                Parameter[] parameters = ((Executable)member).getParameters();
                List<Object> argumentList = argumentListSupplier.get();
                if (arguments != null) {
                    if (parameters.length > 0 && parameters[parameters.length - 1].isVarArgs()) {
                        int i;
                        for (i = 0; i < arguments.length && i < parameters.length - 1; ++i) {
                            argumentList.add(arguments[i]);
                        }
                        if (arguments.length == parameters.length) {
                            Parameter lastParameter = parameters[parameters.length - 1];
                            Object lastArgument = arguments[arguments.length - 1];
                            if (lastArgument != null && lastArgument.getClass().isArray() && lastArgument.getClass().equals(lastParameter.getType())) {
                                for (int i2 = 0; i2 < Array.getLength(lastArgument); ++i2) {
                                    argumentList.add(Array.get(lastArgument, i2));
                                }
                            } else {
                                argumentList.add(lastArgument);
                            }
                        } else if (arguments.length > parameters.length) {
                            for (i = parameters.length - 1; i < arguments.length; ++i) {
                                argumentList.add(arguments[i]);
                            }
                        } else if (arguments.length < parameters.length) {
                            argumentList.add(null);
                        }
                    } else if (arguments.length > 0) {
                        for (Object argument : arguments) {
                            argumentList.add(argument);
                        }
                    }
                } else {
                    argumentList.add(null);
                }
                return argumentList;
            }

            abstract MethodHandle retrieveMethodHandle(MethodHandles.Lookup var1, E var2) throws NoSuchMethodException, IllegalAccessException;

            abstract String retrieveNameForCaching(E var1);

            static Class<?>[] retrieveParameterTypes(Executable member, List<Class<?>> argumentsClassesAsList) {
                Class<?>[] memberParameterTypes;
                block2: {
                    Class<?> varArgsType;
                    Parameter[] memberParameter;
                    block3: {
                        memberParameter = member.getParameters();
                        memberParameterTypes = member.getParameterTypes();
                        if (memberParameter.length <= 0 || !memberParameter[memberParameter.length - 1].isVarArgs()) break block2;
                        Class<?> clazz = varArgsType = argumentsClassesAsList.size() > 0 && argumentsClassesAsList.get(argumentsClassesAsList.size() - 1) != null && argumentsClassesAsList.get(argumentsClassesAsList.size() - 1).isArray() ? memberParameter[memberParameter.length - 1].getType() : memberParameter[memberParameter.length - 1].getType().getComponentType();
                        if (memberParameter.length != 1) break block3;
                        memberParameterTypes = new Class[argumentsClassesAsList.size()];
                        for (int j = 0; j < memberParameterTypes.length; ++j) {
                            memberParameterTypes[j] = varArgsType;
                        }
                        break block2;
                    }
                    if (memberParameter.length - 1 > argumentsClassesAsList.size()) break block2;
                    memberParameterTypes = new Class[argumentsClassesAsList.size()];
                    for (int j = 0; j < memberParameterTypes.length; ++j) {
                        memberParameterTypes[j] = j < memberParameter.length - 1 ? memberParameter[j].getType() : varArgsType;
                    }
                }
                return memberParameterTypes;
            }

            Collection<E> searchForExactMatch(Collection<E> members, Class<?> ... arguments) {
                final List<Class<?>> argumentsClassesAsList = Arrays.asList(arguments);
                TreeSet<Executable> membersThatMatch = new TreeSet<Executable>(new Comparator<E>(){

                    @Override
                    public int compare(E executableOne, E executableTwo) {
                        Parameter[] executableOneParameters = ((Executable)executableOne).getParameters();
                        Parameter[] executableTwoParameters = ((Executable)executableTwo).getParameters();
                        if (executableOneParameters.length == argumentsClassesAsList.size()) {
                            if (executableTwoParameters.length == argumentsClassesAsList.size()) {
                                if (executableOneParameters.length > 0 && executableOneParameters[executableOneParameters.length - 1].isVarArgs()) {
                                    if (executableTwoParameters.length > 0 && executableTwoParameters[executableTwoParameters.length - 1].isVarArgs()) {
                                        return 0;
                                    }
                                    return 1;
                                }
                                if (executableTwoParameters.length > 0 && executableTwoParameters[executableTwoParameters.length - 1].isVarArgs()) {
                                    return -1;
                                }
                                return 0;
                            }
                            return -1;
                        }
                        if (executableTwoParameters.length == argumentsClassesAsList.size()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (Executable executable : members) {
                    Class<?>[] parameterTypes = OfExecutable.retrieveParameterTypes(executable, argumentsClassesAsList);
                    boolean exactMatch = true;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (argumentsClassesAsList.get(i) == null || Classes.INSTANCE.getClassOrWrapper(argumentsClassesAsList.get(i)).equals(Classes.INSTANCE.getClassOrWrapper(parameterTypes[i]))) continue;
                        exactMatch = false;
                    }
                    if (!exactMatch) continue;
                    membersThatMatch.add(executable);
                }
                return membersThatMatch;
            }

            public static class Box<E extends Member> {
                MethodHandles.Lookup consulter;
                E executable;
                MethodHandle handler;
                Throwable exception;

                Box(MethodHandles.Lookup consulter, E executable, MethodHandle handler, Throwable exception) {
                    this.consulter = consulter;
                    this.executable = executable;
                    this.handler = handler;
                    this.exception = exception;
                }

                public MethodHandles.Lookup getConsulter() {
                    return this.consulter;
                }

                public E getExecutable() {
                    return this.executable;
                }

                public MethodHandle getHandler() {
                    return this.handler;
                }

                public Throwable getException() {
                    return this.exception;
                }
            }
        }
    }
}

