/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.reflect.Method;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.Criteria;
import org.burningwave.reflection.Cache;
import org.burningwave.reflection.Constructors;
import org.burningwave.reflection.ExecutableMemberCriteria;
import org.burningwave.reflection.Facade;

public class MethodCriteria
extends ExecutableMemberCriteria<Method, MethodCriteria, Criteria.TestContext<Method, MethodCriteria>> {
    private MethodCriteria() {
    }

    public static MethodCriteria byScanUpTo(BiPredicate<Class<?>, Class<?>> predicate) {
        return (MethodCriteria)new MethodCriteria().scanUpTo(predicate);
    }

    public static MethodCriteria byScanUpTo(Predicate<Class<?>> predicate) {
        return (MethodCriteria)new MethodCriteria().scanUpTo(predicate);
    }

    public static MethodCriteria forEntireClassHierarchy() {
        return new MethodCriteria();
    }

    public static MethodCriteria withoutConsideringParentClasses() {
        return MethodCriteria.byScanUpTo((Class<?> lastClassInHierarchy, Class<?> currentScannedClass) -> lastClassInHierarchy.equals(currentScannedClass));
    }

    public MethodCriteria returnType(Predicate<Class<?>> predicate) {
        this.predicate = this.concat(this.predicate, (context, member) -> predicate.test(member.getReturnType()));
        return this;
    }

    @Override
    Function<Class<?>, Method[]> getMembersSupplierFunction() {
        return clazz -> {
            String cacheKey = Constructors.INSTANCE.getCacheKey((Class<?>)clazz, "all for class", new Class[0]);
            return Cache.INSTANCE.uniqueKeyForMethodsArray.getOrUploadIfAbsent(cacheKey, () -> Facade.INSTANCE.getDeclaredMethods((Class<?>)clazz));
        };
    }
}

