/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.Strings;
import org.burningwave.Throwables;
import org.burningwave.function.Executor;
import org.burningwave.function.ThrowingFunction;
import org.burningwave.reflection.Cache;
import org.burningwave.reflection.Classes;
import org.burningwave.reflection.Facade;
import org.burningwave.reflection.Members;
import org.burningwave.reflection.MethodCriteria;

public class Methods
extends Members.Handler.OfExecutable<Method, MethodCriteria> {
    public static final Methods INSTANCE = new Methods();

    private Methods() {
    }

    public Collection<Method> findAllAndMakeThemAccessible(Class<?> targetClass) {
        String cacheKey = this.getCacheKey(targetClass, "all for class", new Class[0]);
        Collection members = Cache.INSTANCE.uniqueKeyForAllMethods.getOrUploadIfAbsent(cacheKey, () -> this.findAllAndMakeThemAccessible(MethodCriteria.forEntireClassHierarchy(), targetClass));
        return members;
    }

    public Collection<Method> findAllByExactNameAndMakeThemAccessible(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findAllByNamePredicateAndMakeThemAccessible(targetClass, "equals " + methodName, methodName::equals, inputParameterTypesOrSubTypes);
    }

    public Collection<Method> findAllByMatchedNameAndMakeThemAccessible(Class<?> targetClass, String regEx, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findAllByNamePredicateAndMakeThemAccessible(targetClass, "match " + regEx, name -> name.matches(regEx), inputParameterTypesOrSubTypes);
    }

    public MethodHandle findDirectHandle(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        return this.findDirectHandleBox(targetClass, methodName, inputParameterTypesOrSubTypes).getHandler();
    }

    public Method findFirstAndMakeItAccessible(Class<?> targetClass, String memberName, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Method> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Method> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (!membersThatMatch.isEmpty()) {
                return membersThatMatch.stream().findFirst().get();
            }
            return members.stream().findFirst().get();
        }
        return null;
    }

    public Method findOneAndMakeItAccessible(Class<?> targetClass, String memberName, Class<?> ... inputParameterTypesOrSubTypes) {
        Collection<Method> members = this.findAllByExactNameAndMakeThemAccessible(targetClass, memberName, inputParameterTypesOrSubTypes);
        if (members.size() == 1) {
            return members.stream().findFirst().get();
        }
        if (members.size() > 1) {
            Collection<Method> membersThatMatch = this.searchForExactMatch(members, inputParameterTypesOrSubTypes);
            if (membersThatMatch.size() == 1) {
                return membersThatMatch.stream().findFirst().get();
            }
            Throwables.INSTANCE.throwException(new IllegalArgumentException(Strings.INSTANCE.compile("Found more than one of method named {} with argument types {} in {} hierarchy", memberName, String.join((CharSequence)", ", Arrays.asList(inputParameterTypesOrSubTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName())));
        }
        return null;
    }

    public <T> T invoke(Object target, Method method, Object ... params) {
        return Facade.INSTANCE.invoke(target, method, params);
    }

    public <T> T invoke(Object target, String methodName, Object ... arguments) {
        return Executor.getFirst(() -> this.invokeDirect(Classes.INSTANCE.retrieveFrom(target), target, methodName, () -> {
            ArrayList<Object> argumentList = new ArrayList<Object>();
            argumentList.add(target);
            return argumentList;
        }, arguments), () -> this.invoke(Classes.INSTANCE.retrieveFrom(target), null, methodName, (Method method) -> this.invoke(target, (Method)method, this.getArgumentArray(method, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments)), arguments));
    }

    public <T> T invokeStatic(Class<?> targetClass, String methodName, Object ... arguments) {
        return Executor.getFirst(() -> this.invokeDirect(targetClass, null, methodName, ArrayList::new, arguments), () -> this.invoke(targetClass, null, methodName, (Method method) -> this.invoke((Object)null, (Method)method, this.getArgumentArray(method, this::getArgumentListWithArrayForVarArgs, ArrayList::new, arguments)), arguments));
    }

    String createGetterMethodNameByFieldPath(String fieldPath) {
        String methodName = "get" + Strings.INSTANCE.capitalizeFirstCharacter(fieldPath);
        return methodName;
    }

    String createSetterMethodNameByFieldPath(String fieldPath) {
        String methodName = "set" + Strings.INSTANCE.capitalizeFirstCharacter(fieldPath);
        return methodName;
    }

    @Override
    MethodHandle retrieveMethodHandle(MethodHandles.Lookup consulter, Method method) throws java.lang.NoSuchMethodException, IllegalAccessException {
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        return !Modifier.isStatic(method.getModifiers()) ? consulter.findSpecial(methodDeclaringClass, this.retrieveNameForCaching(method), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), methodDeclaringClass) : consulter.findStatic(methodDeclaringClass, this.retrieveNameForCaching(method), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
    }

    @Override
    String retrieveNameForCaching(Method method) {
        return method.getName();
    }

    private Collection<Method> findAllByNamePredicateAndMakeThemAccessible(Class<?> targetClass, String cacheKeyPrefix, Predicate<String> namePredicate, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, cacheKeyPrefix, inputParameterTypesOrSubTypes);
        return Cache.INSTANCE.uniqueKeyForAllMethods.getOrUploadIfAbsent(cacheKey, () -> {
            MethodCriteria criteria = (MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(namePredicate)).and()).parameterTypesAreAssignableFrom(inputParameterTypesOrSubTypes);
            if (inputParameterTypesOrSubTypes != null && inputParameterTypesOrSubTypes.length == 0) {
                criteria = criteria.or((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(namePredicate)).and()).parameter((parameters, idx) -> ((Parameter[])parameters).length == 1 && parameters[0].isVarArgs()));
            }
            MethodCriteria finalCriteria = criteria;
            return Cache.INSTANCE.uniqueKeyForAllMethods.getOrUploadIfAbsent(cacheKey, () -> this.findAllAndApply(finalCriteria, targetClass, member -> this.setAccessible(member, true)));
        });
    }

    private Members.Handler.OfExecutable.Box<Method> findDirectHandleBox(Class<?> targetClass, String methodName, Class<?> ... inputParameterTypesOrSubTypes) {
        String cacheKey = this.getCacheKey(targetClass, "equals " + methodName, inputParameterTypesOrSubTypes);
        Members.Handler.OfExecutable.Box<Method> entry = Cache.INSTANCE.uniqueKeyForExecutableAndMethodHandle.get(cacheKey);
        if (entry == null) {
            Method method = this.findFirstAndMakeItAccessible(targetClass, methodName, inputParameterTypesOrSubTypes);
            if (method == null) {
                Throwables.INSTANCE.throwException(new NoSuchMethodException(Strings.INSTANCE.compile("Method {} not found in {} hierarchy", methodName, targetClass.getName())));
            }
            entry = this.findDirectHandleBox(method, cacheKey);
        }
        return entry;
    }

    private <T> T invoke(Class<?> targetClass, Object target, String methodName, ThrowingFunction<Method, T, Throwable> methodInvoker, Object ... arguments) {
        return (T)Executor.get(() -> {
            Method method = this.findFirstAndMakeItAccessible(targetClass, methodName, Classes.INSTANCE.retrieveFrom(arguments));
            if (method == null) {
                Throwables.INSTANCE.throwException(new NoSuchMethodException(Strings.INSTANCE.compile("Method {} not found in {} hierarchy", methodName, targetClass.getName())));
            }
            return methodInvoker.apply(method);
        });
    }

    private <T> T invokeDirect(Class<?> targetClass, Object target, String methodName, Supplier<List<Object>> listSupplier, Object ... arguments) {
        Class<?>[] argsType = Classes.INSTANCE.retrieveFrom(arguments);
        Members.Handler.OfExecutable.Box<Method> methodHandleBox = this.findDirectHandleBox(targetClass, methodName, argsType);
        return (T)Executor.get(() -> {
            Method method = (Method)methodHandleBox.getExecutable();
            List<Object> argumentList = this.getFlatArgumentList(method, listSupplier, arguments);
            return methodHandleBox.getHandler().invokeWithArguments(argumentList);
        });
    }

    public static class NoSuchMethodException
    extends RuntimeException {
        private static final long serialVersionUID = -2912826056405333039L;

        public NoSuchMethodException(String message) {
            super(message);
        }
    }
}

