/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.internal;

import com.mongodb.MongoWriteException;
import com.mongodb.WriteError;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bytesoft.bytejta.supports.internal.MongoInstanceVersionManager;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionLock;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;

public class MongoTransactionLock
implements TransactionLock,
MongoInstanceVersionManager,
TransactionEndpointAware,
TransactionBeanFactoryAware,
CuratorWatcher,
ConnectionStateListener,
BackgroundCallback,
SmartInitializingSingleton {
    static Logger logger = LoggerFactory.getLogger(MongoTransactionLock.class);
    static final String CONSTANTS_ROOT_PATH = "/org/bytesoft/bytejta";
    static final String CONSTANTS_DB_NAME = "bytejta";
    static final String CONSTANTS_TB_LOCKS = "locks";
    static final String CONSTANTS_TB_INSTS = "instances";
    static final String CONSTANTS_FD_GLOBAL = "gxid";
    static final String CONSTANTS_FD_BRANCH = "bxid";
    static final String CONSTANTS_FD_SYSTEM = "system";
    static final int MONGODB_ERROR_DUPLICATE_KEY = 11000;
    @Resource
    private MongoClient mongoClient;
    @Resource
    private CuratorFramework curatorFramework;
    private String endpoint;
    @Inject
    private TransactionBeanFactory beanFactory;
    private boolean initializeEnabled = true;
    private final Map<String, Long> instances = new HashMap<String, Long>();
    private transient long instanceVersion;

    public void afterSingletonsInstantiated() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.initializeEnabled) {
            this.initializeIndexIfNecessary();
        }
        this.curatorFramework.blockUntilConnected();
        this.curatorFramework.getConnectionStateListenable().addListener((Object)this);
        this.initializeClusterInstancesDirectory();
        this.initializeClusterInstanceVersion();
        this.initializeClusterInstanceConfig();
    }

    private void initializeClusterInstancesDirectory() throws Exception {
        String parent = String.format("%s/%s/instances", CONSTANTS_ROOT_PATH, CommonUtils.getApplication((String)this.endpoint));
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(parent);
        }
        catch (KeeperException.NodeExistsException nex) {
            logger.debug("Path exists(path= {})!", (Object)parent);
        }
    }

    private void initializeClusterInstanceConfig() throws Exception {
        this.initializeCurrentClusterInstanceConfigIfNecessary();
        this.getInstancesDirectorysChildrenAndRegisterWatcher();
    }

    private void initializeCurrentClusterInstanceConfigIfNecessary() throws Exception {
        String parent = String.format("%s/%s/instances", CONSTANTS_ROOT_PATH, CommonUtils.getApplication((String)this.endpoint));
        String path = String.format("%s/%s", parent, this.endpoint);
        byte[] versionByteArray = ByteUtils.longToByteArray((long)this.instanceVersion);
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL)).forPath(path, versionByteArray);
        }
        catch (KeeperException.NodeExistsException error) {
            ((ErrorListenerPathable)this.curatorFramework.delete().inBackground((BackgroundCallback)this)).forPath(path);
        }
    }

    private void initializeIndexIfNecessary() {
        this.createLocksIndexIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLocksIndexIfNecessary() {
        MongoDatabase database = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
        MongoCollection locks = database.getCollection(CONSTANTS_TB_LOCKS);
        ListIndexesIterable lockIndexList = locks.listIndexes();
        boolean transactionIndexExists = false;
        MongoCursor lockCursor = null;
        try {
            lockCursor = lockIndexList.iterator();
            while (!transactionIndexExists && lockCursor.hasNext()) {
                Document document = (Document)lockCursor.next();
                Boolean unique = document.getBoolean((Object)"unique");
                Document key = (Document)document.get((Object)"key");
                boolean globalExists = key.containsKey((Object)CONSTANTS_FD_GLOBAL);
                boolean systemExists = key.containsKey((Object)CONSTANTS_FD_SYSTEM);
                boolean lengthEquals = key.size() == 2;
                transactionIndexExists = lengthEquals && globalExists && systemExists;
                if (!transactionIndexExists || unique != null && unique.booleanValue()) continue;
                throw new IllegalStateException();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)lockCursor);
        }
        if (!transactionIndexExists) {
            Document index = new Document(CONSTANTS_FD_GLOBAL, (Object)1).append(CONSTANTS_FD_SYSTEM, (Object)1);
            locks.createIndex((Bson)index, new IndexOptions().unique(true));
        }
    }

    private void initializeClusterInstanceVersion() {
        MongoDatabase database = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
        MongoCollection instances = database.getCollection(CONSTANTS_TB_INSTS);
        Bson condition = Filters.eq((String)"_id", (Object)this.endpoint);
        Document increases = new Document();
        increases.append("version", (Object)1L);
        Document variables = new Document();
        variables.append(CONSTANTS_FD_SYSTEM, (Object)CommonUtils.getApplication((String)this.endpoint));
        Document document = new Document();
        document.append("$inc", (Object)increases);
        document.append("$set", (Object)variables);
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
        options.upsert(true);
        Document target = (Document)instances.findOneAndUpdate(condition, (Bson)document, new FindOneAndUpdateOptions().upsert(true));
        this.instanceVersion = target == null ? 1L : target.getLong((Object)"version") + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockTransaction(TransactionXid transactionXid, String identifier) {
        if (this.lockTransactionInMongoDB(transactionXid, identifier)) {
            return true;
        }
        String instanceId = this.getTransactionOwnerInMongoDB(transactionXid);
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return false;
        }
        boolean instanceCrashed = false;
        MongoTransactionLock mongoTransactionLock = this;
        synchronized (mongoTransactionLock) {
            instanceCrashed = !this.instances.containsKey(instanceId);
        }
        if (instanceCrashed) {
            return this.takeOverTransactionInMongoDB(transactionXid, instanceId, identifier);
        }
        return false;
    }

    private boolean lockTransactionInMongoDB(TransactionXid transactionXid, String identifier) {
        byte[] global = transactionXid.getGlobalTransactionId();
        String instanceId = ByteUtils.byteArrayToString((byte[])global);
        try {
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_LOCKS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Document document = new Document();
            document.append(CONSTANTS_FD_GLOBAL, (Object)instanceId);
            document.append(CONSTANTS_FD_SYSTEM, (Object)application);
            document.append("identifier", (Object)identifier);
            collection.insertOne((Object)document);
            return true;
        }
        catch (MongoWriteException error) {
            WriteError writeError = error.getError();
            if (11000 != writeError.getCode()) {
                logger.error("Error occurred while locking transaction(gxid= {}).", (Object)instanceId, (Object)error);
            }
            return false;
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while locking transaction(gxid= {}).", (Object)instanceId, (Object)rex);
            return false;
        }
    }

    private boolean takeOverTransactionInMongoDB(TransactionXid transactionXid, String source, String target) {
        byte[] global = transactionXid.getGlobalTransactionId();
        String instanceId = ByteUtils.byteArrayToString((byte[])global);
        try {
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_LOCKS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)instanceId);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            Bson instIdFilter = Filters.eq((String)"identifier", (Object)source);
            Document document = new Document("$set", (Object)new Document("identifier", (Object)target));
            UpdateResult result = collection.updateOne(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter, instIdFilter}), (Bson)document);
            return result.getMatchedCount() == 1L;
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while locking transaction(gxid= {}).", (Object)instanceId, (Object)rex);
            return false;
        }
    }

    private String getTransactionOwnerInMongoDB(TransactionXid transactionXid) {
        byte[] global = transactionXid.getGlobalTransactionId();
        String instanceId = ByteUtils.byteArrayToString((byte[])global);
        try {
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_LOCKS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)instanceId);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            FindIterable findIterable = collection.find(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter}));
            MongoCursor cursor = findIterable.iterator();
            if (cursor.hasNext()) {
                Document document = (Document)cursor.next();
                return document.getString((Object)"identifier");
            }
            return null;
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while querying the lock-owner of transaction(gxid= {}).", (Object)instanceId, (Object)rex);
            return null;
        }
    }

    public void unlockTransaction(TransactionXid transactionXid, String identifier) {
        this.unlockTransactionInMongoDB(transactionXid, identifier);
    }

    public void unlockTransactionInMongoDB(TransactionXid transactionXid, String identifier) {
        byte[] global = transactionXid.getGlobalTransactionId();
        String instanceId = ByteUtils.byteArrayToString((byte[])global);
        try {
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_LOCKS);
            String system = CommonUtils.getApplication((String)this.endpoint);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)instanceId);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)system);
            Bson instIdFilter = Filters.eq((String)"identifier", (Object)identifier);
            DeleteResult result = collection.deleteOne(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter, instIdFilter}));
            if (result.getDeletedCount() == 0L) {
                logger.warn("Error occurred while unlocking transaction(gxid= {}).", (Object)instanceId);
            }
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while unlocking transaction(gxid= {})!", (Object)instanceId, (Object)rex);
        }
    }

    public synchronized void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
        String path;
        String application = CommonUtils.getApplication((String)this.endpoint);
        String prefix = String.format("%s/%s/instances/", CONSTANTS_ROOT_PATH, application);
        String parent = String.format("%s/%s/instances", CONSTANTS_ROOT_PATH, application);
        String current = event.getPath();
        if (CuratorEventType.CHILDREN.equals((Object)event.getType())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)parent, (CharSequence)current) && event.getStat() != null) {
                Set<String> original = this.instances.keySet();
                List children = event.getChildren();
                HashSet<String> deleted = new HashSet<String>(original);
                HashSet created = new HashSet(children);
                deleted.removeAll(children);
                created.removeAll(original);
                for (String element : deleted) {
                    this.instances.remove(element);
                }
                for (String element : created) {
                    String path2 = String.format("%s/%s", parent, element);
                    ((ErrorListenerPathable)((BackgroundPathable)this.curatorFramework.getData().usingWatcher((CuratorWatcher)this)).inBackground((BackgroundCallback)this)).forPath(path2);
                }
            }
        } else if (CuratorEventType.GET_DATA.equals((Object)event.getType())) {
            String path3 = String.format("%s/%s", parent, this.endpoint);
            if (current.startsWith(prefix) && event.getStat() != null) {
                String system = current.substring(prefix.length());
                long version = ByteUtils.byteArrayToLong((byte[])event.getData());
                this.instances.put(system, version);
            } else if (StringUtils.equals((CharSequence)path3, (CharSequence)current) && event.getStat() == null) {
                this.initializeCurrentClusterInstanceConfigIfNecessary();
            }
        } else if (CuratorEventType.DELETE.equals((Object)event.getType()) && StringUtils.equalsIgnoreCase((CharSequence)(path = String.format("%s/%s", parent, this.endpoint)), (CharSequence)current)) {
            this.initializeCurrentClusterInstanceConfigIfNecessary();
        }
    }

    public synchronized void stateChanged(CuratorFramework client, ConnectionState target) {
        switch (target) {
            case CONNECTED: 
            case RECONNECTED: {
                try {
                    this.initializeClusterInstanceConfig();
                }
                catch (Exception ex) {
                    logger.error("Error occurred while registering curator watcher!", (Throwable)ex);
                }
                break;
            }
        }
    }

    public void process(WatchedEvent event) throws Exception {
        if (Watcher.Event.EventType.NodeChildrenChanged.equals((Object)event.getType())) {
            this.processNodeChildrenChanged(event);
        }
    }

    private void processNodeChildrenChanged(WatchedEvent event) throws Exception {
        this.getInstancesDirectorysChildrenAndRegisterWatcher();
    }

    private void getInstancesDirectorysChildrenAndRegisterWatcher() throws Exception {
        String parent = String.format("%s/%s/instances", CONSTANTS_ROOT_PATH, CommonUtils.getApplication((String)this.endpoint));
        ((ErrorListenerPathable)((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher((CuratorWatcher)this)).inBackground((BackgroundCallback)this)).forPath(parent);
    }

    public long getInstanceVersion(String instanceId) {
        Long version = this.instances.get(instanceId);
        return version == null ? -1L : version;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

