/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.internal;

import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Closeable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bytesoft.bytejta.supports.internal.MongoInstanceVersionManager;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.supports.TransactionResourceListener;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class MongoTransactionLogger
implements TransactionLogger,
TransactionResourceListener,
EnvironmentAware,
TransactionEndpointAware,
TransactionBeanFactoryAware,
InitializingBean {
    static Logger logger = LoggerFactory.getLogger(MongoTransactionLogger.class);
    static final String CONSTANTS_DB_NAME = "bytejta";
    static final String CONSTANTS_TB_TRANSACTIONS = "transactions";
    static final String CONSTANTS_FD_GLOBAL = "gxid";
    static final String CONSTANTS_FD_BRANCH = "bxid";
    static final String CONSTANTS_FD_SYSTEM = "system";
    static final int MONGODB_ERROR_DUPLICATE_KEY = 11000;
    @Resource
    private MongoClient mongoClient;
    private String endpoint;
    private Environment environment;
    @Inject
    private MongoInstanceVersionManager versionManager;
    @Inject
    private TransactionBeanFactory beanFactory;
    private volatile boolean initializeEnabled = true;

    public void afterPropertiesSet() throws Exception {
        if (this.initializeEnabled) {
            this.initializeIndexIfNecessary();
        }
    }

    private void initializeIndexIfNecessary() {
        this.createTransactionsGlobalTxKeyIndexIfNecessary();
        this.createTransactionsApplicationIndexIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTransactionsApplicationIndexIfNecessary() {
        MongoDatabase database = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
        MongoCollection transactions = database.getCollection(CONSTANTS_TB_TRANSACTIONS);
        ListIndexesIterable transactionIndexList = transactions.listIndexes();
        boolean applicationIndexExists = false;
        MongoCursor applicationCursor = null;
        try {
            applicationCursor = transactionIndexList.iterator();
            while (!applicationIndexExists && applicationCursor.hasNext()) {
                Document document = (Document)applicationCursor.next();
                Boolean unique = document.getBoolean((Object)"unique");
                Document key = (Document)document.get((Object)"key");
                boolean systemExists = key.containsKey((Object)CONSTANTS_FD_SYSTEM);
                boolean lengthEquals = key.size() == 1;
                applicationIndexExists = lengthEquals && systemExists;
                if (!applicationIndexExists || unique == null || !unique.booleanValue()) continue;
                throw new IllegalStateException();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)applicationCursor);
        }
        if (!applicationIndexExists) {
            transactions.createIndex((Bson)new Document(CONSTANTS_FD_SYSTEM, (Object)1), new IndexOptions().unique(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTransactionsGlobalTxKeyIndexIfNecessary() {
        MongoDatabase database = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
        MongoCollection transactions = database.getCollection(CONSTANTS_TB_TRANSACTIONS);
        ListIndexesIterable transactionIndexList = transactions.listIndexes();
        boolean transactionIndexExists = false;
        MongoCursor transactionCursor = null;
        try {
            transactionCursor = transactionIndexList.iterator();
            while (!transactionIndexExists && transactionCursor.hasNext()) {
                Document document = (Document)transactionCursor.next();
                Boolean unique = document.getBoolean((Object)"unique");
                Document key = (Document)document.get((Object)"key");
                boolean globalExists = key.containsKey((Object)CONSTANTS_FD_GLOBAL);
                boolean systemExists = key.containsKey((Object)CONSTANTS_FD_SYSTEM);
                boolean lengthEquals = key.size() == 2;
                transactionIndexExists = lengthEquals && globalExists && systemExists;
                if (!transactionIndexExists || unique != null && unique.booleanValue()) continue;
                throw new IllegalStateException();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)transactionCursor);
        }
        if (!transactionIndexExists) {
            Document index = new Document(CONSTANTS_FD_GLOBAL, (Object)1).append(CONSTANTS_FD_SYSTEM, (Object)1);
            transactions.createIndex((Bson)index, new IndexOptions().unique(true));
        }
    }

    public void onEnlistResource(Xid xid, XAResource xares) {
    }

    public void onDelistResource(Xid xid, XAResource xares) {
        this.upsertParticipant((TransactionXid)xid, (XAResourceArchive)xares);
    }

    public void createTransaction(TransactionArchive archive) {
        try {
            TransactionXid transactionXid = (TransactionXid)archive.getXid();
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            byte[] global = transactionXid.getGlobalTransactionId();
            String identifier = ByteUtils.byteArrayToString((byte[])global);
            long version = this.versionManager.getInstanceVersion(this.endpoint);
            if (version <= 0L) {
                throw new IllegalStateException(String.format("Invalid version(%s)!", this.endpoint));
            }
            Document document = this.constructMongoDocument(archive);
            document.append(CONSTANTS_FD_GLOBAL, (Object)identifier);
            document.append(CONSTANTS_FD_SYSTEM, (Object)application);
            document.append("created", (Object)this.endpoint);
            document.append("modified", (Object)this.endpoint);
            document.append("propagated_by", archive.getPropagatedBy());
            document.append("coordinator", (Object)archive.isCoordinator());
            document.append("vote", (Object)archive.getVote());
            document.append("status", (Object)archive.getStatus());
            document.append("lock", (Object)0);
            document.append("locked_by", (Object)this.endpoint);
            document.append("error", (Object)false);
            document.append("version", (Object)version);
            collection.insertOne((Object)document);
        }
        catch (RuntimeException error) {
            logger.error("Error occurred while creating transaction.", (Throwable)error);
            this.beanFactory.getTransactionManager().setRollbackOnlyQuietly();
        }
    }

    public void updateTransaction(TransactionArchive archive) {
        try {
            TransactionXid transactionXid = (TransactionXid)archive.getXid();
            byte[] global = transactionXid.getGlobalTransactionId();
            String identifier = ByteUtils.byteArrayToString((byte[])global);
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            Document variables = this.constructMongoDocument(archive);
            Document document = new Document();
            document.append("$set", (Object)variables);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)identifier);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            UpdateResult result = collection.updateOne(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter}), (Bson)document);
            if (result.getMatchedCount() != 1L) {
                throw new IllegalStateException(String.format("Error occurred while updating transaction(matched= %s, modified= %s).", result.getMatchedCount(), result.getModifiedCount()));
            }
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while updating transaction.", (Throwable)rex);
        }
    }

    public Document constructMongoDocument(TransactionArchive archive) {
        Document variables = new Document();
        variables.append("modified", (Object)this.endpoint);
        variables.append("vote", (Object)archive.getVote());
        variables.append("status", (Object)archive.getStatus());
        variables.append("recovered_at", (Object)(archive.getRecoveredAt() == 0L ? null : new Date(archive.getRecoveredAt())));
        variables.append("recovered_times", (Object)archive.getRecoveredTimes());
        List nativeList = archive.getNativeResources();
        Document natives = new Document();
        for (int i = 0; nativeList != null && i < nativeList.size(); ++i) {
            XAResourceArchive resourceArchive = (XAResourceArchive)nativeList.get(i);
            TransactionXid resourceXid = (TransactionXid)resourceArchive.getXid();
            byte[] branchQualifier = resourceXid.getBranchQualifier();
            String branchKey = ByteUtils.byteArrayToString((byte[])branchQualifier);
            Document participant = this.constructMongoDocument(resourceArchive);
            natives.append(branchKey, (Object)participant);
        }
        variables.append("xaresources", (Object)natives);
        List remoteList = archive.getRemoteResources();
        Document remotes = new Document();
        for (int i = 0; remoteList != null && i < remoteList.size(); ++i) {
            XAResourceArchive resourceArchive = (XAResourceArchive)remoteList.get(i);
            TransactionXid resourceXid = (TransactionXid)resourceArchive.getXid();
            byte[] branchQualifier = resourceXid.getBranchQualifier();
            String branchKey = ByteUtils.byteArrayToString((byte[])branchQualifier);
            Document participant = this.constructMongoDocument(resourceArchive);
            remotes.append(branchKey, (Object)participant);
        }
        variables.append("participants", (Object)remotes);
        return variables;
    }

    public Document constructMongoDocument(XAResourceArchive resourceArchive) {
        XAResourceDescriptor descriptor = resourceArchive.getDescriptor();
        String descriptorType = descriptor.getClass().getName();
        String descriptorName = descriptor.getIdentifier();
        int branchVote = resourceArchive.getVote();
        boolean readonly = resourceArchive.isReadonly();
        boolean committed = resourceArchive.isCommitted();
        boolean rolledback = resourceArchive.isRolledback();
        boolean completed = resourceArchive.isCompleted();
        boolean heuristic = resourceArchive.isHeuristic();
        Document participant = new Document();
        participant.append("type", (Object)descriptorType);
        participant.append("name", (Object)descriptorName);
        participant.append("vote", (Object)branchVote);
        participant.append("committed", (Object)committed);
        participant.append("rolledback", (Object)rolledback);
        participant.append("readonly", (Object)readonly);
        participant.append("completed", (Object)completed);
        participant.append("heuristic", (Object)heuristic);
        participant.append("modified", (Object)this.endpoint);
        return participant;
    }

    public void deleteTransaction(TransactionArchive archive) {
        try {
            TransactionXid transactionXid = (TransactionXid)archive.getXid();
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection transactions = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            byte[] globalTransactionId = transactionXid.getGlobalTransactionId();
            Bson xidBson = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)ByteUtils.byteArrayToString((byte[])globalTransactionId));
            Bson created = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            DeleteResult result = transactions.deleteOne(Filters.and((Bson[])new Bson[]{xidBson, created}));
            if (result.getDeletedCount() != 1L) {
                throw new IllegalStateException(String.format("Error occurred while deleting transaction(deleted= %s).", result.getDeletedCount()));
            }
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while deleting transaction!", (Throwable)rex);
        }
    }

    public void createResource(XAResourceArchive archive) {
    }

    public void updateResource(XAResourceArchive archive) {
    }

    public void deleteResource(XAResourceArchive archive) {
    }

    public void createParticipant(XAResourceArchive archive) {
        try {
            this.upsertParticipant((TransactionXid)archive.getXid(), archive);
        }
        catch (RuntimeException error) {
            logger.error("Error occurred while creating participant!", (Throwable)error);
            this.beanFactory.getTransactionManager().setRollbackOnlyQuietly();
        }
    }

    public void updateParticipant(XAResourceArchive archive) {
        try {
            this.upsertParticipant((TransactionXid)archive.getXid(), archive);
        }
        catch (RuntimeException error) {
            logger.error("Error occurred while updating participant.", (Throwable)error);
            this.beanFactory.getTransactionManager().setRollbackOnlyQuietly();
        }
    }

    private void upsertParticipant(TransactionXid transactionXid, XAResourceArchive archive) {
        byte[] globalTransactionId = transactionXid.getGlobalTransactionId();
        byte[] branchQualifier = transactionXid.getBranchQualifier();
        String globalKey = ByteUtils.byteArrayToString((byte[])globalTransactionId);
        String branchKey = ByteUtils.byteArrayToString((byte[])branchQualifier);
        XAResourceDescriptor descriptor = archive.getDescriptor();
        String descriptorType = descriptor.getClass().getName();
        String descriptorName = descriptor.getIdentifier();
        int branchVote = archive.getVote();
        boolean readonly = archive.isReadonly();
        boolean committed = archive.isCommitted();
        boolean rolledback = archive.isRolledback();
        boolean completed = archive.isCompleted();
        boolean heuristic = archive.isHeuristic();
        Document participant = new Document();
        participant.append("type", (Object)descriptorType);
        participant.append("name", (Object)descriptorName);
        participant.append("vote", (Object)branchVote);
        participant.append("committed", (Object)committed);
        participant.append("rolledback", (Object)rolledback);
        participant.append("readonly", (Object)readonly);
        participant.append("completed", (Object)completed);
        participant.append("heuristic", (Object)heuristic);
        participant.append("modified", (Object)this.endpoint);
        MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
        MongoCollection collection = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
        Document participants = new Document();
        participants.append(String.format("participants.%s", branchKey), (Object)participant);
        Document document = new Document();
        document.append("$set", (Object)participants);
        String application = CommonUtils.getApplication((String)this.endpoint);
        Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)globalKey);
        Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
        UpdateResult result = collection.updateOne(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter}), (Bson)document);
        if (result.getMatchedCount() != 1L) {
            throw new IllegalStateException(String.format("Error occurred while creating/updating participant(matched= %s, modified= %s).", result.getMatchedCount(), result.getModifiedCount()));
        }
    }

    public void deleteParticipant(XAResourceArchive archive) {
        try {
            TransactionXid transactionXid = (TransactionXid)archive.getXid();
            byte[] global = transactionXid.getGlobalTransactionId();
            byte[] branch = transactionXid.getBranchQualifier();
            String globalKey = ByteUtils.byteArrayToString((byte[])global);
            String branchKey = ByteUtils.byteArrayToString((byte[])branch);
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)globalKey);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            Bson filter = Filters.and((Bson[])new Bson[]{globalFilter, systemFilter});
            Document participants = new Document();
            participants.append(String.format("participants.%s", branchKey), null);
            Document document = new Document();
            document.append("$unset", (Object)participants);
            UpdateResult result = collection.updateOne(filter, (Bson)document);
            if (result.getMatchedCount() != 1L) {
                throw new IllegalStateException(String.format("Error occurred while deleting participant(matched= %s, modified= %s).", result.getMatchedCount(), result.getModifiedCount()));
            }
        }
        catch (RuntimeException error) {
            logger.error("Error occurred while deleting participant.", (Throwable)error);
            this.beanFactory.getTransactionManager().setRollbackOnlyQuietly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void recover(TransactionRecoveryCallback callback) {
        block8: {
            MongoCursor transactionCursor = null;
            try {
                MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
                MongoCollection transactions = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
                String application = CommonUtils.getApplication((String)this.endpoint);
                Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
                Bson coordinatorFilter = Filters.eq((String)"coordinator", (Object)true);
                FindIterable transactionItr = transactions.find(Filters.and((Bson[])new Bson[]{systemFilter, coordinatorFilter}));
                transactionCursor = transactionItr.iterator();
                while (transactionCursor.hasNext()) {
                    Document document = (Document)transactionCursor.next();
                    boolean error = document.getBoolean((Object)"error");
                    String targetApplication = document.getString((Object)CONSTANTS_FD_SYSTEM);
                    long expectVersion = document.getLong((Object)"version");
                    long actualVersion = this.versionManager.getInstanceVersion(targetApplication);
                    if (!error && actualVersion > 0L && actualVersion <= expectVersion) continue;
                    callback.recover(this.reconstructTransactionArchive(document));
                }
                IOUtils.closeQuietly((Closeable)transactionCursor);
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while recovering transaction.", (Throwable)rex);
            }
            catch (Exception ex) {
                logger.error("Error occurred while recovering transaction.", (Throwable)ex);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(transactionCursor);
            }
        }
    }

    public TransactionArchive reconstructTransactionArchive(Document document) throws Exception {
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionArchive archive = new TransactionArchive();
        String global = document.getString((Object)CONSTANTS_FD_GLOBAL);
        byte[] globalTransactionId = ByteUtils.stringToByteArray((String)global);
        TransactionXid globalXid = xidFactory.createGlobalXid(globalTransactionId);
        archive.setXid((Xid)globalXid);
        String propagatedBy = document.getString((Object)"propagated_by");
        boolean coordinator = document.getBoolean((Object)"coordinator");
        int transactionStatus = document.getInteger((Object)"status");
        Integer recoveredTimes = document.getInteger((Object)"recovered_times");
        Date recoveredAt = document.getDate((Object)"recovered_at");
        archive.setCoordinator(coordinator);
        archive.setStatus(transactionStatus);
        archive.setPropagatedBy((Object)propagatedBy);
        archive.setRecoveredAt(recoveredAt == null ? 0L : recoveredAt.getTime());
        archive.setRecoveredTimes(recoveredTimes == null ? 0 : recoveredTimes);
        Document natives = (Document)document.get((Object)"xaresources", Document.class);
        for (String key : natives.keySet()) {
            Document element = (Document)natives.get((Object)key, Document.class);
            XAResourceArchive resourceArchive = this.reconstructXAResourceArchive(element);
            archive.getNativeResources().add(resourceArchive);
        }
        Document remotes = (Document)document.get((Object)"participants", Document.class);
        for (String key : remotes.keySet()) {
            Document element = (Document)remotes.get((Object)key, Document.class);
            XAResourceArchive resourceArchive = this.reconstructXAResourceArchive(element);
            archive.getRemoteResources().add(resourceArchive);
        }
        return archive;
    }

    public XAResourceArchive reconstructXAResourceArchive(Document document) {
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        XAResourceArchive participant = new XAResourceArchive();
        String gxid = document.getString((Object)CONSTANTS_FD_GLOBAL);
        String bxid = document.getString((Object)CONSTANTS_FD_BRANCH);
        String descriptorType = document.getString((Object)"type");
        String descriptorName = document.getString((Object)"name");
        int vote = document.getInteger((Object)"vote");
        boolean committed = document.getBoolean((Object)"committed");
        boolean rolledback = document.getBoolean((Object)"rolledback");
        boolean readonly = document.getBoolean((Object)"readonly");
        boolean completed = document.getBoolean((Object)"completed");
        boolean heuristic = document.getBoolean((Object)"heuristic");
        byte[] globalTransactionId = ByteUtils.stringToByteArray((String)gxid);
        byte[] branchQualifier = ByteUtils.stringToByteArray((String)bxid);
        TransactionXid globalXid = xidFactory.createGlobalXid(globalTransactionId);
        TransactionXid branchXid = xidFactory.createBranchXid(globalXid, branchQualifier);
        participant.setXid((Xid)branchXid);
        XAResourceDeserializer resourceDeserializer = this.beanFactory.getResourceDeserializer();
        XAResourceDescriptor descriptor = resourceDeserializer.deserialize(descriptorName);
        if (descriptor != null && !descriptor.getClass().getName().equals(descriptorType)) {
            throw new IllegalStateException();
        }
        participant.setVote(vote);
        participant.setCommitted(committed);
        participant.setRolledback(rolledback);
        participant.setReadonly(readonly);
        participant.setCompleted(completed);
        participant.setHeuristic(heuristic);
        participant.setDescriptor(descriptor);
        return participant;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public MongoInstanceVersionManager getVersionManager() {
        return this.versionManager;
    }

    public void setVersionManager(MongoInstanceVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

