/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.internal;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bytesoft.bytejta.supports.internal.MongoInstanceVersionManager;
import org.bytesoft.bytejta.supports.internal.MongoTransactionLogger;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionException;
import org.bytesoft.transaction.TransactionRecovery;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTransactionRepository
implements TransactionRepository,
TransactionEndpointAware,
EnvironmentAware,
TransactionBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(MongoTransactionRepository.class);
    static final String CONSTANTS_ROOT_PATH = "/org/bytesoft/bytejta";
    static final String CONSTANTS_DB_NAME = "bytejta";
    static final String CONSTANTS_TB_TRANSACTIONS = "transactions";
    static final String CONSTANTS_TB_PARTICIPANTS = "participants";
    static final String CONSTANTS_FD_GLOBAL = "gxid";
    static final String CONSTANTS_FD_BRANCH = "bxid";
    static final String CONSTANTS_FD_SYSTEM = "system";
    @Resource
    private MongoClient mongoClient;
    private String endpoint;
    private Environment environment;
    @Inject
    private MongoInstanceVersionManager versionManager;
    @Inject
    private TransactionBeanFactory beanFactory;

    public void putTransaction(TransactionXid transactionXid, Transaction transaction) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transaction getTransaction(TransactionXid xid) throws TransactionException {
        Transaction transaction;
        MongoCursor transactionCursor;
        TransactionRecovery transactionRecovery;
        TransactionLogger transactionLogger;
        block6: {
            transactionLogger = this.beanFactory.getTransactionLogger();
            transactionRecovery = this.beanFactory.getTransactionRecovery();
            transactionCursor = null;
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection transactions = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            byte[] global = xid.getGlobalTransactionId();
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)ByteUtils.byteArrayToString((byte[])global));
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            FindIterable transactionItr = transactions.find(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter}));
            transactionCursor = transactionItr.iterator();
            transactionCursor = transactionItr.iterator();
            if (transactionCursor.hasNext()) break block6;
            Transaction transaction2 = null;
            IOUtils.closeQuietly((Closeable)transactionCursor);
            return transaction2;
        }
        try {
            Document document = (Document)transactionCursor.next();
            MongoTransactionLogger mongoTransactionLogger = (MongoTransactionLogger)transactionLogger;
            TransactionArchive archive = mongoTransactionLogger.reconstructTransactionArchive(document);
            transaction = transactionRecovery.reconstruct(archive);
        }
        catch (RuntimeException rex) {
            try {
                logger.error("Error occurred while loading transaction(xid= {}).", (Object)xid, (Object)rex);
                throw new TransactionException(-3);
                catch (Exception ex) {
                    logger.error("Error occurred while loading transaction(xid= {}).", (Object)xid, (Object)ex);
                    throw new TransactionException(-3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(transactionCursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)transactionCursor);
        return transaction;
    }

    public Transaction removeTransaction(TransactionXid xid) {
        return null;
    }

    public void putErrorTransaction(TransactionXid transactionXid, Transaction transaction) {
        try {
            TransactionArchive archive = transaction.getTransactionArchive();
            byte[] global = transactionXid.getGlobalTransactionId();
            String identifier = ByteUtils.byteArrayToString((byte[])global);
            String application = CommonUtils.getApplication((String)this.endpoint);
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection collection = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            Document target = new Document();
            target.append("modified", (Object)this.endpoint);
            target.append("status", (Object)archive.getStatus());
            target.append("error", (Object)true);
            target.append("recovered_at", (Object)(archive.getRecoveredAt() == 0L ? null : new Date(archive.getRecoveredAt())));
            target.append("recovered_times", (Object)archive.getRecoveredTimes());
            Document document = new Document();
            document.append("$set", (Object)target);
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)identifier);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            UpdateResult result = collection.updateOne(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter}), (Bson)document);
            if (result.getMatchedCount() != 1L) {
                throw new IllegalStateException(String.format("Error occurred while updating transaction(matched= %s, modified= %s).", result.getMatchedCount(), result.getModifiedCount()));
            }
        }
        catch (RuntimeException error) {
            logger.error("Error occurred while setting the error flag.", (Throwable)error);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transaction getErrorTransaction(TransactionXid xid) throws TransactionException {
        Transaction transaction;
        MongoCursor transactionCursor;
        TransactionRecovery transactionRecovery;
        TransactionLogger transactionLogger;
        block6: {
            transactionLogger = this.beanFactory.getTransactionLogger();
            transactionRecovery = this.beanFactory.getTransactionRecovery();
            transactionCursor = null;
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection transactions = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            byte[] global = xid.getGlobalTransactionId();
            Bson globalFilter = Filters.eq((String)CONSTANTS_FD_GLOBAL, (Object)ByteUtils.byteArrayToString((byte[])global));
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            Bson errorFilter = Filters.eq((String)"error", (Object)true);
            FindIterable transactionItr = transactions.find(Filters.and((Bson[])new Bson[]{globalFilter, systemFilter, errorFilter}));
            transactionCursor = transactionItr.iterator();
            if (transactionCursor.hasNext()) break block6;
            Transaction transaction2 = null;
            IOUtils.closeQuietly((Closeable)transactionCursor);
            return transaction2;
        }
        try {
            Document document = (Document)transactionCursor.next();
            MongoTransactionLogger mongoTransactionLogger = (MongoTransactionLogger)transactionLogger;
            TransactionArchive archive = mongoTransactionLogger.reconstructTransactionArchive(document);
            transaction = transactionRecovery.reconstruct(archive);
        }
        catch (RuntimeException error) {
            try {
                logger.error("Error occurred while getting error transaction.", (Throwable)error);
                throw new TransactionException(-3);
                catch (Exception error2) {
                    logger.error("Error occurred while getting error transaction.", (Throwable)error2);
                    throw new TransactionException(-3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(transactionCursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)transactionCursor);
        return transaction;
    }

    public Transaction removeErrorTransaction(TransactionXid xid) {
        return null;
    }

    public List<Transaction> getActiveTransactionList() {
        return new ArrayList<Transaction>();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Transaction> getErrorTransactionList() throws TransactionException {
        ArrayList<Transaction> arrayList;
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        TransactionRecovery transactionRecovery = this.beanFactory.getTransactionRecovery();
        ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
        MongoCursor transactionCursor = null;
        try {
            MongoDatabase mdb = this.mongoClient.getDatabase(CONSTANTS_DB_NAME);
            MongoCollection transactions = mdb.getCollection(CONSTANTS_TB_TRANSACTIONS);
            String application = CommonUtils.getApplication((String)this.endpoint);
            Bson systemFilter = Filters.eq((String)CONSTANTS_FD_SYSTEM, (Object)application);
            Bson coordinatorFilter = Filters.eq((String)"coordinator", (Object)true);
            FindIterable transactionItr = transactions.find(Filters.and((Bson[])new Bson[]{systemFilter, coordinatorFilter}));
            transactionCursor = transactionItr.iterator();
            while (transactionCursor.hasNext()) {
                Document document = (Document)transactionCursor.next();
                boolean error = document.getBoolean((Object)"error");
                String targetApplication = document.getString((Object)"created");
                long expectVersion = document.getLong((Object)"version");
                long actualVersion = this.versionManager.getInstanceVersion(targetApplication);
                if (!error && actualVersion > 0L && actualVersion <= expectVersion) continue;
                MongoTransactionLogger mongoTransactionLogger = (MongoTransactionLogger)transactionLogger;
                TransactionArchive archive = mongoTransactionLogger.reconstructTransactionArchive(document);
                Transaction transaction = transactionRecovery.reconstruct(archive);
                transactionList.add(transaction);
            }
            arrayList = transactionList;
        }
        catch (RuntimeException rex) {
            try {
                logger.error("Error occurred while loading transactions.", (Throwable)rex);
                throw new TransactionException(-3);
                catch (Exception ex) {
                    logger.error("Error occurred while loading transactions.", (Throwable)ex);
                    throw new TransactionException(-3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(transactionCursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)transactionCursor);
        return arrayList;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public MongoInstanceVersionManager getVersionManager() {
        return this.versionManager;
    }

    public void setVersionManager(MongoInstanceVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

