/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAConnectionImpl
implements XAConnection,
ConnectionEventListener {
    static final Logger logger = LoggerFactory.getLogger(XAConnectionImpl.class);
    private final Set<ConnectionEventListener> listeners = new HashSet<ConnectionEventListener>();
    private String identifier;
    private XAConnection delegate;
    private boolean closed;

    public void connectionClosed(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.listeners) {
            try {
                listener.connectionClosed(new ConnectionEvent(this, event.getSQLException()));
            }
            catch (RuntimeException rex) {
                logger.warn(rex.getMessage(), (Throwable)rex);
            }
        }
        this.firePhysicalConnectionClosed(event);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        for (ConnectionEventListener listener : this.listeners) {
            try {
                listener.connectionErrorOccurred(new ConnectionEvent(this, event.getSQLException()));
            }
            catch (RuntimeException rex) {
                logger.warn(rex.getMessage(), (Throwable)rex);
            }
        }
        this.firePhysicalConnectionClosed(event);
    }

    private void firePhysicalConnectionClosed(ConnectionEvent event) {
        try {
            this.delegate.removeConnectionEventListener(this);
            this.close();
        }
        catch (SQLException ex) {
            logger.warn("Failed to close XAConnection", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            logger.warn("Failed to close XAConnection", (Throwable)ex);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public void addStatementEventListener(StatementEventListener listener) {
        this.delegate.addStatementEventListener(listener);
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        this.delegate.removeStatementEventListener(listener);
    }

    public XAResource getXAResource() throws SQLException {
        XAResource xares = this.delegate.getXAResource();
        if (XAResourceDescriptor.class.isInstance(xares)) {
            return xares;
        }
        CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
        descriptor.setDelegate(xares);
        descriptor.setIdentifier(this.identifier);
        return descriptor;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            this.delegate.close();
            this.closed = true;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public XAConnection getDelegate() {
        return this.delegate;
    }

    public void setDelegate(XAConnection delegate) {
        this.delegate = delegate;
    }
}

