/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.XAConnectionFactory;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.bytesoft.bytejta.supports.resource.ManagedConnectionHandler;

public class ManagedConnectionFactoryHandler
implements InvocationHandler {
    private final Object delegate;
    private String identifier;

    public ManagedConnectionFactoryHandler(Object xads) {
        this.delegate = xads;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object finalObject;
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> returningClass = method.getReturnType();
        Object resultObject = method.invoke(this.delegate, args);
        Class<?> clazz = resultObject.getClass();
        ClassLoader cl = clazz.getClassLoader();
        boolean containsReturningClass = false;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> interfaceClass = interfaces[i];
            if (!interfaceClass.equals(returningClass)) continue;
            containsReturningClass = true;
            break;
        }
        if (XADataSource.class.equals(declaringClass) && XAConnection.class.equals(returningClass)) {
            ManagedConnectionHandler interceptor = new ManagedConnectionHandler(resultObject);
            interceptor.setIdentifier(this.identifier);
            finalObject = null;
            if (containsReturningClass) {
                finalObject = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
            } else {
                Class[] interfaceArray = new Class[interfaces.length + 1];
                System.arraycopy(interfaces, 0, interfaceArray, 0, interfaces.length);
                interfaceArray[interfaces.length] = XAConnection.class;
                finalObject = Proxy.newProxyInstance(cl, interfaceArray, (InvocationHandler)interceptor);
            }
            return (XAConnection)finalObject;
        }
        if (XAConnectionFactory.class.equals(declaringClass) && javax.jms.XAConnection.class.equals(returningClass)) {
            ManagedConnectionHandler interceptor = new ManagedConnectionHandler(resultObject);
            interceptor.setIdentifier(this.identifier);
            finalObject = null;
            if (containsReturningClass) {
                finalObject = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
            } else {
                Class[] interfaceArray = new Class[interfaces.length + 1];
                System.arraycopy(interfaces, 0, interfaceArray, 0, interfaces.length);
                interfaceArray[interfaces.length] = javax.jms.XAConnection.class;
                finalObject = Proxy.newProxyInstance(cl, interfaceArray, (InvocationHandler)interceptor);
            }
            return (javax.jms.XAConnection)finalObject;
        }
        if (ManagedConnectionFactory.class.equals(declaringClass) && ManagedConnection.class.equals(returningClass)) {
            ManagedConnectionHandler interceptor = new ManagedConnectionHandler(resultObject);
            interceptor.setIdentifier(this.identifier);
            finalObject = null;
            if (containsReturningClass) {
                finalObject = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)interceptor);
            } else {
                Class[] interfaceArray = new Class[interfaces.length + 1];
                System.arraycopy(interfaces, 0, interfaceArray, 0, interfaces.length);
                interfaceArray[interfaces.length] = ManagedConnection.class;
                finalObject = Proxy.newProxyInstance(cl, interfaceArray, (InvocationHandler)interceptor);
            }
            return (ManagedConnection)finalObject;
        }
        return resultObject;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

