/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.rpc;

import javax.inject.Inject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionManager;
import org.bytesoft.transaction.TransactionParticipant;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.remote.RemoteCoordinator;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionInterceptorImpl
implements TransactionInterceptor,
TransactionBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionInterceptorImpl.class);
    @Inject
    private TransactionBeanFactory beanFactory;

    public void beforeSendRequest(TransactionRequest request) throws IllegalStateException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        if (transaction == null) {
            return;
        }
        if (transaction.getTransactionStatus() == 1) {
            throw new IllegalStateException("Transaction has been marked as rollback only, can not propagate its context to remote branch.");
        }
        TransactionContext srcTransactionContext = transaction.getTransactionContext();
        TransactionContext transactionContext = srcTransactionContext.clone();
        request.setTransactionContext(transactionContext);
        try {
            RemoteCoordinator resource = request.getTargetTransactionCoordinator();
            RemoteResourceDescriptor descriptor = new RemoteResourceDescriptor();
            descriptor.setDelegate(resource);
            boolean participantEnlisted = transaction.enlistResource((XAResource)descriptor);
            ((TransactionRequestImpl)request).setParticipantEnlistFlag(participantEnlisted);
        }
        catch (IllegalStateException ex) {
            logger.error("TransactionInterceptorImpl.beforeSendRequest(TransactionRequest)", (Throwable)ex);
            throw ex;
        }
        catch (RollbackException ex) {
            transaction.setRollbackOnlyQuietly();
            logger.error("TransactionInterceptorImpl.beforeSendRequest(TransactionRequest)", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        catch (SystemException ex) {
            logger.error("TransactionInterceptorImpl.beforeSendRequest(TransactionRequest)", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public void beforeSendResponse(TransactionResponse response) throws IllegalStateException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        if (transaction == null) {
            return;
        }
        TransactionParticipant coordinator = this.beanFactory.getNativeParticipant();
        TransactionContext srcTransactionContext = transaction.getTransactionContext();
        TransactionContext transactionContext = srcTransactionContext.clone();
        transactionContext.setPropagatedBy(srcTransactionContext.getPropagatedBy());
        response.setTransactionContext(transactionContext);
        try {
            coordinator.end(transactionContext, 0x4000000);
        }
        catch (XAException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void afterReceiveRequest(TransactionRequest request) throws IllegalStateException {
        TransactionContext srcTransactionContext = request.getTransactionContext();
        if (srcTransactionContext == null) {
            return;
        }
        TransactionParticipant coordinator = this.beanFactory.getNativeParticipant();
        TransactionContext transactionContext = srcTransactionContext.clone();
        transactionContext.setPropagatedBy(srcTransactionContext.getPropagatedBy());
        try {
            coordinator.start(transactionContext, 0);
        }
        catch (XAException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void afterReceiveResponse(TransactionResponse response) throws IllegalStateException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        TransactionContext transactionContext = response.getTransactionContext();
        RemoteCoordinator resource = response.getSourceTransactionCoordinator();
        boolean participantEnlistFlag = ((TransactionResponseImpl)response).isParticipantEnlistFlag();
        if (transaction == null || transactionContext == null) {
            return;
        }
        if (!participantEnlistFlag) {
            return;
        }
        if (resource == null) {
            logger.error("TransactionInterceptorImpl.afterReceiveResponse(TransactionRequest): remote coordinator is null.");
            throw new IllegalStateException("remote coordinator is null.");
        }
        try {
            RemoteResourceDescriptor descriptor = new RemoteResourceDescriptor();
            descriptor.setDelegate(resource);
            transaction.delistResource((XAResource)descriptor, 0x4000000);
        }
        catch (IllegalStateException ex) {
            logger.error("TransactionInterceptorImpl.afterReceiveResponse(TransactionRequest)", (Throwable)ex);
            throw ex;
        }
        catch (SystemException ex) {
            logger.error("TransactionInterceptorImpl.afterReceiveResponse(TransactionRequest)", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

