/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.serialize;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Session;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.resource.cci.Connection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.bytesoft.bytejta.supports.jdbc.DataSourceHolder;
import org.bytesoft.bytejta.supports.jdbc.RecoveredResource;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XAResourceDeserializerImpl
implements XAResourceDeserializer,
ApplicationContextAware {
    static final Logger logger = LoggerFactory.getLogger(XAResourceDeserializerImpl.class);
    private Map<String, XAResourceDescriptor> cachedResourceMap = new ConcurrentHashMap<String, XAResourceDescriptor>();
    private ApplicationContext applicationContext;

    public XAResourceDescriptor deserialize(String identifier) {
        XAResourceDescriptor cachedResource = this.cachedResourceMap.get(identifier);
        if (cachedResource != null) {
            return cachedResource;
        }
        try {
            Object bean = this.applicationContext.getBean(identifier);
            XAResourceDescriptor resolvedResource = this.deserializeResource(identifier, bean);
            if (resolvedResource == null) {
                logger.error("can not find a matching xa-resource(identifier= {})!", (Object)identifier);
                return null;
            }
            this.cachedResourceMap.put(identifier, resolvedResource);
            return resolvedResource;
        }
        catch (BeansException bex) {
            logger.error("can not find a matching xa-resource(identifier= {})!", (Object)identifier);
            return null;
        }
        catch (Exception ex) {
            logger.error("can not find a matching xa-resource(identifier= {})!", (Object)identifier, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XAResourceDescriptor deserializeResource(String identifier, Object bean) throws Exception {
        if (DataSourceHolder.class.isInstance(bean)) {
            DataSourceHolder holder = (DataSourceHolder)bean;
            RecoveredResource xares = new RecoveredResource();
            xares.setDataSource(holder.getDataSource());
            LocalXAResourceDescriptor descriptor = new LocalXAResourceDescriptor();
            descriptor.setDelegate((XAResource)xares);
            descriptor.setIdentifier(identifier);
            return descriptor;
        }
        if (DataSource.class.isInstance(bean)) {
            DataSource dataSource = (DataSource)bean;
            RecoveredResource xares = new RecoveredResource();
            xares.setDataSource(dataSource);
            LocalXAResourceDescriptor descriptor = new LocalXAResourceDescriptor();
            descriptor.setDelegate((XAResource)xares);
            descriptor.setIdentifier(identifier);
            return descriptor;
        }
        if (XADataSource.class.isInstance(bean)) {
            XADataSource xaDataSource = (XADataSource)bean;
            XAConnection xaConnection = xaDataSource.getXAConnection();
            java.sql.Connection connection = null;
            try {
                connection = xaConnection.getConnection();
                XAResource xares = xaConnection.getXAResource();
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(xares);
                descriptor.setIdentifier(identifier);
                descriptor.setManaged((Object)xaConnection);
                CommonResourceDescriptor commonResourceDescriptor = descriptor;
                return commonResourceDescriptor;
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
                XAResource xares = xaConnection.getXAResource();
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(xares);
                descriptor.setIdentifier(identifier);
                descriptor.setManaged((Object)xaConnection);
                CommonResourceDescriptor commonResourceDescriptor = descriptor;
                return commonResourceDescriptor;
            }
            finally {
                this.closeQuietly(connection);
            }
        }
        if (XAConnectionFactory.class.isInstance(bean)) {
            XAConnectionFactory connectionFactory = (XAConnectionFactory)bean;
            javax.jms.XAConnection xaConnection = connectionFactory.createXAConnection();
            XASession xaSession = xaConnection.createXASession();
            Session session = null;
            try {
                session = xaSession.getSession();
                XAResource xares = xaSession.getXAResource();
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(xares);
                descriptor.setIdentifier(identifier);
                descriptor.setManaged((Object)xaConnection);
                CommonResourceDescriptor commonResourceDescriptor = descriptor;
                return commonResourceDescriptor;
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
                XAResource xares2 = xaSession.getXAResource();
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(xares2);
                descriptor.setIdentifier(identifier);
                descriptor.setManaged((Object)xaConnection);
                CommonResourceDescriptor commonResourceDescriptor = descriptor;
                return commonResourceDescriptor;
            }
            finally {
                this.closeQuietly(session);
            }
        }
        if (ManagedConnectionFactory.class.isInstance(bean)) {
            ManagedConnectionFactory connectionFactory = (ManagedConnectionFactory)bean;
            ManagedConnection managedConnection = connectionFactory.createManagedConnection(null, null);
            Connection connection = null;
            try {
                connection = (Connection)managedConnection.getConnection(null, null);
                XAResource xares = managedConnection.getXAResource();
                CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                descriptor.setDelegate(xares);
                descriptor.setIdentifier(identifier);
                descriptor.setManaged((Object)managedConnection);
                CommonResourceDescriptor xares2 = descriptor;
                this.closeQuietly(connection);
                return xares2;
            }
            catch (Exception ex) {
                try {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                    XAResource xares = managedConnection.getXAResource();
                    CommonResourceDescriptor descriptor = new CommonResourceDescriptor();
                    descriptor.setDelegate(xares);
                    descriptor.setIdentifier(identifier);
                    descriptor.setManaged((Object)managedConnection);
                    CommonResourceDescriptor commonResourceDescriptor = descriptor;
                    this.closeQuietly(connection);
                    return commonResourceDescriptor;
                }
                catch (Throwable throwable) {
                    this.closeQuietly(connection);
                    throw throwable;
                }
            }
        }
        return null;
    }

    protected void closeQuietly(Connection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    protected void closeQuietly(java.sql.Connection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    protected void closeQuietly(Session closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

