/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.spring;

import java.util.Iterator;
import java.util.Map;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class TransactionBeanFactoryAutoInjector
implements BeanPostProcessor,
SmartInitializingSingleton,
ApplicationContextAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionBeanFactoryAutoInjector.class);
    private ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        Iterator iterator;
        Map beanMap = this.applicationContext.getBeansOfType(TransactionBeanFactoryAware.class);
        Iterator iterator2 = iterator = beanMap == null ? null : beanMap.entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TransactionBeanFactoryAware bean = (TransactionBeanFactoryAware)entry.getValue();
            this.initializeTransactionBeanFactoryIfNecessary(bean);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (TransactionBeanFactoryAware.class.isInstance(bean)) {
            this.initializeTransactionBeanFactoryIfNecessary((TransactionBeanFactoryAware)bean);
        }
        return bean;
    }

    private void initializeTransactionBeanFactoryIfNecessary(TransactionBeanFactoryAware aware) {
        if (aware.getBeanFactory() == null) {
            TransactionBeanFactory beanFactory = (TransactionBeanFactory)this.applicationContext.getBean(TransactionBeanFactory.class);
            aware.setBeanFactory(beanFactory);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

