/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.config.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.extra.config.generic.TargetPropertyAccessor;

public class BeanPropertyAccessor
implements TargetPropertyAccessor {
    private static final String[] PREFIX = new String[]{"get", "is"};
    private final Map<String, Method> gettersLookupMap;

    public BeanPropertyAccessor(Class<?> clazz) {
        this.gettersLookupMap = BeanPropertyAccessor.generateGetterLookupMap(clazz);
    }

    @Override
    public Collection<String> getNames() {
        return this.gettersLookupMap.keySet();
    }

    @Override
    public Class<?> getType(String propertyName) {
        return this.gettersLookupMap.get(propertyName).getReturnType();
    }

    @Override
    public Object access(Object target, String propertyName) throws InvocationTargetException, IllegalAccessException {
        return this.gettersLookupMap.get(propertyName).invoke(target, new Object[0]);
    }

    static Map<String, Method> generateGetterLookupMap(Class<?> c) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        block0: for (Method m : c.getMethods()) {
            if (m.getReturnType() == Void.TYPE || m.getParameterCount() != 0 || m.getName().equals("getClass")) continue;
            for (String prefix : PREFIX) {
                if (!m.getName().startsWith(prefix)) continue;
                String propertyName = BeanPropertyAccessor.generatePropertyName(prefix, m.getName());
                Method m0 = map.put(propertyName, m);
                if (m0 == null) continue block0;
                throw new IllegalArgumentException("Ambiguous getter for property '" + propertyName + "' in class '" + c.getSimpleName() + "'");
            }
        }
        return map;
    }

    static String generatePropertyName(String prefix, String s) {
        return BeanPropertyAccessor.changeFirstCharToLowerCase(s.substring(prefix.length()));
    }

    static String changeFirstCharToLowerCase(String v) {
        return Character.toLowerCase(v.charAt(0)) + v.substring(1);
    }
}

