/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.util.concurrent.atomic.AtomicLong;
import javax.cache.management.CacheStatisticsMXBean;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.jcache.provider.JCacheAdapter;

public class CacheJmxStatistics
implements CacheStatisticsMXBean {
    private final InternalCache cache;
    private final JCacheAdapter adapter;
    private final AtomicLong missOffset = new AtomicLong();
    private final AtomicLong putsOffset = new AtomicLong();
    private final AtomicLong getsOffset = new AtomicLong();
    private final AtomicLong evictionsOffset = new AtomicLong();
    private final AtomicLong removalsOffset = new AtomicLong();
    private final AtomicLong hitsOffset = new AtomicLong();

    public CacheJmxStatistics(JCacheAdapter _cache) {
        this.cache = _cache.cache;
        this.adapter = _cache;
    }

    public void clear() {
        this.evictionsOffset.addAndGet(this.getCacheEvictions());
        this.putsOffset.addAndGet(this.getCachePuts());
        this.getsOffset.addAndGet(this.getCacheGets());
        this.removalsOffset.addAndGet(this.getCacheRemovals());
        this.hitsOffset.addAndGet(this.getCacheHits());
        this.missOffset.addAndGet(this.getCacheMisses());
    }

    public long getCacheHits() {
        InternalCacheInfo inf = this.getInfo();
        return this.calcHits(inf) - this.hitsOffset.get();
    }

    private long calcHits(InternalCacheInfo inf) {
        long _readUsage = inf.getGetCount();
        long _missCount = inf.getMissCount();
        return _readUsage - _missCount + this.adapter.iterationHitCorrectionCounter.get();
    }

    public float getCacheHitPercentage() {
        InternalCacheInfo inf = this.getInfo();
        long _hits = this.calcHits(inf);
        long _miss = this.calcMisses(inf);
        if (_hits == 0L) {
            return 0.0f;
        }
        return (float)_hits * 100.0f / (float)(_hits + _miss);
    }

    public long getCacheMisses() {
        InternalCacheInfo inf = this.getInfo();
        return this.calcMisses(inf) - this.missOffset.get();
    }

    private long calcMisses(InternalCacheInfo inf) {
        return inf.getMissCount();
    }

    public float getCacheMissPercentage() {
        InternalCacheInfo inf = this.getInfo();
        return inf.getGetCount() == 0L ? 0.0f : 100.0f * (float)inf.getMissCount() / (float)inf.getGetCount();
    }

    public long getCacheGets() {
        return this.getInfo().getGetCount() + this.adapter.iterationHitCorrectionCounter.get() - this.getsOffset.get();
    }

    public long getCachePuts() {
        return this.getInfo().getPutCount() - this.putsOffset.get();
    }

    public long getCacheRemovals() {
        return this.getInfo().getRemoveCount() - this.removalsOffset.get();
    }

    public long getCacheEvictions() {
        return this.getInfo().getEvictedCount() - this.evictionsOffset.get();
    }

    public float getAverageGetTime() {
        return (float)this.getInfo().getMillisPerLoad();
    }

    public float getAveragePutTime() {
        return 0.0f;
    }

    public float getAverageRemoveTime() {
        return 0.0f;
    }

    private InternalCacheInfo getInfo() {
        return this.cache.getInfo();
    }
}

