/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.InternalCache;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.jcache.provider.JCacheBuilder;
import org.cache2k.jcache.provider.JCacheJmxSupport;
import org.cache2k.jcache.provider.JCacheProvider;
import org.cache2k.jcache.provider.TouchyJCacheAdapter;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CopyCacheProxy;

public class JCacheManagerAdapter
implements javax.cache.CacheManager {
    private static final JCacheJmxSupport jmxSupport = JCacheManagerAdapter.findJCacheJmxSupportInstance();
    private CacheManager manager;
    private JCacheProvider provider;
    private Map<String, javax.cache.Cache> name2adapter = new HashMap<String, javax.cache.Cache>();
    private volatile Map<Cache, javax.cache.Cache> c2k2jCache = Collections.emptyMap();
    private final Set<String> configuredCacheNames;

    private static JCacheJmxSupport findJCacheJmxSupportInstance() {
        for (CacheLifeCycleListener l : CacheManagerImpl.getCacheLifeCycleListeners()) {
            if (!(l instanceof JCacheJmxSupport)) continue;
            return (JCacheJmxSupport)l;
        }
        return null;
    }

    public JCacheManagerAdapter(JCacheProvider p, CacheManager cm) {
        this.manager = cm;
        this.provider = p;
        HashSet<String> _names = new HashSet<String>();
        for (String s : this.manager.getConfiguredCacheNames()) {
            _names.add(s);
        }
        this.configuredCacheNames = Collections.unmodifiableSet(_names);
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.provider.name2Uri(this.manager.getName());
    }

    public ClassLoader getClassLoader() {
        return this.manager.getClassLoader();
    }

    public Properties getProperties() {
        return this.manager.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String _cacheName, C cfg) throws IllegalArgumentException {
        this.checkClosed();
        this.checkNonNullCacheName(_cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            javax.cache.Cache _jsr107cache = this.name2adapter.get(_cacheName);
            if (_jsr107cache != null && !_jsr107cache.isClosed()) {
                throw new CacheException("cache already existing with name: " + _cacheName);
            }
            Cache _existingCache = this.manager.getCache(_cacheName);
            if (_existingCache != null && !_existingCache.isClosed()) {
                throw new CacheException("A cache2k instance is already existing with name: " + _cacheName);
            }
            JCacheBuilder _builder = new JCacheBuilder(_cacheName, this);
            _builder.setConfiguration(cfg);
            javax.cache.Cache _cache = _builder.build();
            Cache _cache2k = (Cache)_cache.unwrap(Cache.class);
            WeakHashMap<Cache, javax.cache.Cache> _cloneC2k2jCache = new WeakHashMap<Cache, javax.cache.Cache>();
            _cloneC2k2jCache.putAll(this.c2k2jCache);
            _cloneC2k2jCache.put(_cache2k, _cache);
            this.c2k2jCache = _cloneC2k2jCache;
            this.name2adapter.put(_cache.getName(), _cache);
            if (_builder.getCompleteConfiguration().isStatisticsEnabled()) {
                this.enableStatistics(_cacheName, true);
            }
            if (_builder.getCompleteConfiguration().isManagementEnabled()) {
                this.enableManagement(_cacheName, true);
            }
            return _cache;
        }
    }

    private Object getLockObject() {
        return ((CacheManagerImpl)this.manager).getLockObject();
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String _cacheName, Class<K> _keyType, Class<V> _valueType) {
        if (_keyType == null || _valueType == null) {
            throw new NullPointerException();
        }
        javax.cache.Cache<K, V> c = this.getCache(_cacheName);
        if (c == null) {
            return null;
        }
        Configuration cfg = c.getConfiguration(Configuration.class);
        if (!cfg.getKeyType().equals(_keyType)) {
            throw new ClassCastException("key type mismatch, expected: " + cfg.getKeyType().getName());
        }
        if (!cfg.getValueType().equals(_valueType)) {
            throw new ClassCastException("value type mismatch, expected: " + cfg.getValueType().getName());
        }
        return c;
    }

    private JCacheAdapter getAdapter(String _name) {
        javax.cache.Cache ca = this.name2adapter.get(_name);
        if (ca instanceof CopyCacheProxy) {
            ca = ((CopyCacheProxy)ca).getWrappedCache();
        }
        if (ca instanceof TouchyJCacheAdapter) {
            return ((TouchyJCacheAdapter)ca).cache;
        }
        return (JCacheAdapter)ca;
    }

    private void checkNonNullCacheName(String _cacheName) {
        if (_cacheName == null) {
            throw new NullPointerException("cache name is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> javax.cache.Cache<K, V> getCache(String _cacheName) {
        this.checkClosed();
        this.checkNonNullCacheName(_cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            javax.cache.Cache c = this.name2adapter.get(_cacheName);
            if (c != null && this.manager.getCache(_cacheName) == c.unwrap(Cache.class) && !c.isClosed()) {
                return c;
            }
            if (this.configuredCacheNames.contains(_cacheName)) {
                return this.createCache(_cacheName, new MutableConfiguration());
            }
        }
        return null;
    }

    public Iterable<String> getCacheNames() {
        this.checkClosed();
        HashSet<String> _names = new HashSet<String>();
        for (Cache c : this.manager.getActiveCaches()) {
            _names.add(c.getName());
        }
        _names.addAll(this.configuredCacheNames);
        return Collections.unmodifiableSet(_names);
    }

    public void destroyCache(String _cacheName) {
        this.checkClosed();
        this.checkNonNullCacheName(_cacheName);
        Cache c = this.manager.getCache(_cacheName);
        if (c != null) {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableManagement(String _cacheName, boolean enabled) {
        this.checkClosed();
        this.checkNonNullCacheName(_cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            JCacheAdapter ca = this.getAdapter(_cacheName);
            if (ca == null) {
                return;
            }
            javax.cache.Cache c = this.name2adapter.get(_cacheName);
            if (enabled) {
                if (!ca.jmxEnabled) {
                    jmxSupport.enableJmx((Cache)ca.cache, c);
                    ca.jmxEnabled = true;
                }
            } else if (ca.jmxEnabled) {
                jmxSupport.disableJmx((Cache)ca.cache);
                ca.jmxEnabled = false;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache manager is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStatistics(String _cacheName, boolean enabled) {
        this.checkClosed();
        this.checkNonNullCacheName(_cacheName);
        Object object = this.getLockObject();
        synchronized (object) {
            if (enabled) {
                JCacheAdapter ca = this.getAdapter(_cacheName);
                if (ca != null) {
                    InternalCache internalCache = ca.cache;
                    synchronized (internalCache) {
                        if (!ca.jmxStatisticsEnabled) {
                            jmxSupport.enableStatistics(ca);
                            ca.jmxStatisticsEnabled = true;
                        }
                    }
                }
            } else {
                JCacheAdapter ca = this.getAdapter(_cacheName);
                if (ca != null) {
                    InternalCache internalCache = ca.cache;
                    synchronized (internalCache) {
                        if (ca.jmxStatisticsEnabled) {
                            jmxSupport.disableStatistics((Cache)ca.cache);
                            ca.jmxStatisticsEnabled = false;
                        }
                    }
                }
            }
        }
    }

    public void close() {
        this.manager.close();
    }

    public boolean isClosed() {
        return this.manager.isClosed();
    }

    public <T> T unwrap(Class<T> _class) {
        if (CacheManager.class.isAssignableFrom(_class)) {
            return (T)this.manager;
        }
        throw new IllegalArgumentException("requested unwrap class not available");
    }

    public CacheManager getCache2kManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.Cache resolveCacheWrapper(Cache _c2kCache) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.c2k2jCache.get(_c2kCache);
        }
    }
}

