/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.event;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.EventType;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CustomizationCollection;
import org.cache2k.configuration.CustomizationReferenceSupplier;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.jcache.provider.event.AsyncDispatcher;
import org.cache2k.jcache.provider.event.EntryEvent;
import org.cache2k.jcache.provider.event.EntryEventWithOldValue;
import org.cache2k.jcache.provider.event.Listener;

public class EventHandling<K, V> {
    private javax.cache.Cache resolvedJCache;
    private final List<Listener.Created<K, V>> createdListener = new CopyOnWriteArrayList<Listener.Created<K, V>>();
    private final List<Listener.Updated<K, V>> updatedListener = new CopyOnWriteArrayList<Listener.Updated<K, V>>();
    private final List<Listener.Removed<K, V>> removedListener = new CopyOnWriteArrayList<Listener.Removed<K, V>>();
    private final List<Listener.Expired<K, V>> expiredListener = new CopyOnWriteArrayList<Listener.Expired<K, V>>();
    private final AsyncDispatcher<K, V> asyncDispatcher;
    private final JCacheManagerAdapter manager;

    public EventHandling(JCacheManagerAdapter m, Executor ex) {
        this.asyncDispatcher = new AsyncDispatcher(ex);
        this.manager = m;
    }

    void addAsyncListener(Listener<K, V> l) {
        this.asyncDispatcher.addAsyncListener(l);
    }

    static <T extends Listener<K, V>, K, V> boolean removeCfgMatch(CacheEntryListenerConfiguration<K, V> cfg, List<T> _listenerList) {
        for (Listener l : _listenerList) {
            if (!l.config.equals(cfg)) continue;
            _listenerList.remove(l);
            EventHandling.removeCfgMatch(cfg, _listenerList);
            return true;
        }
        return false;
    }

    public boolean deregisterListener(CacheEntryListenerConfiguration<K, V> cfg) {
        boolean _found = EventHandling.removeCfgMatch(cfg, this.createdListener);
        _found |= EventHandling.removeCfgMatch(cfg, this.updatedListener);
        _found |= EventHandling.removeCfgMatch(cfg, this.removedListener);
        _found |= EventHandling.removeCfgMatch(cfg, this.expiredListener);
        return _found |= this.asyncDispatcher.removeAsyncListener(cfg);
    }

    public Collection<CacheEntryListenerConfiguration<K, V>> getAllListenerConfigurations() {
        Collection<Listener<K, V>> l = this.getAllListeners();
        HashSet<CacheEntryListenerConfiguration<K, V>> _cfgs = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        for (Listener<K, V> li : l) {
            _cfgs.add(li.config);
        }
        return _cfgs;
    }

    private Collection<Listener<K, V>> getAllListeners() {
        ArrayList l = new ArrayList();
        l.addAll(this.createdListener);
        l.addAll(this.updatedListener);
        l.addAll(this.removedListener);
        l.addAll(this.expiredListener);
        this.asyncDispatcher.collectListeners(l);
        return l;
    }

    public void close() {
        HashSet ls = new HashSet();
        for (Listener<K, V> listener : this.getAllListeners()) {
            ls.add(listener.entryListener);
        }
        for (CacheEntryListener cacheEntryListener : ls) {
            if (!(cacheEntryListener instanceof Closeable)) continue;
            try {
                ((Closeable)cacheEntryListener).close();
            }
            catch (Exception e) {
                throw new CacheException("closing listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(CacheEntryListenerConfiguration<K, V> cfg) {
        Listener l;
        AsyncDispatcher<K, V> asyncDispatcher = this.asyncDispatcher;
        synchronized (asyncDispatcher) {
            if (this.getAllListenerConfigurations().contains(cfg)) {
                throw new IllegalArgumentException("configuration already registered");
            }
        }
        Factory _filterFactory = cfg.getCacheEntryEventFilterFactory();
        Factory _listenerFactory = cfg.getCacheEntryListenerFactory();
        if (_listenerFactory == null) {
            throw new IllegalArgumentException("listener factory missing");
        }
        CacheEntryEventFilter _filter = null;
        if (_filterFactory != null) {
            _filter = (CacheEntryEventFilter)_filterFactory.create();
        }
        Object _listener = _listenerFactory.create();
        boolean _synchronous = cfg.isSynchronous();
        if (_listener instanceof javax.cache.event.CacheEntryCreatedListener) {
            l = new Listener.Created<K, V>(cfg, _filter, (javax.cache.event.CacheEntryCreatedListener)_listener);
            if (_synchronous) {
                this.createdListener.add((Listener.Created<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (_listener instanceof javax.cache.event.CacheEntryUpdatedListener) {
            l = new Listener.Updated<K, V>(cfg, _filter, (javax.cache.event.CacheEntryUpdatedListener)_listener);
            if (_synchronous) {
                this.updatedListener.add((Listener.Updated<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (_listener instanceof CacheEntryRemovedListener) {
            l = new Listener.Removed<K, V>(cfg, _filter, (CacheEntryRemovedListener)_listener);
            if (_synchronous) {
                this.removedListener.add((Listener.Removed<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
        if (_listener instanceof javax.cache.event.CacheEntryExpiredListener) {
            l = new Listener.Expired<K, V>(cfg, _filter, (javax.cache.event.CacheEntryExpiredListener)_listener);
            if (_synchronous) {
                this.expiredListener.add((Listener.Expired<K, V>)l);
            } else {
                this.addAsyncListener(l);
            }
        }
    }

    public void registerCache2kListeners(Cache2kConfiguration<K, V> cfg) {
        CustomizationCollection _listeners = cfg.getListeners();
        _listeners.add(new CustomizationReferenceSupplier((Object)new CreatedListenerAdapter()));
        _listeners.add(new CustomizationReferenceSupplier((Object)new UpdatedListenerAdapter()));
        _listeners.add(new CustomizationReferenceSupplier((Object)new RemovedListenerAdapter()));
        _listeners.add(new CustomizationReferenceSupplier((Object)new ExpiredListenerAdapter()));
    }

    private V extractValue(V _value) {
        return _value;
    }

    private void fireCreated(javax.cache.Cache<K, V> _jCache, CacheEntry<K, V> e) {
        EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(_jCache, EventType.CREATED, e.getKey(), this.extractValue(e.getValue()));
        this.asyncDispatcher.deliverAsyncEvent(cee);
        for (Listener listener : this.createdListener) {
            listener.fire(cee);
        }
    }

    private javax.cache.Cache getCache(Cache<K, V> c) {
        if (this.resolvedJCache != null) {
            return this.resolvedJCache;
        }
        this.resolvedJCache = this.manager.resolveCacheWrapper(c);
        return this.resolvedJCache;
    }

    class ExpiredListenerAdapter
    implements CacheEntryExpiredListener<K, V> {
        ExpiredListenerAdapter() {
        }

        public void onEntryExpired(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache _jCache = EventHandling.this.getCache(c);
            EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(_jCache, EventType.EXPIRED, e.getKey(), EventHandling.this.extractValue(e.getValue()));
            EventHandling.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandling.this.expiredListener) {
                t.fire(cee);
            }
        }
    }

    class RemovedListenerAdapter
    implements org.cache2k.event.CacheEntryRemovedListener<K, V> {
        RemovedListenerAdapter() {
        }

        public void onEntryRemoved(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache _jCache = EventHandling.this.getCache(c);
            Object val = EventHandling.this.extractValue(e.getValue());
            EntryEventWithOldValue<Object, Object> cee = new EntryEventWithOldValue<Object, Object>(_jCache, EventType.REMOVED, e.getKey(), val, val);
            EventHandling.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandling.this.removedListener) {
                t.fire(cee);
            }
        }
    }

    class UpdatedListenerAdapter
    implements CacheEntryUpdatedListener<K, V> {
        UpdatedListenerAdapter() {
        }

        public void onEntryUpdated(Cache<K, V> c, CacheEntry<K, V> _currentEntry, CacheEntry<K, V> entryWithNewData) {
            javax.cache.Cache _jCache = EventHandling.this.getCache(c);
            if (entryWithNewData.getException() != null) {
                if (_currentEntry.getException() != null) {
                    return;
                }
                EntryEvent<Object, Object> cee = new EntryEvent<Object, Object>(_jCache, EventType.REMOVED, entryWithNewData.getKey(), EventHandling.this.extractValue(_currentEntry.getValue()));
                EventHandling.this.asyncDispatcher.deliverAsyncEvent(cee);
                for (Listener t : EventHandling.this.removedListener) {
                    t.fire(cee);
                }
                return;
            }
            if (_currentEntry.getException() != null) {
                EventHandling.this.fireCreated(_jCache, entryWithNewData);
                return;
            }
            Object v0 = _currentEntry.getValue();
            Object v1 = entryWithNewData.getValue();
            EntryEventWithOldValue<Object, Object> cee = new EntryEventWithOldValue<Object, Object>(_jCache, EventType.UPDATED, entryWithNewData.getKey(), EventHandling.this.extractValue(v1), EventHandling.this.extractValue(v0));
            EventHandling.this.asyncDispatcher.deliverAsyncEvent(cee);
            for (Listener t : EventHandling.this.updatedListener) {
                t.fire(cee);
            }
        }
    }

    class CreatedListenerAdapter
    implements CacheEntryCreatedListener<K, V> {
        CreatedListenerAdapter() {
        }

        public void onEntryCreated(Cache<K, V> c, CacheEntry<K, V> e) {
            if (e.getException() != null) {
                return;
            }
            javax.cache.Cache _jCache = EventHandling.this.getCache(c);
            EventHandling.this.fireCreated(_jCache, e);
        }
    }
}

