/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider.generic.storeByValueSimulation;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.ObjectTransformer;

public class TransformingCacheProxy<K, V, K0, V0>
implements Cache<K, V> {
    protected ObjectTransformer<K, K0> keyTransformer;
    protected ObjectTransformer<V, V0> valueTransformer;
    protected ObjectTransformer<K, K0> passingKeyTransformer;
    protected ObjectTransformer<V, V0> passingValueTransformer;
    protected Cache<K0, V0> cache;

    public TransformingCacheProxy(Cache<K0, V0> cache, ObjectTransformer<K, K0> keyTransformer, ObjectTransformer<V, V0> valueTransformer, ObjectTransformer<K, K0> passingKeyTransformer, ObjectTransformer<V, V0> passingValueTransformer) {
        this.cache = cache;
        this.keyTransformer = keyTransformer;
        this.passingKeyTransformer = passingKeyTransformer;
        this.passingValueTransformer = passingValueTransformer;
        this.valueTransformer = valueTransformer;
    }

    public V get(K key) {
        return this.valueTransformer.expand(this.cache.get(this.keyTransformer.compact(key)));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        Map m = this.cache.getAll(this.compactBoundedKeys(keys));
        return this.expandMap(m);
    }

    static <E, I> Set<I> compactSet(final Set<E> keys, final ObjectTransformer<E, I> tr) {
        if (keys == null) {
            return null;
        }
        final int _size = keys.size();
        return new AbstractSet<I>(){

            @Override
            public Iterator<I> iterator() {
                final Iterator it = keys.iterator();
                return new Iterator<I>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public I next() {
                        return tr.compact(it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return _size;
            }
        };
    }

    static <E, I> Set<I> compactBoundedSet(final Set<? extends E> keys, final ObjectTransformer<E, I> tr) {
        if (keys == null) {
            return null;
        }
        final int _size = keys.size();
        return new AbstractSet<I>(){

            @Override
            public Iterator<I> iterator() {
                final Iterator it = keys.iterator();
                return new Iterator<I>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public I next() {
                        return tr.compact(it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return _size;
            }
        };
    }

    static <E, I> Set<E> expandSet(final Set<I> keys, final ObjectTransformer<E, I> tr) {
        final int _size = keys.size();
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                final Iterator it = keys.iterator();
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public E next() {
                        return tr.expand(it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return _size;
            }
        };
    }

    Set<K> expandKeys(Set<K0> keys) {
        return TransformingCacheProxy.expandSet(keys, this.keyTransformer);
    }

    Set<K0> compactKeys(Set<K> keys) {
        return TransformingCacheProxy.compactSet(keys, this.keyTransformer);
    }

    Set<K0> compactBoundedKeys(Set<? extends K> keys) {
        return TransformingCacheProxy.compactBoundedSet(keys, this.keyTransformer);
    }

    Set<V> expandValues(Set<V0> values) {
        return TransformingCacheProxy.expandSet(values, this.valueTransformer);
    }

    Set<V0> compactValues(Set<V> values) {
        return TransformingCacheProxy.compactSet(values, this.valueTransformer);
    }

    Map<K0, V0> compactMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        HashMap<K0, V0> m2 = new HashMap<K0, V0>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            m2.put(this.keyTransformer.compact(e.getKey()), this.valueTransformer.compact(e.getValue()));
        }
        return m2;
    }

    Map<K, V> expandMap(Map<K0, V0> map) {
        HashMap<K, V> m2 = new HashMap<K, V>();
        for (Map.Entry<K0, V0> e : map.entrySet()) {
            m2.put(this.keyTransformer.expand(e.getKey()), this.valueTransformer.expand(e.getValue()));
        }
        return m2;
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(this.keyTransformer.compact(key));
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.cache.loadAll(this.compactBoundedKeys(keys), replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.cache.put(this.keyTransformer.compact(key), this.valueTransformer.compact(value));
    }

    public V getAndPut(K key, V value) {
        return this.valueTransformer.expand(this.cache.getAndPut(this.keyTransformer.compact(key), this.valueTransformer.compact(value)));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(this.compactMap(map));
    }

    public boolean putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(this.keyTransformer.compact(key), this.valueTransformer.compact(value));
    }

    public boolean remove(K key) {
        return this.cache.remove(this.passingKeyTransformer.compact(key));
    }

    public boolean remove(K key, V oldValue) {
        return this.cache.remove(this.passingKeyTransformer.compact(key), this.valueTransformer.compact(oldValue));
    }

    public V getAndRemove(K key) {
        return this.valueTransformer.expand(this.cache.getAndRemove(this.passingKeyTransformer.compact(key)));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(this.passingKeyTransformer.compact(key), this.passingValueTransformer.compact(oldValue), this.valueTransformer.compact(newValue));
    }

    public boolean replace(K key, V value) {
        return this.cache.replace(this.passingKeyTransformer.compact(key), this.valueTransformer.compact(value));
    }

    public V getAndReplace(K key, V value) {
        return this.passingValueTransformer.expand(this.cache.getAndReplace(this.passingKeyTransformer.compact(key), this.valueTransformer.compact(value)));
    }

    public void removeAll(Set<? extends K> keys) {
        this.cache.removeAll(this.compactBoundedKeys(keys));
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public void clear() {
        this.cache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        throw new UnsupportedOperationException();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        EntryProcessor<K0, V0, T> processor = this.wrapEntryProcessor(entryProcessor);
        return (T)this.cache.invoke(this.keyTransformer.compact(key), processor, arguments);
    }

    private <T> EntryProcessor<K0, V0, T> wrapEntryProcessor(final EntryProcessor<K, V, T> entryProcessor) {
        if (entryProcessor == null) {
            throw new NullPointerException("null processor");
        }
        return new EntryProcessor<K0, V0, T>(){

            public T process(MutableEntry<K0, V0> entry, Object ... arguments) throws EntryProcessorException {
                MutableEntry e = TransformingCacheProxy.this.wrapMutableEntry(entry);
                return entryProcessor.process(e, arguments);
            }
        };
    }

    private MutableEntry<K, V> wrapMutableEntry(final MutableEntry<K0, V0> entry) {
        return new MutableEntry<K, V>(){

            public boolean exists() {
                return entry.exists();
            }

            public void remove() {
                entry.remove();
            }

            public void setValue(V value) {
                entry.setValue(TransformingCacheProxy.this.valueTransformer.compact(value));
            }

            public K getKey() {
                return TransformingCacheProxy.this.keyTransformer.expand(entry.getKey());
            }

            public V getValue() {
                return TransformingCacheProxy.this.valueTransformer.expand(entry.getValue());
            }

            public <T> T unwrap(Class<T> clazz) {
                return (T)entry.unwrap(clazz);
            }
        };
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        EntryProcessor<K0, V0, T> processor = this.wrapEntryProcessor(entryProcessor);
        Map map = this.cache.invokeAll(this.compactBoundedKeys(keys), processor, arguments);
        HashMap m2 = new HashMap();
        for (Map.Entry e : map.entrySet()) {
            m2.put(this.keyTransformer.expand(e.getKey()), e.getValue());
        }
        return m2;
    }

    public String getName() {
        return this.cache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void close() {
        this.cache.close();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.cache.unwrap(clazz);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        final Iterator it = this.cache.iterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                final Cache.Entry e = (Cache.Entry)it.next();
                return new Cache.Entry<K, V>(){

                    public K getKey() {
                        return TransformingCacheProxy.this.keyTransformer.expand(e.getKey());
                    }

                    public V getValue() {
                        return TransformingCacheProxy.this.valueTransformer.expand(e.getValue());
                    }

                    public <T> T unwrap(Class<T> clazz) {
                        return (T)e.unwrap(clazz);
                    }
                };
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public Cache<K0, V0> getWrappedCache() {
        return this.cache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.cache + ")";
    }
}

