/*
 * Decompiled with CFR 0.152.
 */
package org.carewebframework.api.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.carewebframework.api.event.EventUtil;
import org.carewebframework.api.event.IGenericEvent;
import org.carewebframework.api.event.IPublisherInfo;
import org.carewebframework.api.test.CommonTest;
import org.carewebframework.api.test.TestPacket;
import org.junit.Assert;
import org.junit.Test;

public class GenericEventTest
extends CommonTest {
    private static final Log log = LogFactory.getLog(GenericEventTest.class);
    private static final String EVENT_NAME1 = "Event";
    private static final String EVENT_NAME2 = "Event.Subevent";
    protected static int pollingInterval = 500;
    private int eventCount;
    private int expectedUndelivered;
    private boolean pingResponded;
    protected boolean remote = false;
    protected String recipients = null;
    private final List<TestPacket> tests = Collections.synchronizedList(new ArrayList());
    protected String recipientId;
    private AssertionError assertionError;
    private final IGenericEvent<TestPacket> subscriber = new IGenericEvent<TestPacket>(){

        public void eventCallback(String eventName, TestPacket testPacket) {
            block2: {
                try {
                    log.info((Object)("Received: " + testPacket));
                    Assert.assertTrue((String)(testPacket + ": unexpected test packet"), (boolean)GenericEventTest.this.tests.remove(testPacket));
                    Assert.assertTrue((String)(testPacket + ": name does not match."), (boolean)testPacket.getEventName().equals(eventName));
                    Assert.assertTrue((String)(testPacket + ": should not have been received."), (boolean)testPacket.isShouldReceive());
                }
                catch (AssertionError e) {
                    if (GenericEventTest.this.assertionError != null) break block2;
                    GenericEventTest.this.assertionError = e;
                }
            }
        }
    };
    private final IGenericEvent<IPublisherInfo> pingSubscriber = new IGenericEvent<IPublisherInfo>(){

        public void eventCallback(String eventName, IPublisherInfo publisherInfo) {
            log.info((Object)publisherInfo);
            GenericEventTest.this.pingResponded = true;
        }
    };

    private void fireEvent(String eventName, boolean shouldReceive) {
        TestPacket testPacket = new TestPacket(++this.eventCount, eventName, shouldReceive, this.remote);
        this.tests.add(testPacket);
        if (!shouldReceive) {
            ++this.expectedUndelivered;
        }
        log.info((Object)("Sending: " + testPacket));
        if (this.remote) {
            eventManager.fireRemoteEvent(eventName, (Object)testPacket, this.recipients);
        } else {
            eventManager.fireLocalEvent(eventName, (Object)testPacket);
        }
    }

    @Test
    public void testEvents() {
        if (this.remote) {
            this.pingTest();
        }
        this.fireTestEvents();
        Assert.assertEquals((String)"Error testing ping response.", (Object)this.remote, (Object)this.pingResponded);
    }

    public void pingTest() {
        eventManager.subscribe("PING.TEST", this.pingSubscriber);
        EventUtil.ping((String)"PING.TEST", null, (String)this.recipients);
    }

    private void fireTestEvents() {
        this.fireEvent(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME2, false);
        this.subscribe(EVENT_NAME1, true);
        this.fireEvent(EVENT_NAME1, true);
        this.fireEvent(EVENT_NAME2, true);
        if (this.remote) {
            this.recipients = this.recipientId;
            this.fireEvent(EVENT_NAME1, true);
            this.fireEvent(EVENT_NAME2, true);
            this.recipients = "alternateClient";
            this.fireEvent(EVENT_NAME1, false);
            this.fireEvent(EVENT_NAME2, false);
            this.recipients = null;
        }
        this.subscribe(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME2, false);
        this.subscribe(EVENT_NAME2, true);
        this.fireEvent(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME2, true);
        if (this.remote) {
            this.recipients = this.recipientId;
            this.fireEvent(EVENT_NAME1, false);
            this.fireEvent(EVENT_NAME2, true);
            this.recipients = "alternateClient";
            this.fireEvent(EVENT_NAME1, false);
            this.fireEvent(EVENT_NAME2, false);
            this.recipients = null;
        }
        this.subscribe(EVENT_NAME1, true);
        this.subscribe(EVENT_NAME2, false);
        this.fireEvent(EVENT_NAME1, true);
        this.fireEvent(EVENT_NAME2, true);
        if (this.remote) {
            this.recipients = this.recipientId;
            this.fireEvent(EVENT_NAME1, true);
            this.fireEvent(EVENT_NAME2, true);
            this.recipients = "alternateClient";
            this.fireEvent(EVENT_NAME1, false);
            this.fireEvent(EVENT_NAME2, false);
            this.recipients = null;
        }
        this.subscribe(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME1, false);
        this.fireEvent(EVENT_NAME2, false);
        this.undeliveredEvents(this.remote);
        this.checkAssertion();
    }

    private void checkAssertion() {
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    private void subscribe(String eventName, boolean subscribe) {
        if (this.remote) {
            this.doWait(30);
        }
        if (subscribe) {
            eventManager.subscribe(eventName, this.subscriber);
        } else {
            eventManager.unsubscribe(eventName, this.subscriber);
        }
    }

    private void doWait(int count) {
        while (count-- > 0 && this.tests.size() > this.expectedUndelivered) {
            try {
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException e) {}
        }
        Assert.assertFalse((String)"Timed out waiting for packet delivery.", (this.tests.size() > this.expectedUndelivered ? 1 : 0) != 0);
    }

    private void undeliveredEvents(boolean wait) {
        if (wait) {
            this.doWait(20);
        }
        for (TestPacket testPacket : this.tests) {
            Assert.assertFalse((String)(testPacket + ": was not received."), (boolean)testPacket.isShouldReceive());
        }
        this.tests.clear();
    }
}

