/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.BindableDescriptorUtils;
import org.carrot2.util.attribute.BindableMetadata;
import org.carrot2.util.attribute.CommonMetadata;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.preprocessor.AttributeFieldInfo;
import org.carrot2.util.preprocessor.BindableFieldInfo;
import org.carrot2.util.preprocessor.BuilderBase;
import org.carrot2.util.preprocessor.DummyVariableElement;
import org.carrot2.util.preprocessor.MetadataExtractorUtils;
import org.carrot2.util.preprocessor.VelocityInitializer;
import org.carrot2.util.preprocessor.shaded.apache.velocity.Template;
import org.carrot2.util.preprocessor.shaded.apache.velocity.VelocityContext;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.RuntimeInstance;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.parser.ParseException;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.parser.impl.JFlexLexer;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.parser.impl.Parser;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.parser.structs.TagDef;

@SupportedAnnotationTypes(value={"org.carrot2.util.attribute.Bindable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class BindableProcessor
extends AbstractProcessor {
    private static final Set<String> ignoredPhases = new HashSet<String>(Arrays.asList("RECONCILE", "OTHER"));
    private Elements elements;
    private Filer filer;
    private Types types;
    private int round;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = this.processingEnv.getElementUtils();
        this.filer = this.processingEnv.getFiler();
        this.types = this.processingEnv.getTypeUtils();
        this.messager = this.processingEnv.getMessager();
        this.round = 0;
    }

    @Override
    public boolean process(Set<? extends TypeElement> ann, RoundEnvironment env) {
        String phase = this.processingEnv.getOptions().get("phase");
        if (phase != null && ignoredPhases.contains(phase)) {
            return false;
        }
        if (env.errorRaised()) {
            return false;
        }
        long start = System.currentTimeMillis();
        ++this.round;
        int count = 0;
        for (TypeElement e : ElementFilter.typesIn(env.getElementsAnnotatedWith(Bindable.class))) {
            if (e == null) continue;
            this.processBindable(e);
            ++count;
        }
        if (count > 0) {
            System.out.println(String.format(Locale.ENGLISH, "%d @Bindable metadata processed in round %d in %.2f secs.", count, this.round, (double)(System.currentTimeMillis() - start) / 1000.0));
        }
        return false;
    }

    private void processBindable(TypeElement type) {
        Label label;
        HashMap<String, String> tags = new HashMap<String, String>();
        String javaDoc = this.processJavaDoc(type, tags);
        BindableMetadata metadata = new BindableMetadata();
        this.extractTitleDescription(metadata, javaDoc);
        if (tags.get("label") != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Replace @label javadoc with a @Label annotation in: " + type.getQualifiedName());
        }
        if ((label = type.getAnnotation(Label.class)) != null) {
            metadata.setLabel(label.value());
        }
        LinkedHashMap<String, AttributeMetadata> attributeMetadata = new LinkedHashMap<String, AttributeMetadata>();
        ArrayList<AttributeFieldInfo> ownFields = new ArrayList<AttributeFieldInfo>();
        this.extractAttributeMetadata(type, ownFields, attributeMetadata);
        metadata.setAttributeMetadata(attributeMetadata);
        ArrayList<AttributeFieldInfo> superFields = new ArrayList<AttributeFieldInfo>();
        TypeElement i = this.extractSuperBindable(type);
        while (i != null) {
            this.extractAttributeMetadata(i, superFields, null);
            i = this.extractSuperBindable(i);
        }
        ArrayList<AttributeFieldInfo> allFields = new ArrayList<AttributeFieldInfo>();
        allFields.addAll(ownFields);
        allFields.addAll(superFields);
        this.emitMetadataClass(metadata, ownFields, allFields, type);
    }

    private TypeElement extractSuperBindable(TypeElement type) {
        TypeMirror superType = type.getSuperclass();
        while (superType.getKind() == TypeKind.DECLARED) {
            TypeElement asElement = (TypeElement)this.types.asElement(superType);
            if (asElement != null && asElement.getAnnotation(Bindable.class) != null) {
                return asElement;
            }
            superType = asElement.getSuperclass();
        }
        return null;
    }

    private void extractAttributeMetadata(TypeElement type, List<AttributeFieldInfo> attributeFields, Map<String, AttributeMetadata> attributeMetadata) {
        List<TypeElement> inheritedTypes = this.extractInheritedTypes(type);
        Map<String, AttributeFieldInfo> inheritedAttrs = this.extractInheritedAttrs(inheritedTypes);
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            Attribute attr = field.getAnnotation(Attribute.class);
            if (attr == null) continue;
            AttributeMetadata metadata = null;
            String javaDoc = null;
            if (attributeMetadata != null) {
                Label label;
                Group group;
                Level level;
                metadata = new AttributeMetadata();
                HashMap<String, String> tags = new HashMap<String, String>();
                javaDoc = this.processJavaDoc(field, tags);
                this.extractTitleDescription(metadata, javaDoc);
                if (tags.get("level") != null) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Replace @level javadoc with a @Level annotation in: " + type.getQualifiedName() + "#" + field.getSimpleName());
                }
                if ((level = field.getAnnotation(Level.class)) != null) {
                    metadata.setLevel(level.value());
                }
                if (tags.get("group") != null) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Replace @group javadoc with a @Group annotation in: " + type.getQualifiedName() + "#" + field.getSimpleName());
                }
                if ((group = field.getAnnotation(Group.class)) != null) {
                    metadata.setGroup(group.value());
                }
                if (tags.get("label") != null) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Replace @label javadoc with a @Label annotation in: " + type.getQualifiedName() + "#" + field.getSimpleName());
                }
                if ((label = field.getAnnotation(Label.class)) != null) {
                    metadata.setLabel(label.value());
                }
            }
            AttributeFieldInfo inherited = null;
            String attributeKey = this.getAttributeKey(field, attr);
            if (attr.inherit()) {
                inherited = inheritedAttrs.get(attributeKey);
                if (inherited == null && inheritedTypes.size() == 1 && this.isEclipseCompiler()) {
                    TypeElement e = inheritedTypes.get(0);
                    DummyVariableElement _field = new DummyVariableElement(field.getSimpleName());
                    inherited = new AttributeFieldInfo(attributeKey, null, null, _field, this.types, e.getQualifiedName().toString(), this.getDescriptorClassName(e), null, false);
                }
                if (inherited == null) {
                    String message = "No inheritable attribute for field " + field + " in class " + type.getQualifiedName() + " (expected inherited key: " + attributeKey + ").";
                    this.messager.printMessage(Diagnostic.Kind.ERROR, message);
                }
            }
            attributeFields.add(new AttributeFieldInfo(attributeKey, metadata, javaDoc, field, this.types, type.getQualifiedName().toString(), this.getDescriptorClassName(type), inherited, this.shouldGenerateClassSetter(field)));
            if (attributeMetadata == null) continue;
            String fieldName = field.getSimpleName().toString();
            attributeMetadata.put(fieldName, metadata);
        }
    }

    private boolean isEclipseCompiler() {
        return this.processingEnv.getClass().getName().startsWith("org.eclipse.");
    }

    private Map<String, AttributeFieldInfo> extractInheritedAttrs(List<TypeElement> inheritedTypes) {
        HashMap<String, AttributeFieldInfo> inheritedAttrs = new HashMap<String, AttributeFieldInfo>();
        for (TypeElement elem : inheritedTypes) {
            ArrayList<AttributeFieldInfo> attrs = new ArrayList<AttributeFieldInfo>();
            this.extractAttributeMetadata(elem, attrs, null);
            for (AttributeFieldInfo attr : attrs) {
                if (inheritedAttrs.containsKey(attr.getKey())) {
                    String message = "Duplicated attribute key " + attr.getKey() + " in attribute documentation inheritance " + "classes: " + attr.getDeclaringClass() + ", " + ((AttributeFieldInfo)inheritedAttrs.get(attr.getKey())).getDeclaringClass();
                    this.messager.printMessage(Diagnostic.Kind.ERROR, message);
                    throw new RuntimeException(message);
                }
                inheritedAttrs.put(attr.getKey(), attr);
            }
        }
        return inheritedAttrs;
    }

    private List<TypeElement> extractInheritedTypes(TypeElement type) {
        ArrayList<TypeElement> inheritedTypes = new ArrayList<TypeElement>();
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = this.elements.getElementValuesWithDefaults(annotationMirror);
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.getSimpleName().toString().equals("inherit")) continue;
                List clazzMirrors = (List)values.get(executableElement).getValue();
                for (AnnotationValue clazzMirror : clazzMirrors) {
                    TypeMirror typeMirror = (TypeMirror)clazzMirror.getValue();
                    TypeElement elem = (TypeElement)this.types.asElement(typeMirror);
                    inheritedTypes.add(elem);
                }
            }
        }
        return inheritedTypes;
    }

    private String getAttributeKey(VariableElement field, Attribute attr) {
        if (attr.key().length() > 0) {
            return attr.key();
        }
        String bindablePrefix = this.getBindablePrefix((TypeElement)field.getEnclosingElement());
        if (bindablePrefix == null) {
            return this.elements.getBinaryName((TypeElement)field.getEnclosingElement()) + "." + field.getSimpleName().toString();
        }
        return bindablePrefix + "." + field.getSimpleName();
    }

    private String getBindablePrefix(TypeElement bindable) {
        String prefix = bindable.getAnnotation(Bindable.class).prefix().trim();
        if (prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    private void emitMetadataClass(BindableMetadata metadata, List<AttributeFieldInfo> ownFields, List<AttributeFieldInfo> allFields, TypeElement type) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String descriptorClassName = this.getDescriptorClassName(type);
        PrintWriter w = null;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            w = new PrintWriter(this.filer.createSourceFile(descriptorClassName, type).openWriter());
            RuntimeInstance velocity = VelocityInitializer.createInstance(this.processingEnv.getMessager());
            VelocityContext context = VelocityInitializer.createContext();
            context.put("packageName", packageName);
            context.put("descriptorClassName", descriptorClassName);
            context.put("sourceType", type);
            context.put("bindable", type.getAnnotation(Bindable.class));
            context.put("metadata", metadata);
            context.put("ownFields", ownFields);
            context.put("allFields", allFields);
            context.put("nestedFields", this.extractStaticNestedBindables(type));
            TypeElement superBindable = this.extractSuperBindable(type);
            if (superBindable != null) {
                context.put("superBindableDescriptor", this.getDescriptorClassName(superBindable));
            }
            Template template = velocity.getTemplate("BindableDescriptor.template", "UTF-8");
            template.merge(context, w);
            Thread.currentThread().setContextClassLoader(ccl);
            if (w != null) {
                this.closeQuietly(w);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Could not serialize metadata for: " + type.toString(), e);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(ccl);
                if (w != null) {
                    this.closeQuietly(w);
                }
                throw throwable;
            }
        }
    }

    private String getDescriptorClassName(TypeElement type) {
        return BindableDescriptorUtils.getDescriptorClassName(this.elements.getBinaryName(type).toString());
    }

    private List<BindableFieldInfo> extractStaticNestedBindables(TypeElement type) {
        ArrayList<BindableFieldInfo> list = new ArrayList<BindableFieldInfo>();
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            TypeElement fieldClass = (TypeElement)this.types.asElement(field.asType());
            if (fieldClass == null || fieldClass.getAnnotation(Bindable.class) == null || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            list.add(new BindableFieldInfo(field, fieldClass, this.getDescriptorClassName(fieldClass)));
        }
        return list;
    }

    private boolean shouldGenerateClassSetter(VariableElement f) {
        TypeMirror asType = f.asType();
        TypeKind kind = asType.getKind();
        if (kind.isPrimitive() || kind != TypeKind.DECLARED) {
            return false;
        }
        List<? extends TypeMirror> directSupertypes = this.types.directSupertypes(asType);
        if (!directSupertypes.isEmpty() && this.types.erasure(directSupertypes.get(0)).toString().equals("java.lang.Enum")) {
            return false;
        }
        String rawType = this.types.erasure(f.asType()).toString();
        return !rawType.startsWith("java.lang.") && !rawType.startsWith("java.util.");
    }

    private void closeQuietly(Closeable os) {
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void extractTitleDescription(CommonMetadata metadata, String javaDoc) {
        String description;
        if (javaDoc == null || javaDoc.trim().isEmpty()) {
            return;
        }
        String comment = MetadataExtractorUtils.toPlainText(javaDoc);
        if (comment == null) {
            return;
        }
        int next = MetadataExtractorUtils.getEndOfFirstSentenceCharIndex(comment);
        if (next > 0 && next < comment.length() && (description = comment.substring(next + 1).trim()).length() > 0) {
            metadata.setDescription(description);
        }
        if (next >= 0) {
            String firstSentence = comment.substring(0, next).trim();
            if (firstSentence.length() > 0) {
                metadata.setTitle(firstSentence);
            }
        } else {
            metadata.setTitle(comment);
        }
    }

    private String processJavaDoc(Element e, final Map<String, String> tags) {
        final StringBuilder javaDocText = new StringBuilder();
        String javaDoc = this.elements.getDocComment(e);
        if (javaDoc == null || javaDoc.trim().length() == 0) {
            return null;
        }
        JFlexLexer lexer = new JFlexLexer(new StringReader("/** " + javaDoc + " */"));
        BuilderBase builder = new BuilderBase(){

            @Override
            public void addJavaDoc(String arg0) {
                javaDocText.append(arg0);
            }

            @Override
            public void addJavaDocTag(TagDef tag) {
                tags.put(tag.name, tag.text);
            }
        };
        Parser parser = new Parser(lexer, builder);
        try {
            parser.parse();
        }
        catch (ParseException x) {
            throw new RuntimeException("Could not parse JavaDoc of: " + e.toString(), x);
        }
        String processed = javaDocText.toString();
        Pattern typeRefs = Pattern.compile("\\{\\@link\\s+\\#", 34);
        processed = typeRefs.matcher(processed).replaceAll("{@link " + this.typeOf(e).getQualifiedName() + "#");
        return processed.toString();
    }

    private TypeElement typeOf(Element e) {
        switch (e.getKind()) {
            case CLASS: 
            case ENUM: {
                return (TypeElement)e;
            }
            case METHOD: 
            case FIELD: {
                return (TypeElement)e.getEnclosingElement();
            }
        }
        throw new RuntimeException("Unexpected type: " + e);
    }
}

