/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection;

import java.util.Iterator;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.RuntimeServices;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.RuntimeServicesAware;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.Info;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.SecureIntrospectorControl;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.SecureIntrospectorImpl;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.UberspectImpl;

public class SecureUberspector
extends UberspectImpl
implements RuntimeServicesAware {
    RuntimeServices runtimeServices;

    public void init() {
        String[] badPackages = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.packages");
        String[] badClasses = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.classes");
        this.introspector = new SecureIntrospectorImpl(badClasses, badPackages, this.log);
    }

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj != null) {
            SecureIntrospectorControl sic = (SecureIntrospectorControl)((Object)this.introspector);
            if (sic.checkObjectExecutePermission(obj.getClass(), null)) {
                return super.getIterator(obj, i);
            }
            this.log.warn("Cannot retrieve iterator from " + obj.getClass() + " due to security restrictions.");
        }
        return null;
    }

    public void setRuntimeServices(RuntimeServices rs) {
        this.runtimeServices = rs;
    }
}

