/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.qdox.qdox.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.carrot2.util.preprocessor.shaded.apache.tools.ant.BuildException;
import org.carrot2.util.preprocessor.shaded.apache.tools.ant.DirectoryScanner;
import org.carrot2.util.preprocessor.shaded.apache.tools.ant.Task;
import org.carrot2.util.preprocessor.shaded.apache.tools.ant.types.FileSet;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.JavaDocBuilder;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.model.DefaultDocletTagFactory;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.model.DocletTagFactory;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.model.JavaClass;
import org.carrot2.util.preprocessor.shaded.qdox.qdox.model.JavaSource;

public abstract class AbstractQdoxTask
extends Task {
    private Vector filesets = new Vector();
    protected HashMap fileMap = new HashMap();
    protected ArrayList allSources = new ArrayList();
    protected ArrayList allClasses = new ArrayList();

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void buildFileMap() {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            this.buildFileMap(fs.getDir(this.getProject()), srcFiles);
        }
    }

    protected void buildFileMap(File directory, String[] sourceFiles) {
        for (int i = 0; i < sourceFiles.length; ++i) {
            File src = new File(directory, sourceFiles[i]);
            this.fileMap.put(src.getAbsolutePath(), src);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.buildFileMap();
        JavaDocBuilder builder = new JavaDocBuilder(this.createDocletTagFactory());
        builder.getClassLibrary().addClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.mergeBuilderSources(builder);
        JavaSource[] sources = builder.getSources();
        this.processSources(sources);
    }

    protected DocletTagFactory createDocletTagFactory() {
        return new DefaultDocletTagFactory();
    }

    private void mergeBuilderSources(JavaDocBuilder builder) {
        Iterator iterator = this.fileMap.keySet().iterator();
        while (iterator.hasNext()) {
            String sourceFile = (String)iterator.next();
            builder.addSourceTree((File)this.fileMap.get(sourceFile));
        }
    }

    protected void processSources(JavaSource[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            JavaSource source = sources[i];
            this.allSources.add(source);
            JavaClass[] classes = source.getClasses();
            this.processClasses(classes);
        }
    }

    protected void processClasses(JavaClass[] classes) {
        for (int j = 0; j < classes.length; ++j) {
            JavaClass clazz = classes[j];
            this.allClasses.add(clazz);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source fileset.");
        }
    }
}

