/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MetadataExtractorUtils {
    private static final Pattern FIRST_SENTENCE_PATTERN = Pattern.compile("\\.(?<!((\\w\\.){2,5}+))(\\s|\\z)");
    private static final Pattern LINK_TO_TEXT_PATTERN = Pattern.compile("\\{@link\\s(.+?)\\}");
    private static final Pattern SPACE_HASH_PATTERN = Pattern.compile(">#");
    private static final Pattern TYPE_HASH_PATTERN = Pattern.compile("([^>&])#");

    private MetadataExtractorUtils() {
    }

    static int getEndOfFirstSentenceCharIndex(String text) {
        Matcher matcher = FIRST_SENTENCE_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    static String normalizeSpaces(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[\\s]+", " ");
    }

    static String renderInlineTags(String comment) {
        String content = comment;
        content = LINK_TO_TEXT_PATTERN.matcher(comment).replaceAll("<code>$1</code>");
        content = SPACE_HASH_PATTERN.matcher(content).replaceAll(">");
        content = TYPE_HASH_PATTERN.matcher(content).replaceAll("$1.");
        return content;
    }

    static String toPlainText(String comment) {
        if (comment == null) {
            return null;
        }
        String normalizedSpace = MetadataExtractorUtils.normalizeSpaces(comment);
        String linksRendered = MetadataExtractorUtils.renderInlineTags(normalizedSpace);
        String trimmed = linksRendered.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        return trimmed;
    }
}

