/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.carrot2.util.preprocessor.shaded.apache.velocity.VelocityContext;
import org.carrot2.util.preprocessor.shaded.apache.velocity.context.Context;
import org.carrot2.util.preprocessor.shaded.apache.velocity.context.InternalContextAdapterImpl;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.MethodInvocationException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ParseErrorException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ResourceNotFoundException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.TemplateInitException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.VelocityException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.directive.Scope;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.directive.StopCommand;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.ParseException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.node.SimpleNode;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.Resource;

public class Template
extends Resource {
    private String scopeName = "template";
    private boolean provideScope = false;
    private Map<String, Object> macros = new ConcurrentHashMap<String, Object>(17, 0.7f);
    private VelocityException errorCondition = null;

    public Template() {
        this.setType(1);
    }

    public Map<String, Object> getMacros() {
        return this.macros;
    }

    @Override
    public boolean process() throws ResourceNotFoundException, ParseErrorException {
        this.data = null;
        Reader reader = null;
        this.errorCondition = null;
        try {
            reader = this.resourceLoader.getResourceReader(this.name, this.getEncoding());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.errorCondition = resourceNotFoundException;
            throw resourceNotFoundException;
        }
        if (reader != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(reader);
                this.data = this.rsvc.parse(bufferedReader, this);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (ParseException parseException) {
                this.errorCondition = new ParseErrorException(parseException, this.name);
                throw this.errorCondition;
            }
            catch (TemplateInitException templateInitException) {
                this.errorCondition = new ParseErrorException(templateInitException, this.name);
                throw this.errorCondition;
            }
            catch (RuntimeException runtimeException) {
                this.errorCondition = new VelocityException("Exception thrown processing Template " + this.getName(), runtimeException);
                throw this.errorCondition;
            }
            finally {
                block14: {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        if (this.errorCondition != null) break block14;
                        throw new VelocityException(iOException);
                    }
                }
            }
        }
        this.errorCondition = new ResourceNotFoundException("Unknown resource error for resource " + this.name);
        throw this.errorCondition;
    }

    public void initDocument() throws TemplateInitException {
        InternalContextAdapterImpl internalContextAdapterImpl = new InternalContextAdapterImpl(new VelocityContext());
        try {
            internalContextAdapterImpl.pushCurrentTemplateName(this.name);
            internalContextAdapterImpl.setCurrentResource(this);
            ((SimpleNode)this.data).init(internalContextAdapterImpl, this.rsvc);
            String string = this.scopeName + '.' + "provide.scope.control";
            this.provideScope = this.rsvc.getBoolean(string, this.provideScope);
        }
        finally {
            internalContextAdapterImpl.popCurrentTemplateName();
            internalContextAdapterImpl.setCurrentResource(null);
        }
    }

    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.merge(context, writer, null);
    }

    public void merge(Context context, Writer writer, List list) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        if (this.errorCondition != null) {
            throw this.errorCondition;
        }
        if (this.data != null) {
            Object object2;
            InternalContextAdapterImpl internalContextAdapterImpl = new InternalContextAdapterImpl(context);
            ArrayList<Template> arrayList = new ArrayList<Template>();
            internalContextAdapterImpl.setMacroLibraries(arrayList);
            if (list != null) {
                for (Object object2 : list) {
                    try {
                        Template template = this.rsvc.getTemplate((String)object2);
                        arrayList.add(template);
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        this.log.error("cannot find template {}", object2);
                        throw resourceNotFoundException;
                    }
                    catch (ParseErrorException parseErrorException) {
                        this.rsvc.getLog("parser").error("syntax error in template {}: {}", new Object[]{object2, parseErrorException.getMessage(), parseErrorException});
                        throw parseErrorException;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("parse failed in template  " + (String)object2 + ".", exception);
                    }
                }
            }
            if (this.provideScope) {
                internalContextAdapterImpl.put(this.scopeName, new Scope(this, internalContextAdapterImpl.get(this.scopeName)));
            }
            try {
                internalContextAdapterImpl.pushCurrentTemplateName(this.name);
                internalContextAdapterImpl.setCurrentResource(this);
                ((SimpleNode)this.data).render(internalContextAdapterImpl, writer);
            }
            catch (StopCommand stopCommand) {
                if (!stopCommand.isFor(this)) {
                    throw stopCommand;
                }
                object2 = this.rsvc.getLog("rendering");
                object2.debug(stopCommand.getMessage());
            }
            catch (IOException iOException) {
                throw new VelocityException("IO Error rendering template '" + this.name + "'", iOException);
            }
            finally {
                Object object3;
                internalContextAdapterImpl.popCurrentTemplateName();
                internalContextAdapterImpl.setCurrentResource(null);
                if (this.provideScope && (object3 = internalContextAdapterImpl.get(this.scopeName)) instanceof Scope) {
                    object2 = (Scope)object3;
                    if (((Scope)object2).getParent() != null) {
                        internalContextAdapterImpl.put(this.scopeName, ((Scope)object2).getParent());
                    } else if (((Scope)object2).getReplaced() != null) {
                        internalContextAdapterImpl.put(this.scopeName, ((Scope)object2).getReplaced());
                    } else {
                        internalContextAdapterImpl.remove(this.scopeName);
                    }
                }
            }
        } else {
            String string = "Template merging failed. The document is null, most likely due to a parsing error.";
            throw new RuntimeException(string);
        }
    }
}

