/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream
extends InputStream {
    public static final UnicodeBOM UTF8_BOM = new UnicodeBOM("UTF-8", new byte[]{-17, -69, -65});
    public static final UnicodeBOM UTF16LE_BOM = new UnicodeBOM("UTF-16LE", new byte[]{-1, -2});
    public static final UnicodeBOM UTF16BE_BOM = new UnicodeBOM("UTF-16BE", new byte[]{-2, -1});
    public static final UnicodeBOM UTF32LE_BOM = new UnicodeBOM("UTF-32LE", new byte[]{-1, -2, 0, 0});
    public static final UnicodeBOM UTF32BE_BOM = new UnicodeBOM("UTF-32BE", new byte[]{0, 0, -2, -1});
    private static final int MAX_BOM_SIZE = 4;
    private byte[] buf = new byte[4];
    private int pos = 0;
    private final String encoding;
    private final boolean skipBOM;
    private final PushbackInputStream inputStream;

    public UnicodeInputStream(InputStream inputStream) throws IllegalStateException, IOException {
        this(inputStream, true);
    }

    public UnicodeInputStream(InputStream inputStream, boolean bl) throws IllegalStateException, IOException {
        this.skipBOM = bl;
        this.inputStream = new PushbackInputStream(inputStream, 4);
        try {
            this.encoding = this.readEncoding();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read BOM from Stream", iOException);
        }
    }

    public boolean isSkipBOM() {
        return this.skipBOM;
    }

    public String getEncodingFromStream() {
        return this.encoding;
    }

    protected String readEncoding() throws IOException {
        this.pos = 0;
        UnicodeBOM unicodeBOM = null;
        if (this.readByte()) {
            switch (this.buf[0]) {
                case 0: {
                    unicodeBOM = this.match(UTF32BE_BOM, null);
                    break;
                }
                case -17: {
                    unicodeBOM = this.match(UTF8_BOM, null);
                    break;
                }
                case -2: {
                    unicodeBOM = this.match(UTF16BE_BOM, null);
                    break;
                }
                case -1: {
                    unicodeBOM = this.match(UTF16LE_BOM, null);
                    if (unicodeBOM == null) break;
                    unicodeBOM = this.match(UTF32LE_BOM, unicodeBOM);
                    break;
                }
                default: {
                    unicodeBOM = null;
                }
            }
        }
        this.pushback(unicodeBOM);
        return unicodeBOM != null ? unicodeBOM.getEncoding() : null;
    }

    private UnicodeBOM match(UnicodeBOM unicodeBOM, UnicodeBOM unicodeBOM2) throws IOException {
        byte[] byArray = unicodeBOM.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            if (this.pos <= i && !this.readByte()) {
                return unicodeBOM2;
            }
            if (byArray[i] == this.buf[i]) continue;
            return unicodeBOM2;
        }
        return unicodeBOM;
    }

    private boolean readByte() throws IOException {
        int n = this.inputStream.read();
        if (n == -1) {
            return false;
        }
        if (this.pos >= this.buf.length) {
            throw new IOException("BOM read error");
        }
        this.buf[this.pos++] = (byte)n;
        return true;
    }

    private void pushback(UnicodeBOM unicodeBOM) throws IOException {
        int n = this.pos;
        int n2 = 0;
        if (unicodeBOM != null && this.skipBOM && (n = this.pos - (n2 = unicodeBOM.getBytes().length)) < 0) {
            throw new IllegalStateException("Match has more bytes than available!");
        }
        this.inputStream.unread(this.buf, n2, n);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void mark(int n) {
        this.inputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.inputStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.inputStream.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.inputStream.skip(l);
    }

    public static boolean sameEncoding(String string, String string2) {
        string = string.toUpperCase().replace("-", "").replace("_", "");
        string2 = string2.toUpperCase().replace("-", "").replace("_", "");
        return string.equals(string2);
    }

    static final class UnicodeBOM {
        private final String encoding;
        private final byte[] bytes;

        private UnicodeBOM(String string, byte[] byArray) {
            this.encoding = string;
            this.bytes = byArray;
        }

        String getEncoding() {
            return this.encoding;
        }

        byte[] getBytes() {
            return this.bytes;
        }
    }
}

