/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.node;

import org.carrot2.util.preprocessor.shaded.apache.velocity.context.InternalContextAdapter;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.MathException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.Parser;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.node.ASTMathNode;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.node.MathUtils;

public class ASTDivNode
extends ASTMathNode {
    public ASTDivNode(int n) {
        super(n);
    }

    public ASTDivNode(Parser parser, int n) {
        super(parser, n);
    }

    @Override
    public String getLiteralOperator() {
        return "/";
    }

    @Override
    public Number perform(Number number, Number number2, InternalContextAdapter internalContextAdapter) {
        if (MathUtils.isZero(number2)) {
            String string = "Right side of division operation is zero. Must be non-zero. " + this.getLocation(internalContextAdapter);
            if (this.strictMode) {
                this.log.error(string);
                throw new MathException(string);
            }
            this.log.debug(string);
            return null;
        }
        return MathUtils.divide(number, number2);
    }
}

