/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MathUtils {
    protected static final BigDecimal DECIMAL_ZERO = new BigDecimal(BigInteger.ZERO);
    protected static final int BASE_LONG = 0;
    protected static final int BASE_FLOAT = 1;
    protected static final int BASE_DOUBLE = 2;
    protected static final int BASE_BIGINTEGER = 3;
    protected static final int BASE_BIGDECIMAL = 4;
    private static final Map ints = new HashMap();
    private static final List typesBySize;

    public static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.doubleValue());
    }

    public static BigInteger toBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public static boolean isZero(Number number) {
        if (MathUtils.isInteger(number)) {
            if (number instanceof BigInteger) {
                return ((BigInteger)number).compareTo(BigInteger.ZERO) == 0;
            }
            return number.doubleValue() == 0.0;
        }
        if (number instanceof Float) {
            return number.floatValue() == 0.0f;
        }
        if (number instanceof Double) {
            return number.doubleValue() == 0.0;
        }
        return MathUtils.toBigDecimal(number).compareTo(DECIMAL_ZERO) == 0;
    }

    public static boolean isInteger(Number number) {
        return ints.containsKey(number.getClass());
    }

    public static Number wrapPrimitive(long l, Class clazz) {
        if (clazz == Byte.class) {
            if (l > 127L || l < -128L) {
                clazz = Short.class;
            } else {
                return (byte)l;
            }
        }
        if (clazz == Short.class) {
            if (l > 32767L || l < -32768L) {
                clazz = Integer.class;
            } else {
                return (short)l;
            }
        }
        if (clazz == Integer.class) {
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                clazz = Long.class;
            } else {
                return (int)l;
            }
        }
        if (clazz == Long.class) {
            return l;
        }
        return BigInteger.valueOf(l);
    }

    private static Number wrapPrimitive(long l, Number number, Number number2) {
        if (typesBySize.indexOf(number.getClass()) > typesBySize.indexOf(number2.getClass())) {
            return MathUtils.wrapPrimitive(l, number.getClass());
        }
        return MathUtils.wrapPrimitive(l, number2.getClass());
    }

    private static int findCalculationBase(Number number, Number number2) {
        boolean bl = MathUtils.isInteger(number);
        boolean bl2 = MathUtils.isInteger(number2);
        if (number instanceof BigDecimal || number2 instanceof BigDecimal || (!bl || !bl2) && (number instanceof BigInteger || number2 instanceof BigInteger)) {
            return 4;
        }
        if (bl && bl2) {
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                return 3;
            }
            return 0;
        }
        if (number instanceof Double || number2 instanceof Double) {
            return 2;
        }
        return 1;
    }

    public static int findCalculationBase(Number number) {
        if (MathUtils.isInteger(number)) {
            if (number instanceof BigInteger) {
                return 3;
            }
            return 0;
        }
        if (number instanceof BigDecimal) {
            return 4;
        }
        if (number instanceof Double) {
            return 2;
        }
        return 1;
    }

    public static Number add(Number number, Number number2) {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).add(MathUtils.toBigInteger(number2));
            }
            case 0: {
                long l = number.longValue();
                long l2 = number2.longValue();
                long l3 = l + l2;
                if ((l3 ^ l) < 0L && (l3 ^ l2) < 0L) {
                    return MathUtils.toBigInteger(number).add(MathUtils.toBigInteger(number2));
                }
                return MathUtils.wrapPrimitive(l3, number, number2);
            }
            case 1: {
                return Float.valueOf(number.floatValue() + number2.floatValue());
            }
            case 2: {
                return number.doubleValue() + number2.doubleValue();
            }
        }
        return MathUtils.toBigDecimal(number).add(MathUtils.toBigDecimal(number2));
    }

    public static Number subtract(Number number, Number number2) {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).subtract(MathUtils.toBigInteger(number2));
            }
            case 0: {
                long l = number.longValue();
                long l2 = number2.longValue();
                long l3 = l - l2;
                if ((l3 ^ l) < 0L && (l3 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
                    return MathUtils.toBigInteger(number).subtract(MathUtils.toBigInteger(number2));
                }
                return MathUtils.wrapPrimitive(l3, number, number2);
            }
            case 1: {
                return Float.valueOf(number.floatValue() - number2.floatValue());
            }
            case 2: {
                return number.doubleValue() - number2.doubleValue();
            }
        }
        return MathUtils.toBigDecimal(number).subtract(MathUtils.toBigDecimal(number2));
    }

    public static Number multiply(Number number, Number number2) {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).multiply(MathUtils.toBigInteger(number2));
            }
            case 0: {
                long l = number.longValue();
                long l2 = number2.longValue();
                long l3 = l * l2;
                if (l2 != 0L && l3 / l2 != l) {
                    return MathUtils.toBigInteger(number).multiply(MathUtils.toBigInteger(number2));
                }
                return MathUtils.wrapPrimitive(l3, number, number2);
            }
            case 1: {
                return Float.valueOf(number.floatValue() * number2.floatValue());
            }
            case 2: {
                return number.doubleValue() * number2.doubleValue();
            }
        }
        return MathUtils.toBigDecimal(number).multiply(MathUtils.toBigDecimal(number2));
    }

    public static Number divide(Number number, Number number2) {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                BigInteger bigInteger = MathUtils.toBigInteger(number);
                BigInteger bigInteger2 = MathUtils.toBigInteger(number2);
                return bigInteger.divide(bigInteger2);
            }
            case 0: {
                long l = number.longValue();
                long l2 = number2.longValue();
                return MathUtils.wrapPrimitive(l / l2, number, number2);
            }
            case 1: {
                return Float.valueOf(number.floatValue() / number2.floatValue());
            }
            case 2: {
                return number.doubleValue() / number2.doubleValue();
            }
        }
        return MathUtils.toBigDecimal(number).divide(MathUtils.toBigDecimal(number2), 5);
    }

    public static Number modulo(Number number, Number number2) throws ArithmeticException {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).mod(MathUtils.toBigInteger(number2));
            }
            case 0: {
                return MathUtils.wrapPrimitive(number.longValue() % number2.longValue(), number, number2);
            }
            case 1: {
                return Float.valueOf(number.floatValue() % number2.floatValue());
            }
            case 2: {
                return number.doubleValue() % number2.doubleValue();
            }
        }
        throw new ArithmeticException("Cannot calculate the modulo of BigDecimals.");
    }

    public static int compare(Number number, Number number2) {
        int n = MathUtils.findCalculationBase(number, number2);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).compareTo(MathUtils.toBigInteger(number2));
            }
            case 0: {
                long l = number.longValue();
                long l2 = number2.longValue();
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                float f = number.floatValue();
                float f2 = number2.floatValue();
                if (f < f2) {
                    return -1;
                }
                if (f > f2) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                double d = number.doubleValue();
                double d2 = number2.doubleValue();
                if (d < d2) {
                    return -1;
                }
                if (d > d2) {
                    return 1;
                }
                return 0;
            }
        }
        return MathUtils.toBigDecimal(number).compareTo(MathUtils.toBigDecimal(number2));
    }

    public static Number negate(Number number) {
        int n = MathUtils.findCalculationBase(number);
        switch (n) {
            case 3: {
                return MathUtils.toBigInteger(number).negate();
            }
            case 0: {
                long l = number.longValue();
                if (l == Long.MIN_VALUE) {
                    return MathUtils.toBigInteger(l).negate();
                }
                return MathUtils.wrapPrimitive(-l, number.getClass());
            }
            case 1: {
                float f = number.floatValue();
                return Float.valueOf(-f);
            }
            case 2: {
                double d = number.doubleValue();
                return -d;
            }
        }
        return MathUtils.toBigDecimal(number).negate();
    }

    static {
        ints.put(Byte.class, BigDecimal.valueOf(127L));
        ints.put(Short.class, BigDecimal.valueOf(32767L));
        ints.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        ints.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        ints.put(BigInteger.class, BigDecimal.valueOf(-1L));
        typesBySize = new ArrayList();
        typesBySize.add(Byte.class);
        typesBySize.add(Short.class);
        typesBySize.add(Integer.class);
        typesBySize.add(Long.class);
        typesBySize.add(Float.class);
        typesBySize.add(Double.class);
    }
}

