/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.carrot2.util.preprocessor.shaded.apache.commons.lang3.StringUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ResourceNotFoundException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.VelocityException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.Resource;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader.JarHolder;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.carrot2.util.preprocessor.shaded.apache.velocity.shaded.commons.io.FilenameUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.ExtProperties;

public class JarResourceLoader
extends ResourceLoader {
    private Map entryDirectory = new HashMap(559);
    private Map jarfiles = new HashMap(89);

    @Override
    public void init(ExtProperties extProperties) {
        this.log.trace("JarResourceLoader: initialization starting.");
        List list = extProperties.getList("path");
        if (list != null) {
            this.log.debug("JarResourceLoader # of paths: {}", (Object)list.size());
            ListIterator<String> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = StringUtils.trim((String)listIterator.next());
                listIterator.set(string);
                this.loadJar(string);
            }
        }
        this.log.trace("JarResourceLoader: initialization complete.");
    }

    private void loadJar(String string) {
        this.log.debug("JarResourceLoader: trying to load \"{}\"", (Object)string);
        if (string == null) {
            String string2 = "JarResourceLoader: can not load JAR - JAR path is null";
            this.log.error(string2);
            throw new RuntimeException(string2);
        }
        if (!string.startsWith("jar:")) {
            String string3 = "JarResourceLoader: JAR path must start with jar: -> see java.net.JarURLConnection for information";
            this.log.error(string3);
            throw new RuntimeException(string3);
        }
        if (!string.contains("!/")) {
            string = string + "!/";
        }
        this.closeJar(string);
        JarHolder jarHolder = new JarHolder(this.rsvc, string, this.log);
        this.addEntries(jarHolder.getEntries());
        this.jarfiles.put(jarHolder.getUrlPath(), jarHolder);
    }

    private void closeJar(String string) {
        if (this.jarfiles.containsKey(string)) {
            JarHolder jarHolder = (JarHolder)this.jarfiles.get(string);
            jarHolder.close();
        }
    }

    private void addEntries(Hashtable hashtable) {
        this.entryDirectory.putAll(hashtable);
    }

    @Override
    public Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        String string3;
        Object var3_3 = null;
        if (StringUtils.isEmpty(string)) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        String string4 = FilenameUtils.normalize(string, true);
        if (string4 == null || string4.length() == 0) {
            String string5 = "JAR resource error: argument " + string4 + " contains .. and may be trying to access content outside of template root.  Rejected.";
            this.log.error("JarResourceLoader: {}", (Object)string5);
            throw new ResourceNotFoundException(string5);
        }
        if (string4.startsWith("/")) {
            string4 = string4.substring(1);
        }
        if (this.entryDirectory.containsKey(string4) && this.jarfiles.containsKey(string3 = (String)this.entryDirectory.get(string4))) {
            JarHolder jarHolder = (JarHolder)this.jarfiles.get(string3);
            InputStream inputStream = jarHolder.getResource(string4);
            try {
                return this.buildReader(inputStream, string2);
            }
            catch (Exception exception) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String string6 = "JAR resource error: Exception while loading " + string;
                this.log.error(string6, (Throwable)exception);
                throw new VelocityException(string6, exception);
            }
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + string);
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return true;
    }

    @Override
    public long getLastModified(Resource resource) {
        return 0L;
    }
}

