/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor;

import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.util.Types;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.preprocessor.VariableElementAccessWrapper;

public class AttributeFieldInfo {
    private final Types types;
    private final String key;
    private final AttributeMetadata metadata;
    private final String javaDoc;
    private final VariableElement field;
    private final String declaringClass;
    private final String descriptorClass;
    private final AttributeFieldInfo inherited;
    private final boolean generatesClassSetter;

    AttributeFieldInfo(String attributeKey, AttributeMetadata metadata, String javaDoc, VariableElement field, Types types, String declaringClass, String descriptorClass, AttributeFieldInfo inherited, boolean generateClassSetter) {
        this.types = types;
        this.key = attributeKey;
        this.metadata = metadata;
        this.javaDoc = javaDoc;
        this.field = field;
        this.declaringClass = declaringClass;
        this.descriptorClass = descriptorClass;
        this.inherited = inherited;
        this.generatesClassSetter = generateClassSetter;
    }

    public String getKey() {
        return this.key;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public VariableElementAccessWrapper getField() {
        return new VariableElementAccessWrapper(this.field);
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDescriptorClass() {
        return this.descriptorClass;
    }

    public String getLabel() {
        return this.metadata.getLabel();
    }

    public String getDescription() {
        return this.metadata.getDescription();
    }

    public String getTitle() {
        return this.metadata.getTitle();
    }

    public String getGroup() {
        return this.metadata.getGroup();
    }

    public AttributeLevel getLevel() {
        return this.metadata.getLevel();
    }

    public AttributeFieldInfo getInherited() {
        return this.inherited;
    }

    public boolean isGeneratesClassSetter() {
        return this.generatesClassSetter && this.isInput();
    }

    public boolean isInput() {
        return this.field.getAnnotation(Input.class) != null;
    }

    public boolean isOutput() {
        return this.field.getAnnotation(Output.class) != null;
    }

    public String getType() {
        return this.field.asType().toString();
    }

    public boolean hasGenericSignature() {
        String signature = this.field.asType().toString();
        if (signature.equals("java.lang.Class<?>")) {
            return false;
        }
        return !signature.equals(this.types.erasure(this.field.asType()).toString());
    }

    public String getBoxedType() {
        if (this.field.asType().getKind().isPrimitive()) {
            return this.types.boxedClass((PrimitiveType)this.field.asType()).toString();
        }
        return this.getType();
    }
}

