/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.exception;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ExtendedParseException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.VelocityException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.parser.ParseException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.StringUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.Info;

public class ParseErrorException
extends VelocityException {
    private static final long serialVersionUID = -6665197935086306472L;
    private int columnNumber = -1;
    private int lineNumber = -1;
    private String templateName = "*unset*";
    private String invalidSyntax;
    private String msg = null;
    private static final Pattern lexError = Pattern.compile("Lexical error.*TokenMgrError.*line (\\d+),.*column (\\d+)\\.(.*)");

    public ParseErrorException(String string) {
        super(string);
    }

    public ParseErrorException(ParseException parseException, String string) {
        super(parseException.getMessage());
        if (string != null) {
            this.templateName = string;
        }
        if (parseException instanceof ExtendedParseException) {
            ExtendedParseException extendedParseException = (ExtendedParseException)((Object)parseException);
            this.columnNumber = extendedParseException.getColumnNumber();
            this.lineNumber = extendedParseException.getLineNumber();
            this.templateName = extendedParseException.getTemplateName();
        } else {
            Matcher matcher = lexError.matcher(parseException.getMessage());
            if (matcher.matches()) {
                this.lineNumber = Integer.parseInt(matcher.group(1));
                this.columnNumber = Integer.parseInt(matcher.group(2));
                String string2 = matcher.group(3);
                this.msg = "Lexical error, " + string2 + " at " + StringUtils.formatFileString(this.templateName, this.lineNumber, this.columnNumber);
            }
            if (parseException.currentToken != null && parseException.currentToken.next != null) {
                this.columnNumber = parseException.currentToken.next.beginColumn;
                this.lineNumber = parseException.currentToken.next.beginLine;
            }
        }
    }

    public ParseErrorException(VelocityException velocityException, String string) {
        super(velocityException.getMessage());
        if (string != null) {
            this.templateName = string;
        }
        if (velocityException instanceof ExtendedParseException) {
            ExtendedParseException extendedParseException = (ExtendedParseException)((Object)velocityException);
            this.columnNumber = extendedParseException.getColumnNumber();
            this.lineNumber = extendedParseException.getLineNumber();
            this.templateName = extendedParseException.getTemplateName();
        } else if (velocityException.getCause() instanceof ParseException) {
            ParseException parseException = (ParseException)velocityException.getCause();
            if (parseException.currentToken != null && parseException.currentToken.next != null) {
                this.columnNumber = parseException.currentToken.next.beginColumn;
                this.lineNumber = parseException.currentToken.next.beginLine;
            }
        }
    }

    public ParseErrorException(String string, Info info) {
        super(string);
        this.columnNumber = info.getColumn();
        this.lineNumber = info.getLine();
        this.templateName = info.getTemplateName();
    }

    public ParseErrorException(String string, Info info, String string2) {
        super(string);
        this.columnNumber = info.getColumn();
        this.lineNumber = info.getLine();
        this.templateName = info.getTemplateName();
        this.invalidSyntax = string2;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getInvalidSyntax() {
        return this.invalidSyntax;
    }

    @Override
    public String getMessage() {
        if (this.msg != null) {
            return this.msg;
        }
        return super.getMessage();
    }
}

