/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.RuntimeServices;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.Resource;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.ResourceCache;
import org.slf4j.Logger;

public class ResourceCacheImpl
implements ResourceCache {
    protected Map<Object, Resource> cache = new ConcurrentHashMap<Object, Resource>(512, 0.5f, 30);
    protected RuntimeServices rsvc = null;
    protected Logger log;

    @Override
    public void initialize(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
        int n = this.rsvc.getInt("resource.manager.defaultcache.size", 89);
        if (n > 0) {
            Map<Object, Resource> map = Collections.synchronizedMap(new LRUMap(n));
            map.putAll(this.cache);
            this.cache = map;
        }
        this.rsvc.getLog().debug("initialized ({}) with {} cache map.", this.getClass(), this.cache.getClass());
    }

    @Override
    public Resource get(Object object) {
        return this.cache.get(object);
    }

    @Override
    public Resource put(Object object, Resource resource) {
        return this.cache.put(object, resource);
    }

    @Override
    public Resource remove(Object object) {
        return this.cache.remove(object);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Iterator<Object> enumerateKeys() {
        return this.cache.keySet().iterator();
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 5889225121697975043L;
        private int cacheSize;

        public LRUMap(int n) {
            this.cacheSize = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.cacheSize;
        }
    }
}

