/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.util.preprocessor.shaded.apache.commons.lang3.StringUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ResourceNotFoundException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.VelocityException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.Resource;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.util.StringResource;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.util.StringResourceRepositoryImpl;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.ClassUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.ExtProperties;

public class StringResourceLoader
extends ResourceLoader {
    public static final String REPOSITORY_STATIC = "repository.static";
    public static final boolean REPOSITORY_STATIC_DEFAULT = true;
    public static final String REPOSITORY_CLASS = "repository.class";
    public static final String REPOSITORY_CLASS_DEFAULT = StringResourceRepositoryImpl.class.getName();
    public static final String REPOSITORY_NAME = "repository.name";
    public static final String REPOSITORY_NAME_DEFAULT = StringResourceRepository.class.getName();
    public static final String REPOSITORY_ENCODING = "repository.encoding";
    protected static final Map STATIC_REPOSITORIES = Collections.synchronizedMap(new HashMap());
    protected StringResourceRepository repository;

    public static StringResourceRepository getRepository() {
        return StringResourceLoader.getRepository(REPOSITORY_NAME_DEFAULT);
    }

    public static StringResourceRepository getRepository(String string) {
        return (StringResourceRepository)STATIC_REPOSITORIES.get(string);
    }

    public static void setRepository(String string, StringResourceRepository stringResourceRepository) {
        STATIC_REPOSITORIES.put(string, stringResourceRepository);
    }

    public static StringResourceRepository removeRepository(String string) {
        return (StringResourceRepository)STATIC_REPOSITORIES.remove(string);
    }

    public static void clearRepositories() {
        STATIC_REPOSITORIES.clear();
    }

    @Override
    public void init(ExtProperties extProperties) {
        this.log.trace("StringResourceLoader: initialization starting.");
        String string = extProperties.getString(REPOSITORY_CLASS, REPOSITORY_CLASS_DEFAULT);
        String string2 = extProperties.getString(REPOSITORY_NAME, REPOSITORY_NAME_DEFAULT);
        boolean bl = extProperties.getBoolean(REPOSITORY_STATIC, true);
        String string3 = extProperties.getString(REPOSITORY_ENCODING);
        if (bl) {
            this.repository = StringResourceLoader.getRepository(string2);
            if (this.repository != null) {
                this.log.debug("Loaded repository '{}' from static repo store", (Object)string2);
            }
        } else {
            this.repository = (StringResourceRepository)this.rsvc.getApplicationAttribute(string2);
            if (this.repository != null) {
                this.log.debug("Loaded repository '{}' from application attributes", (Object)string2);
            }
        }
        if (this.repository == null) {
            this.repository = this.createRepository(string, string3);
            if (bl) {
                StringResourceLoader.setRepository(string2, this.repository);
            } else {
                this.rsvc.setApplicationAttribute(string2, this.repository);
            }
        } else {
            if (!this.repository.getClass().getName().equals(string)) {
                this.log.debug("Cannot change class of string repository '{}' from {} to {}. The change will be ignored.", new Object[]{string2, this.repository.getClass().getName(), string});
            }
            if (string3 != null && !this.repository.getEncoding().equals(string3)) {
                this.log.debug("Changing the default encoding of string repository '{}' from {} to {}", new Object[]{string2, this.repository.getEncoding(), string3});
                this.repository.setEncoding(string3);
            }
        }
        this.log.trace("StringResourceLoader: initialization complete.");
    }

    public StringResourceRepository createRepository(String string, String string2) {
        StringResourceRepository stringResourceRepository;
        this.log.debug("Creating string repository using class {}...", (Object)string);
        try {
            stringResourceRepository = (StringResourceRepository)ClassUtils.getNewInstance(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VelocityException("Could not find '" + string + "'", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VelocityException("Could not access '" + string + "'", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new VelocityException("Could not instantiate '" + string + "'", instantiationException);
        }
        if (string2 != null) {
            stringResourceRepository.setEncoding(string2);
        } else {
            stringResourceRepository.setEncoding("UTF-8");
        }
        this.log.debug("Default repository encoding is {}", (Object)stringResourceRepository.getEncoding());
        return stringResourceRepository;
    }

    @Override
    public boolean resourceExists(String string) {
        if (string == null) {
            return false;
        }
        return this.repository.getStringResource(string) != null;
    }

    @Override
    public Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(string)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        StringResource stringResource = this.repository.getStringResource(string);
        if (stringResource == null) {
            throw new ResourceNotFoundException("Could not locate resource '" + string + "'");
        }
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            byArray = stringResource.getBody().getBytes(stringResource.getEncoding());
            inputStream = new ByteArrayInputStream(byArray);
            return new InputStreamReader(inputStream, stringResource.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new VelocityException("Could not convert String using encoding " + stringResource.getEncoding(), unsupportedEncodingException);
        }
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        StringResource stringResource = null;
        boolean bl = true;
        stringResource = this.repository.getStringResource(resource.getName());
        if (stringResource != null) {
            bl = stringResource.getLastModified() != resource.getLastModified();
        }
        return bl;
    }

    @Override
    public long getLastModified(Resource resource) {
        StringResource stringResource = null;
        stringResource = this.repository.getStringResource(resource.getName());
        return stringResource != null ? stringResource.getLastModified() : 0L;
    }
}

