/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.carrot2.util.preprocessor.shaded.apache.commons.lang3.StringUtils;
import org.carrot2.util.preprocessor.shaded.apache.velocity.exception.ResourceNotFoundException;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.Resource;
import org.carrot2.util.preprocessor.shaded.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.ExtProperties;

public class URLResourceLoader
extends ResourceLoader {
    private String[] roots = null;
    protected HashMap templateRoots = null;
    private int timeout = -1;

    @Override
    public void init(ExtProperties extProperties) {
        this.log.trace("URLResourceLoader: initialization starting.");
        this.roots = extProperties.getStringArray("root");
        if (this.log.isDebugEnabled()) {
            for (String string : this.roots) {
                this.log.debug("URLResourceLoader: adding root '{}'", (Object)string);
            }
        }
        this.timeout = extProperties.getInt("timeout", -1);
        this.templateRoots = new HashMap();
        this.log.trace("URLResourceLoader: initialization complete.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(string)) {
            throw new ResourceNotFoundException("URLResourceLoader: No template name provided");
        }
        Reader reader = null;
        Throwable throwable = null;
        for (String string3 : this.roots) {
            InputStream inputStream = null;
            try {
                URL uRL = new URL(string3 + string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(this.timeout);
                uRLConnection.setReadTimeout(this.timeout);
                inputStream = uRLConnection.getInputStream();
                reader = this.buildReader(inputStream, string2);
                if (reader == null) continue;
                this.log.debug("URLResourceLoader: Found '{}' at '{}'", (Object)string, (Object)string3);
                this.templateRoots.put(string, string3);
                break;
            }
            catch (IOException iOException) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                this.log.debug("URLResourceLoader: Exception when looking for '{}' at '{}'", new Object[]{string, string3, iOException});
                if (throwable != null) continue;
                throwable = iOException;
            }
        }
        if (reader == null) {
            void var5_8;
            if (throwable == null) {
                String string4 = "URLResourceLoader: Resource '" + string + "' not found.";
            } else {
                String string5 = throwable.getMessage();
            }
            throw new ResourceNotFoundException((String)var5_8);
        }
        return reader;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        long l = this.getLastModified(resource);
        return l == 0L || l != resource.getLastModified();
    }

    @Override
    public long getLastModified(Resource resource) {
        String string = resource.getName();
        String string2 = (String)this.templateRoots.get(string);
        try {
            URL uRL = new URL(string2 + string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(this.timeout);
            uRLConnection.setReadTimeout(this.timeout);
            return uRLConnection.getLastModified();
        }
        catch (IOException iOException) {
            String string3 = "URLResourceLoader: '" + string + "' is no longer reachable at '" + string2 + "'";
            this.log.error(string3, (Throwable)iOException);
            throw new ResourceNotFoundException(string3, iOException);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }
}

