/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtProperties
extends Hashtable<String, Object> {
    private ExtProperties defaults;
    protected String file;
    protected String basePath;
    protected String fileSeparator;
    protected boolean isInitialized;
    protected static String include = "include";
    protected ArrayList keysAsListed;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    protected String interpolate(String string) {
        return this.interpolateHelper(string, null);
    }

    protected String interpolateHelper(String string, List arrayList) {
        if (string == null) {
            return null;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0 - END_TOKEN.length();
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = string.indexOf(START_TOKEN, n3 + END_TOKEN.length())) > -1 && (n2 = string.indexOf(END_TOKEN, n)) > -1) {
            Object object;
            stringBuilder.append(string.substring(n3 + END_TOKEN.length(), n));
            string2 = string.substring(n + START_TOKEN.length(), n2);
            if (arrayList.contains(string2)) {
                object = arrayList.remove(0).toString();
                arrayList.add(string2);
                StringBuilder stringBuilder2 = new StringBuilder();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stringBuilder2.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder2.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + (String)object + ": " + stringBuilder2.toString());
            }
            arrayList.add(string2);
            object = this.getProperty(string2);
            if (object != null) {
                stringBuilder.append(this.interpolateHelper(object.toString(), arrayList));
                arrayList.remove(arrayList.size() - 1);
            } else if (this.defaults != null && this.defaults.getString(string2, null) != null) {
                stringBuilder.append(this.defaults.getString(string2));
            } else {
                stringBuilder.append(START_TOKEN).append(string2).append(END_TOKEN);
            }
            n3 = n2;
        }
        stringBuilder.append(string.substring(n3 + END_TOKEN.length(), string.length()));
        return stringBuilder.toString();
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c != ',' && c != '\\') continue;
            stringBuilder.insert(i, '\\');
            ++i;
        }
        return stringBuilder.toString();
    }

    private static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length() - 1; ++i) {
            char c = stringBuilder.charAt(i);
            char c2 = stringBuilder.charAt(i + 1);
            if (c != '\\' || c2 != '\\') continue;
            stringBuilder.deleteCharAt(i);
        }
        return stringBuilder.toString();
    }

    private static int countPreceding(String string, int n, char c) {
        int n2;
        for (n2 = n - 1; n2 >= 0 && string.charAt(n2) == c; --n2) {
        }
        return n - 1 - n2;
    }

    private static boolean endsWithSlash(String string) {
        if (!string.endsWith("\\")) {
            return false;
        }
        return ExtProperties.countPreceding(string, string.length() - 1, '\\') % 2 == 0;
    }

    public ExtProperties() {
        try {
            this.fileSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        catch (SecurityException securityException) {
            this.fileSeparator = File.separator;
        }
        this.isInitialized = false;
        this.keysAsListed = new ArrayList();
    }

    public ExtProperties(String string) throws IOException {
        this(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtProperties(String string, String string2) throws IOException {
        try {
            this.fileSeparator = (String)AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        catch (SecurityException securityException) {
            this.fileSeparator = File.separator;
        }
        this.isInitialized = false;
        this.keysAsListed = new ArrayList();
        this.file = string;
        this.basePath = new File(string).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.load(fileInputStream);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2 != null) {
            this.defaults = new ExtProperties(string2);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String string) {
        include = string;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, null);
    }

    public synchronized void load(InputStream inputStream, String string) throws IOException {
        PropertiesReader propertiesReader = null;
        if (string != null) {
            try {
                propertiesReader = new PropertiesReader(new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (propertiesReader == null) {
            propertiesReader = new PropertiesReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        try {
            while (true) {
                String string2;
                if ((string2 = propertiesReader.readProperty()) == null) {
                    return;
                }
                int n = string2.indexOf(61);
                if (n <= 0) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if ("".equals(string4)) continue;
                if (this.getInclude() != null && string3.equalsIgnoreCase(this.getInclude())) {
                    File file = null;
                    if (string4.startsWith(this.fileSeparator)) {
                        file = new File(string4);
                    } else {
                        if (string4.startsWith("." + this.fileSeparator)) {
                            string4 = string4.substring(2);
                        }
                        file = new File(this.basePath + string4);
                    }
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(string3, string4);
            }
        }
        finally {
            this.isInitialized = true;
        }
    }

    public Object getProperty(String string) {
        Object v = this.get(string);
        if (v == null && this.defaults != null) {
            v = this.defaults.get(string);
        }
        return v;
    }

    public void addProperty(String string, Object object) {
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.indexOf(",") > 0) {
                PropertiesTokenizer propertiesTokenizer = new PropertiesTokenizer(string2);
                while (propertiesTokenizer.hasMoreTokens()) {
                    String string3 = propertiesTokenizer.nextToken();
                    this.addPropertyInternal(string, ExtProperties.unescape(string3));
                }
            } else {
                this.addPropertyInternal(string, ExtProperties.unescape(string2));
            }
        } else {
            this.addPropertyInternal(string, object);
        }
        this.isInitialized = true;
    }

    private void addPropertyDirect(String string, Object object) {
        if (!this.containsKey(string)) {
            this.keysAsListed.add(string);
        }
        this.put(string, object);
    }

    private void addPropertyInternal(String string, Object object) {
        Object v = this.get(string);
        if (v instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.add(v);
            vector.add(object);
            this.put(string, vector);
        } else if (v instanceof List) {
            ((List)v).add(object);
        } else {
            if (!this.containsKey(string)) {
                this.keysAsListed.add(string);
            }
            this.put(string, object);
        }
    }

    public void setProperty(String string, Object object) {
        this.clearProperty(string);
        this.addProperty(string, object);
    }

    public synchronized void save(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(outputStream);
        if (string != null) {
            printWriter.println(string);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object v = this.get(string2);
            if (v != null) {
                Object object;
                if (v instanceof String) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("=");
                    ((StringBuilder)object).append(ExtProperties.escape((String)v));
                    printWriter.println(((StringBuilder)object).toString());
                } else if (v instanceof List) {
                    object = (List)v;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string2);
                        stringBuilder.append("=");
                        stringBuilder.append(ExtProperties.escape(string3));
                        printWriter.println(stringBuilder.toString());
                    }
                }
            }
            printWriter.println();
            printWriter.flush();
        }
    }

    public void combine(ExtProperties extProperties) {
        Iterator iterator = extProperties.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setProperty(string, extProperties.get(string));
        }
    }

    public void clearProperty(String string) {
        if (this.containsKey(string)) {
            for (int i = 0; i < this.keysAsListed.size(); ++i) {
                if (!this.keysAsListed.get(i).equals(string)) continue;
                this.keysAsListed.remove(i);
                break;
            }
            this.remove(string);
        }
    }

    public Iterator getKeys() {
        return this.keysAsListed.iterator();
    }

    public Iterator getKeys(String string) {
        Iterator iterator = this.getKeys();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String) || !((String)e).startsWith(string)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public ExtProperties subset(String string) {
        ExtProperties extProperties = new ExtProperties();
        Iterator iterator = this.getKeys();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String) || !((String)e).startsWith(string)) continue;
            if (!bl) {
                bl = true;
            }
            String string2 = null;
            string2 = ((String)e).length() == string.length() ? string : ((String)e).substring(string.length() + 1);
            extProperties.addPropertyDirect(string2, this.get(e));
        }
        if (bl) {
            return extProperties;
        }
        return null;
    }

    public void display() {
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.get(string);
            System.out.println(string + " => " + v);
        }
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Object v = this.get(string);
        if (v instanceof String) {
            return this.interpolate((String)v);
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(string, string2));
            }
            return this.interpolate(string2);
        }
        if (v instanceof List) {
            return this.interpolate((String)((List)v).get(0));
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a String object");
    }

    public Properties getProperties(String string) {
        return this.getProperties(string, new Properties());
    }

    public Properties getProperties(String string, Properties properties) {
        String[] stringArray = this.getStringArray(string);
        Properties properties2 = new Properties(properties);
        for (String string2 : stringArray) {
            int n = string2.indexOf(61);
            if (n <= 0) {
                throw new IllegalArgumentException('\'' + string2 + "' does not contain an equals sign");
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            properties2.put(string3, string4);
        }
        return properties2;
    }

    public String[] getStringArray(String string) {
        List list;
        Object v = this.get(string);
        if (v instanceof String) {
            list = new Vector(1);
            list.add(v);
        } else if (v instanceof List) {
            list = (List)v;
        } else {
            if (v == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(string);
                }
                return new String[0];
            }
            throw new ClassCastException('\'' + string + "' doesn't map to a String/List object");
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        return stringArray;
    }

    public Vector getVector(String string) {
        return this.getVector(string, null);
    }

    public Vector getVector(String string, Vector vector) {
        Object v = this.get(string);
        if (v instanceof List) {
            return new Vector((List)v);
        }
        if (v instanceof String) {
            Vector vector2 = new Vector(1);
            vector2.add(v);
            this.put(string, vector2);
            return vector2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(string, vector);
            }
            return vector == null ? new Vector() : vector;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Vector object");
    }

    public List getList(String string) {
        return this.getList(string, null);
    }

    public List getList(String string, List list) {
        Object v = this.get(string);
        if (v instanceof List) {
            return new ArrayList((List)v);
        }
        if (v instanceof String) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(v);
            this.put(string, arrayList);
            return arrayList;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getList(string, list);
            }
            return list == null ? new ArrayList() : list;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a List object");
    }

    public boolean getBoolean(String string) {
        Boolean bl = this.getBoolean(string, null);
        if (bl != null) {
            return bl;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.getBoolean(string, (Boolean)bl);
    }

    public Boolean getBoolean(String string, Boolean bl) {
        Object v = this.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String string2 = this.testBoolean(((String)v).trim());
            Boolean bl2 = Boolean.valueOf(string2);
            this.put(string, bl2);
            return bl2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(string, bl);
            }
            return bl;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Boolean object");
    }

    public String testBoolean(String string) {
        String string2;
        switch (string2 = string.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "on": 
            case "yes": {
                return "true";
            }
            case "false": 
            case "off": 
            case "no": {
                return "false";
            }
        }
        return null;
    }

    public byte getByte(String string) {
        Byte by = this.getByte(string, null);
        if (by != null) {
            return by;
        }
        throw new NoSuchElementException('\'' + string + " doesn't map to an existing object");
    }

    public byte getByte(String string, byte by) {
        return this.getByte(string, (Byte)by);
    }

    public Byte getByte(String string, Byte by) {
        Object v = this.get(string);
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof String) {
            Byte by2 = Byte.valueOf((String)v);
            this.put(string, by2);
            return by2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(string, by);
            }
            return by;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Byte object");
    }

    public short getShort(String string) {
        Short s = this.getShort(string, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public short getShort(String string, short s) {
        return this.getShort(string, (Short)s);
    }

    public Short getShort(String string, Short s) {
        Object v = this.get(string);
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof String) {
            Short s2 = Short.valueOf((String)v);
            this.put(string, s2);
            return s2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(string, s);
            }
            return s;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Short object");
    }

    public int getInt(String string) {
        return this.getInteger(string);
    }

    public int getInt(String string, int n) {
        return this.getInteger(string, n);
    }

    public int getInteger(String string) {
        Integer n = this.getInteger(string, null);
        if (n != null) {
            return n;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public int getInteger(String string, int n) {
        Integer n2 = this.getInteger(string, null);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public Integer getInteger(String string, Integer n) {
        Object v = this.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            Integer n2 = Integer.valueOf((String)v);
            this.put(string, n2);
            return n2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(string, n);
            }
            return n;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Integer object");
    }

    public long getLong(String string) {
        Long l = this.getLong(string, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public long getLong(String string, long l) {
        return this.getLong(string, (Long)l);
    }

    public Long getLong(String string, Long l) {
        Object v = this.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            Long l2 = Long.valueOf((String)v);
            this.put(string, l2);
            return l2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(string, l);
            }
            return l;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Long object");
    }

    public float getFloat(String string) {
        Float f = this.getFloat(string, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public float getFloat(String string, float f) {
        return this.getFloat(string, Float.valueOf(f)).floatValue();
    }

    public Float getFloat(String string, Float f) {
        Object v = this.get(string);
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof String) {
            Float f2 = new Float((String)v);
            this.put(string, f2);
            return f2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(string, f);
            }
            return f;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Float object");
    }

    public double getDouble(String string) {
        Double d = this.getDouble(string, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    public double getDouble(String string, double d) {
        return this.getDouble(string, (Double)d);
    }

    public Double getDouble(String string, Double d) {
        Object v = this.get(string);
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof String) {
            Double d2 = new Double((String)v);
            this.put(string, d2);
            return d2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(string, d);
            }
            return d;
        }
        throw new ClassCastException('\'' + string + "' doesn't map to a Double object");
    }

    public static ExtProperties convertProperties(Properties properties) {
        ExtProperties extProperties = new ExtProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            extProperties.setProperty(string, properties.getProperty(string));
        }
        return extProperties;
    }

    public static ExtProperties convertProperties(Map map) {
        ExtProperties extProperties = new ExtProperties();
        for (Map.Entry entry : map.entrySet()) {
            extProperties.setProperty(String.valueOf(entry.getKey()), entry.getValue());
        }
        return extProperties;
    }

    static class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        @Override
        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            StringBuilder stringBuilder = new StringBuilder();
            while (this.hasMoreTokens()) {
                String string = super.nextToken();
                if (ExtProperties.endsWithSlash(string)) {
                    stringBuilder.append(string.substring(0, string.length() - 1));
                    stringBuilder.append(DELIMITER);
                    continue;
                }
                stringBuilder.append(string);
                break;
            }
            return stringBuilder.toString().trim();
        }
    }

    static class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.readLine();
            while (string != null) {
                if ((string = string.trim()).length() != 0 && string.charAt(0) != '#') {
                    if (ExtProperties.endsWithSlash(string)) {
                        string = string.substring(0, string.length() - 1);
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append(string);
                        return stringBuilder.toString();
                    }
                }
                string = this.readLine();
            }
            return null;
        }
    }
}

